<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (DB_TOOL_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	require("__define_csv-import.php");
	ini_set("memory_limit", MEMORY_LIMIT_INI_SET);			//メモリサイズ
	ini_set("max_execution_time", MAX_EXECUTION_TIME_INI_SET);	//最大実行時間
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<title>MySQL管理ツール：CSVインポート</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/db_tools.css?20091018">
</head>
<body>
<?php
	if (($dbname = $_GET['db']) == '') {
		error_exit('データベース名なし');
	}
	if (($tblname = $_GET['tb']) == '') {
		error_exit('テーブル名なし');
	}
	$con = @mysql_connect(_DB_SERVER, _DB_SCHEMA_USERNAME, _DB_SCHEMA_PASSWORD);
	if ($con == False) {
		error_exit('データベース接続エラー');
	}
	mysql_query('set names utf8', $con);
	if (!mysql_select_db($dbname)) {
		error_exit('データベース選択エラー');
	}
	if (!mysql_query('desc '.$tblname)) {
		error_exit ($tblname.'：テーブル選択エラー');
	}
	$con = mysql_close($con);
?>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">MySQL管理ツール：CSVインポート</span>
<a class="a_cancel_back" href='mysql-database.php'>データベース一覧に戻る</a>
<a class="a_cancel_back" href='mysql-database.php?db=<?= $dbname ?>'>テーブル一覧に戻る</a>
<a class="a_cancel_back" href='mysql-table-list.php?db=<?= $dbname ?>&tb=<?= $tblname?>'>データ表示に戻る</a>
</p>
<p class="subtitle">データベース：<span class="db_name"><?= $dbname ?></span>&nbsp;&nbsp;
テーブル：<span class="tbl_name"><?= $tblname ?></span>
</p>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $dbname ?>&tb=<?= $tblname ?>" enctype="multipart/form-data">
<p style="color: #9d974b">
※ デリミッタ(区切り文字)はカンマ(&nbsp;,&nbsp;)、文字列の囲みはダブルクォーテーション(")のみサポート。<br>
※ 文字コードは、Shift-JIS、UTF-8、EUCなど自動判別します。
</p>
<table>
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" name="filename" size=40 style="button-font-size:small">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
	</td>
</tr>
</table>
</form>
<?php
if ($_POST) {
	if (($csv_file = post_check('filename')) == True) {
		if (!($csv_file_name = csv_upload($csv_file))) {
			error_exit('csvファイルにデータがありません。');
		}
		if (!$_POST['import']) {
?>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $dbname ?>&tb=<?= $tblname ?>">
<div style="margin: 10px 0 0 50px;">
<input type="submit" name="import" value="このデータをインポートする">&nbsp;&nbsp;&nbsp;&nbsp;
<label><input type="checkbox" name="全角変換" value="YES" checked>半角カナを全角カナに変換する</label>
</div>
</form>
<?php
		}
		if (($csv_file = post_check('filename')) == CSV_FILE_EXIST) {
			$import_cnt = database_import($csv_file_name, $dbname, $tblname);
?>
	<br>インポート件数：<span class="mp_rowcnt"><?= $import_cnt ?></span>件<br><br>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='mysql-table-list.php?db=<?= $dbname ?>&tb=<?= $tblname?>' target="_blank">テーブル データ表示</a>
<?php
		}
	}
}
?>
<br>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function csv_upload($csv_file) {
	if ($csv_file == CSV_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", CSV_IMPORT_FOLDER, CSV_FILE_NAME);
		$readFile = CSV_IMPORT_FOLDER.$attachFile;
	} else {
		$readFile = CSV_IMPORT_FOLDER.CSV_FILE_NAME;
	}
	if (list_table($readFile)) {
		return $readFile;
	} else {
		return false;
	}
}
function list_table($readFile) {
	$numRows = 0;
	if (!($contents = file_get_contents($readFile))) return false;
	file_put_contents($readFile, mb_convert_kana(mb_convert_encoding($contents, 'UTF-8', MB_CONVERT_ENCODING_AUTO),'a'));
		// UTF-8に変換： fgetcsvはShift-JISでは正常処理できない
		// 全角英数字を半角英数字に変換する： fgetcsvは全角英数字を正常処理できない
	$handle = fopen($readFile, 'r');
	while (($data = fgetcsv($handle)) !== FALSE) {
		$numCols = count($data);
		$numRows++;
	}
	fclose($handle);
	if ($numRows < 2 || $numCols < 1) return False;
	if ($numRows > 6) {
		$viewRows = 6;
	} else {
		$viewRows = $numRows;
	}
?>
<p>レコード件数：<span class="mp_rowcnt"><?= $numRows-1 ?></span>件
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: #808080">(先頭の<?= $viewRows-1 ?>件表示)</span></p>
<table class="excel_table" cellspacing=1>
	<thead>
		<tr>
<?php
	$handle = fopen($readFile, 'r');
	if (($data = fgetcsv($handle)) !== FALSE) {
		for ($col = 0; $col < $numCols; $col++) {
?>
			<th><?= my_htmlspecialchars(mb_convert_encoding($data[$col],'UTF-8',MB_CONVERT_ENCODING_AUTO)) ?></th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	}
	$row = 1;
	while (($data = fgetcsv($handle)) !== FALSE && $row < $viewRows) {
?>
		<tr>
<?php
		for ($col = 0; $col < $numCols; $col++) {
?>
			<td><?= my_htmlspecialchars(mb_convert_encoding($data[$col],'UTF-8',MB_CONVERT_ENCODING_AUTO)) ?></td>
<?php
		}
?>
		</tr>
<?php
		$row++;
	}
	fclose($handle);
?>
	</tbody>
</table>
<?php
	return True;
}
function database_import($csv_file_name, $dbname, $tblname) {
	$handle = fopen($csv_file_name, 'r');
	if (($data = fgetcsv($handle)) !== FALSE) {
		$numCols = count($data);
	}
	$con = @mysql_connect(_DB_SERVER, _DB_SCHEMA_USERNAME, _DB_SCHEMA_PASSWORD);
	if ($con == False) {
		error_exit('データベース接続エラー');
	}
	mysql_query('set names utf8', $con);
	if (!mysql_select_db($dbname)) {
		error_exit('データベース選択エラー');
	}
	$colname = '';
	for ($col = 0; $col < $numCols; $col++) {
		if ($colname <> '') $colname .= ',';
		$colname .= str_for_mysql($data[$col]);
	}
	$cnt = 0;
	while (($data = fgetcsv($handle)) !== FALSE) {
		$coldata = '';
		for ($col = 0; $col < $numCols; $col++) {
			if ($coldata <> '') $coldata .= ',';
			if ($_POST['全角変換'] == 'YES') {
				$coldata .= '"'. str_for_mysql(mb_convert_kana($data[$col], "sKV")) . '"';
			} else {
				$coldata .= '"'. str_for_mysql($data[$col]) . '"';
			}
		}
		$sql = "insert into " . $tblname;
		$sql .= " (" . $colname . ")";
		$sql .= " values (" . $coldata .")";
		++$cnt;
		if (!mysql_query($sql)) {
			error_msg(mysql_error());
			error_exit($cnt.'件目のレコードのインポートでエラーが発生しました。');
		}
	}
	$con = mysql_close($con);
	fclose($handle);
	return $cnt;
}
function post_check($filename) {
	if ($_POST['upload']) {
		if (strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.csv' or strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.txt') {
			return CSV_FILE_UPLOAD;
		} else {
			error_exit('拡張子が.CSVではありません。');
			return false;
		}
	} elseif ($_POST['import']) {
		if (file_exists(CSV_IMPORT_FOLDER.CSV_FILE_NAME)) {
			return CSV_FILE_EXIST;
		} else {
			return false;
		}
	}
}
?>
