﻿// JavaScript generated by Wadachi Version 3.62
var track = new Array();
var route = new Array();
var waypoints = new Array();
var markerIcon = new Array();
var markerShadow;
var markers = new Array();
var timeLine = new Array();
var map;
var popupWindow = new google.maps.InfoWindow({});
var currPoint = 0;
var currTrack = 0;
var playTimer;
var playing = false;
var centerPointer;
var infoPanel;
var showMeterPanel = true;
var realTimePlay = false;
function displayMap(lat1, lng1, lat2, lng2) {
	var mapOptions = {
		/*<Center>*/
		/*<Zoom>*/
		mapTypeControl: true,
		mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR},
		navigationControl: true,
		navigationControlOptions: {style: google.maps.NavigationControlStyle.DEFAULT},
		scaleControl: true,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		overviewMapControl: true,
		overviewMapControlOptions: {opened: true},
		disableDoubleClickZoom: false,
		scrollwheel: true,
		keyboardShortcuts: true
	};
	map = new google.maps.Map(document.getElementById("map"), mapOptions);
	map.fitBounds(new google.maps.LatLngBounds(new google.maps.LatLng(lat1, lng1), new google.maps.LatLng(lat2, lng2)));
	var pointerIcon = new google.maps.MarkerImage(
		'js/center_pointer.png',
		new google.maps.Size(32, 32),
		new google.maps.Point(0, 0),
		new google.maps.Point(15, 15)
	);
	centerPointer = new google.maps.Marker({
		clickable: false,
		flat: true,
		icon: pointerIcon,
		zIndex: 9999
	});
	setIcon();
	setWaypoints();
	setRoutes();
	drawWaypoints(true, true, true, true);
	setTracks();
	/*<InitTimeLine>*/
}
function setRoutes() {
/*<RouteList>*/
}
function TrackPoint(lat, lon, dist, height, speed, hr, cad, time, dist_total, speed_total) {
	this.latlng = new google.maps.LatLng(lat, lon);
	this.dist = parseFloat(dist);
	this.height = parseInt(height*1000);	// ok.2nd
	this.speed = speed;			// ok.2nd
	this.hr = parseInt(hr);
	this.cad = parseInt(cad);
	this.time = new Date(time);
	this.dist_total = parseFloat(dist_total);	// ok.2nd
	this.speed_total = speed_total;			// ok.2nd
}
function drawTrack(n, color, width, opacity) {
	var tp = new Array();
	var i;
	for (i=0; i<track[n].length; i++) {
		tp.push(track[n][i].latlng);
	}
	var trackPath = new google.maps.Polyline({
		path: tp,
		strokeColor: color,
		strokeOpacity: opacity,
		strokeWeight: width
	});
	trackPath.setMap(map);
}
function drawRoute(color, width, opacity) {
	var routePath = new google.maps.Polyline({
		path: route,
		strokeColor: color,
		strokeOpacity: opacity,
		strokeWeight: width
	});
	routePath.setMap(map);
}
function drawWaypoints(showDate, showTime, showLocation, showHeight) {
	var i;
	for (i=0; i<waypoints.length; i++) {
		markers[i] = createMarker(waypoints[i], showDate, showTime, showLocation, showHeight, i);
	}
}
function initTimeLine() {
	var i;
	for (i=0; i<track.length; i++) {
		timeLine[i] = new TimeLine("timeLine" + i);
		var chartType = document.getElementById("chartType" + i);
		if (chartType) {
			drawTimeLine(i, chartType.value);
		}
	}
}
function setIcon() {
	var imgPath = "http://maps.google.com/mapfiles/ms/icons/";
	markerIcon[0] = new google.maps.MarkerImage(imgPath + "red.png");
	markerIcon[1] = new google.maps.MarkerImage(imgPath + "orange.png");
	markerIcon[2] = new google.maps.MarkerImage(imgPath + "yellow.png");
	markerIcon[3] = new google.maps.MarkerImage(imgPath + "green.png");
	markerIcon[4] = new google.maps.MarkerImage(imgPath + "blue.png");
	markerIcon[5] = new google.maps.MarkerImage(imgPath + "pink.png");
	markerIcon[6] = new google.maps.MarkerImage(imgPath + "lightblue.png");
	markerIcon[7] = new google.maps.MarkerImage(imgPath + "red-dot.png");
	markerIcon[8] = new google.maps.MarkerImage(imgPath + "orange-dot.png");
	markerIcon[9] = new google.maps.MarkerImage(imgPath + "yellow-dot.png");
	markerIcon[10] = new google.maps.MarkerImage(imgPath + "green-dot.png");
	markerIcon[11] = new google.maps.MarkerImage(imgPath + "blue-dot.png");
	markerIcon[12] = new google.maps.MarkerImage(imgPath + "pink-dot.png");
	markerIcon[13] = new google.maps.MarkerImage(imgPath + "ltblue-dot.png");
	markerShadow = new google.maps.MarkerImage(
		imgPath + "msmarker.shadow.png",
		new google.maps.Size(59, 32),
		new google.maps.Point(0, 0),
		new google.maps.Point(16, 31)
	);
}
function MarkerInfo(lat, lon, height, date, time, icon, name, image, url, desc, largeImage, point_num, marker_dist, marker_speed, marker_dist_total, marker_speed_ave) {
	this.point = new google.maps.LatLng(parseFloat(lat), parseFloat(lon));
	this.height = parseInt(height);
	this.date = date;
	this.time = time;
	this.icon = icon;
	this.name = name;
	this.image = image;
	this.url = url;
	this.desc = desc;
	this.largeImage = largeImage;
	this.point_num = point_num;			// ok.2nd
	this.marker_dist = marker_dist;			// ok.2nd
	this.marker_speed = marker_speed;		// ok.2nd
	this.marker_dist_total = marker_dist_total;	// ok.2nd
	this.marker_speed_ave = marker_speed_ave;	// ok.2nd
}
MarkerInfo.prototype.getHtml = MarkerInfo_getHtml;
function MarkerInfo_getHtml(showDate, showTime, showLocation, showHeight, imageLoaded) {
	var html;
	html = '<div class="marker">';
	// html += '<div class="marker_subject">' + this.name + '</div>';		// ok.2nd
	if (showDate || showTime) {
		html += '<div class="marker_time">';
		if (showDate) {
			html += this.date;
		}
		if (showTime) {
			if (showDate) {
				html += '&nbsp;';
			}
			html += this.time;
		}
		html += '</div>';
	}
	if (showLocation || showHeight) {
		html += '<div class="marker_location">';
		if (showLocation) {
			var prefix_lat = (this.point.lat() >= 0) ? 'N' : 'S';
			var prefix_lon = (this.point.lng() >= 0) ? 'E' : 'W';
			html += prefix_lat + Math.abs(this.point.lat()).toFixed(6) + ', ' + prefix_lon + Math.abs(this.point.lng()).toFixed(6);
		}
		if (showHeight) {
			if (showLocation) {
				html += '&nbsp;';
			}
			html += '標高： ' + this.height + ' m';
		}
		html += '</div>';
		html += '<div class="marker_url"><a href="http://maps.google.com/maps?q=' + this.point.lat() + ',' + this.point.lng();
		html += '" target="_blank">→ Googleマップ</a></div>';
	}
	if (this.image != '') {
		var ext = getFileExt(this.image);
		if (ext == 'jpg' || ext == 'jpeg' || ext == 'gif' || ext == 'png') {
			if (imageLoaded) {
				if (this.largeImage != '') {
					html += '<div class="marker_image"><a href="' + this.largeImage + '" target="largeImage"><img src="' + this.image + '" /></a></div>';
				}
				else {
					html += '<div class="marker_image"><img src="' + this.image + '" /></div>';
				}
			}
		} else {
			html += '<div class="marker_url"><a href="' + this.image + '" target="refer">関連ファイル</a></div>';
		}
	}
	if (this.url != '') {
		html += '<div class="marker_url"><a href="' + this.url + '" target="refer">関連リンク</a></div>';
	}
	if (this.desc != '') {
		html += '<div class="marker_desc">' + this.desc + '</div>';
	}
	/* ok.2nd */
	if (this.marker_dist != 0) {
		html += '<div class="marker_desc">前マーカーからの距離： ' + this.marker_dist + ' km</div>';
		html += '<div class="marker_desc">前マーカーからの平均速度： ' + this.marker_speed + ' km/h</div>';
		html += '<div class="marker_desc">出発地点からの距離： ' + this.marker_dist_total + ' km</div>';
		html += '<div class="marker_desc">出発地点からの平均速度： ' + this.marker_speed_ave + ' km/h</div>';
	}
	html += '</div>';
	return html;
}
function createMarker(markerInfo, showDate, showTime, showLocation, showHeight, no) {
	var marker = new google.maps.Marker({
		position: markerInfo.point,
		map: map,
		icon: 'http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld='+no+'|FA8072|000000',
		shadow: markerShadow,
		title: markerInfo.name
	});
	google.maps.event.addListener(marker, 'click', function() {
		if (markerInfo.image != '') {
			var ext = getFileExt(markerInfo.image);
			if (ext == 'jpg' || ext == 'gif' || ext == 'png') {
				var image = new Image();
				image.src = markerInfo.image;
				if (image.complete) {
					popupWindow.setContent(markerInfo.getHtml(showDate, showTime, showLocation, showHeight, true));
					popupWindow.open(map, marker);
				}
				else {
					image.onload = function() {
						popupWindow.setContent(markerInfo.getHtml(showDate, showTime, showLocation, showHeight, true));
						popupWindow.open(map, marker);
					}
					image.onerror = function() {
						popupWindow.setContent(markerInfo.getHtml(showDate, showTime, showLocation, showHeight, false));
						popupWindow.open(map, marker);
					}
				}
				return;
			}
		}
		if (markerInfo.point_num < point_max) {
			currPoint = markerInfo.point_num;	// ok.2nd
		} else {
			currPoint = 0;		// ok.2nd
		}
		popupWindow.setContent(markerInfo.getHtml(showDate, showTime, showLocation, showHeight, false));
		popupWindow.open(map, marker);
	});
	return marker;
}
function popupMarker(num, ponit) {
	if (currPoint < point_max) {
		currPoint = ponit;	// ok.2nd
	} else {
		currPoint = 0;		// ok.2nd
	}
	google.maps.event.trigger(markers[num], 'click');
}
function getFileExt(filepath) {
	var strArray = filepath.split('.');
	return strArray[strArray.length - 1].toLowerCase();
}
function getBrowser() {
	var agent = navigator.userAgent;
	if (agent.indexOf('Safari') >= 0) {
		return 'Safari';
	} else if (agent.indexOf('Opera') >= 0) {
		return 'Opera';
	} else if (agent.indexOf('Gecko') >= 0) {
		return 'Mozilla';
	} else if (agent.indexOf('MSIE') >= 0) {
		return 'MSIE';
	} else {
		return 'other';
	}
}
function playRoute() {
	var count = 0;
	for (i=0; i<track.length; i++) {
		count += track[i].length;
	}
	if (count > 1 && !playing) {
		centerPointer.setMap(map);
		if (showMeterPanel) {
			infoPanel = new InfoPanel();
			map.controls[google.maps.ControlPosition.RIGHT].push(infoPanel.getDiv());
		}
		playing = true;
		goForward();
	}
}
function goForward() {
	var waittime;
	var pos = track[currTrack][currPoint].latlng;
	if (pantoFlg != 'no') {			// ok.2nd
		map.panTo(pos);
	}
	centerPointer.setPosition(pos);
	if (showMeterPanel) {
		displayInfoPanel(currTrack, currPoint);
	}
	if (currPoint < track[currTrack].length - 1) {
		if (realTimePlay) {
			waittime = track[currTrack][currPoint+1].time.getTime() - track[currTrack][currPoint].time.getTime();
			waittime /= parseFloat(document.getElementById("playSpeed").value);
		} else {
			waittime = 1000 / parseFloat(document.getElementById("playSpeed").value);
		}
		currPoint++;
	} else {
		if (currTrack < track.length - 1) {
			waittime = 1000;
			currTrack++;
			currPoint = 0;
		} else {
			window.clearTimeout(playTimer);
			playing = false;
			centerPointer.setMap(null);
			if (showMeterPanel) {
				map.controls[google.maps.ControlPosition.RIGHT].pop();
			}
			return;
		}
	}
	playTimer = window.setTimeout("goForward()", waittime);
}
function stopRoute() {
	if (playing) {
		window.clearTimeout(playTimer);
		playing = false;
		centerPointer.setMap(null);
		if (showMeterPanel) {
			map.controls[google.maps.ControlPosition.RIGHT].pop();
		}
	}
}
function rewindRoute() {
	currTrack = 0;
	currPoint = 0;
	map.setCenter(track[currTrack][currPoint].latlng);
}
function prevTrack() {
	if (currTrack > 0) {
		currTrack--;
		currPoint = 0;
		map.setCenter(track[currTrack][currPoint].latlng);
	}
}
function nextTrack() {
	if (currTrack < track.length - 1) {
		currTrack++;
		currPoint = 0;
		map.setCenter(track[currTrack][currPoint].latlng);
	}
}
function InfoPanel() {
	this.container = document.createElement('div');
	this.container.style.padding = '5px';
	var outerFrame = document.createElement('div');
	outerFrame.style.width = '240px';
	outerFrame.style.height = '70px';
	if (getBrowser() == 'MSIE') {
		outerFrame.style.backgroundColor = '#FFFFFF';
	} else {
		outerFrame.style.backgroundColor = 'rgba(255, 255, 255, 0.7)';
	}
	outerFrame.style.border = '1px solid black';
	outerFrame.innerHTML = '<div id="time"></div><div id="speed"></div><div id="height"></div>';
	this.container.appendChild(outerFrame);
	this.getDiv = function() {
		return this.container;
	}
	this.writeTime = function(date) {
		var hour = date.getHours();
		var min = date.getMinutes();
		var sec = date.getSeconds();
		if (hour < 10) hour = "0" + hour;
		if (min < 10) min = "0" + min;
		if (sec < 10) sec = "0" + sec;
		var timePanel = document.getElementById("time");
		timePanel.innerHTML = '時刻：' + hour + ':' + min + ':' + sec;
	}
	this.writeSpeed = function(distance, speed) {
		var speedPanel = document.getElementById("speed");
		var distStr = distance.toFixed(3);
		var speedStr = speed.toFixed(1);
		if (distStr < 10) distStr = "&nbsp;&nbsp;&nbsp;" + distStr;
		else if (distStr < 100) distStr = "&nbsp;&nbsp;" + distStr;
		else if (distStr < 1000) distStr = "&nbsp;" + distStr;
		if (speedStr < 10) speedStr = "&nbsp;&nbsp;" + speedStr;
		else if (speedStr < 100) speedStr = "&nbsp;" + speedStr;
		speedPanel.innerHTML = '距離：' + distStr + 'km&nbsp;&nbsp;速度：' + speedStr + 'km/h';
	}
	this.writeHeight = function(height, gradient) {
		var heightStr = height.toString();
		if (height > -100) {
			if (height <= -10) heightStr = "&nbsp;" + heightStr;
			else if (height < 0) heightStr = "&nbsp;&nbsp;" + heightStr;
			else if (height < 10) heightStr = "&nbsp;&nbsp;&nbsp;" + heightStr;
			else if (height < 100) heightStr = "&nbsp;&nbsp;" + heightStr;
			else if (height < 1000) heightStr = "&nbsp;" + heightStr;
		}
		var gradStr = Math.abs(gradient).toFixed(1);
		if (gradStr < 10) gradStr = "&nbsp;" + gradStr;
		if (gradient >= 0) {
			gradStr = '↑' + gradStr;
		} else {
			gradStr = '↓' + gradStr;
		}
		var heightPanel = document.getElementById("height");
		heightPanel.innerHTML = '標高：' + heightStr + 'm&nbsp;&nbsp;勾配：' + gradStr + '%';
	}
}
function displayInfoPanel(ntrack, npoint) {
	infoPanel.writeTime(track[ntrack][npoint].time);
	var distance = 0;
	var speed = 0;
	var timespan;
	var gradient = 0;
	var elevation;
	if (npoint > 0) {
		distance = track[ntrack][npoint].dist - track[ntrack][npoint - 1].dist;
		timespan = track[ntrack][npoint].time.getTime() - track[ntrack][npoint - 1].time.getTime();
		elevation = track[ntrack][npoint].height - track[ntrack][npoint - 1].height;
		if (timespan > 0) {
			speed = 3600000 * distance / timespan;
		}
		if (distance > 0) {
			gradient = elevation / distance / 10;
		}
	}
	speed = Math.round(speed * 10) / 10;
//	infoPanel.writeSpeed(track[ntrack][npoint].dist,speed);
//	infoPanel.writeSpeed(track[ntrack][npoint].dist,track[ntrack][npoint].speed);		// ok.2nd
	infoPanel.writeSpeed(track[ntrack][npoint].dist_total,track[ntrack][npoint].speed);		// ok.2nd
	infoPanel.writeHeight(track[ntrack][npoint].height,gradient);
}
function TimeLine(container) {
	this.chart = new google.visualization.AnnotatedTimeLine(document.getElementById(container));
	this.draw = function(data, unit, scaleType) {
		this.chart.draw(data, {dateFormat: "yyyy/MM/dd HH:mm:ss", allValuesSuffix: unit, scaleType: scaleType});
	}
	this.draw2columns = function(data, scaleType) {
		this.chart.draw(data, {dateFormat: "yyyy/MM/dd HH:mm:ss", scaleType: scaleType, scaleColumns: [0,1]});
	}
}
function drawTimeLine(ntrack, type) {
	var data = new google.visualization.DataTable();
	data.addColumn("datetime", "Time");
	if (type == "height") {
		data.addColumn("number", "標高");
		var i;
		for (i=0; i<track[ntrack].length; i++) {
			data.addRow([track[ntrack][i].time, track[ntrack][i].height]);
		}
		timeLine[ntrack].draw(data, "m", "maximized");
	} else if (type == "speed") {
		data.addColumn("number", "速度");
		var i;
		for (i=0; i<track[ntrack].length; i++) {
			data.addRow([track[ntrack][i].time, calcSpeed(ntrack, i)]);
		}
		timeLine[ntrack].draw(data, "km/h", "fixed");
	} else if (type == "distance") {
		data.addColumn("number", "距離");
		var i;
		for (i=0; i<track[ntrack].length; i++) {
			data.addRow([track[ntrack][i].time, track[ntrack][i].dist]);
		}
		timeLine[ntrack].draw(data, "km", "fixed");
	} else if (type == "height_speed") {
		data.addColumn("number", "標高");
		data.addColumn("number", "速度");
		var i;
		for (i=0; i<track[ntrack].length; i++) {
			data.addRow([track[ntrack][i].time, track[ntrack][i].height, calcSpeed(ntrack, i)]);
		}
		timeLine[ntrack].draw2columns(data, "allmaximized");
	}
}
function calcSpeed(ntrack, npoint) {
	var speed = 0;
	if (npoint > 0) {
		var distance = track[ntrack][npoint].dist - track[ntrack][npoint-1].dist;
		var timespan = track[ntrack][npoint].time.getTime() - track[ntrack][npoint-1].time.getTime();
		if (timespan > 0) {
			speed = 3600000 * distance / timespan;
		}
	}
	return speed;
}
