<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (DB_TOOL_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<meta name="description" content="PHPサーバー変数一覧">
<meta name="keywords" content="PHPサーバー変数">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<title>PHPサーバー変数一覧</title>
<style>
table {
	margin-top: 5px;
	border-collapse: separate;
	border-style: solid;
	border-width: 1px;
	border-color: #a0a0a0;
	background-color: #a0a0a0;
}
td {
	color: #000000;
	border-style: none;
	border-width: 1px;
	border-color: #a0a0a0;
	background-color: #f8ffff;
	padding: 0px;
}
.key {
	color: #00f;
}
.other {
	color: #f00;
}
.value {
}
</style>
</head>
<body>
<p>
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">PHPサーバー変数($_SERVER)一覧</span>
</p>
<?php
/*
	asort() 　－　連想配列の値で昇順にソート
	arsort()　－　連想配列の値で降順にソート
	ksort() 　－　連想配列のインデックスで昇順にソート
	krsort()　－　連想配列のインデックスで降順にソート
*/
	ksort($_SERVER);
?>
<table cellspacing=1>
<?php
foreach ($_SERVER as $key => $value){
?>
	<tr><td class="key"><?= $key ?></td><td class="value" style="word-break:break-all;"><?= my_htmlspecialchars($value) ?></td></tr>
<?php
}
/*
	echo php_uname('s');
		Windows 95/98
		Windows NT
		Linux
		FreeBSD
		HP-UX
		AIX
		IRIX64
		SunOS
		Darwin
		Mac
*/
?>
	<tr><td class="other">echo php_uname('s')</td><td class="value" style="word-break:break-all;"><?= php_uname('s') ?></td></tr>
</table>
</body>
</html>
