/* instruction_inc.h
   Copyright (C) 2005-2008 freebeans <freebeans@xqb.biglobe.ne.jp>.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

// ߎs switch includet@C

#define	EXECUTOR(inst)	break; \
						case inst:
#define EXECUTOR_ALIAS(inst)	case inst:

/**
 * baload, saload, iaload, faload, laloadߐp}N
 */
#define EXECUTE_PRIMITIVE_ALOAD_BODY(name, type, PUSHTYPE) \
{ \
	jint index; \
	PEEK_STACK_DATA(current_frame, 0, jint, index); \
	jobject ref; \
	PEEK_STACK_DATA(current_frame, 1, jobject, ref); \
	if (ref == NULL) { \
		THROW("java/lang/NullPointerException", NULL); \
	} \
	if (index < 0 || index >= get_array_length((jarray) ref)) { \
	    STORE_CONTEXT(); \
		throw_exception_int(current_frame, "java/lang/ArrayIndexOutOfBoundsException", index); \
		CHECK_EXCEPTION;	\
	} \
	type * aptr = (type *) get_object_body(ref); \
	type value = aptr[index]; \
	POP_DISCARD_N(current_frame, 2); \
	PUSH_##PUSHTYPE##(current_frame, value); \
}

/*
}Ngp)

EXECUTE_PRIMITIVE_ALOAD_BODY(baload, jbyte, INT);
EXECUTE_PRIMITIVE_ALOAD_BODY(saload, jshort, INT);
EXECUTE_PRIMITIVE_ALOAD_BODY(caload, jchar, INT);
EXECUTE_PRIMITIVE_ALOAD_BODY(iaload, jint, INT);
EXECUTE_PRIMITIVE_ALOAD_BODY(laload, jlong, LONG);

*/

/**
 * iastore, bastore, castore, sastore, fastore, lastore
 */
#define EXECUTE_PRIMITIVE_ASTORE_BODY(name, type, POPTYPE) \
{ \
	type value; \
	POP_##POPTYPE##(current_frame, value); \
	jint index; \
	PEEK_STACK_DATA(current_frame, 0, jint, index); \
	jobject ref; \
	PEEK_STACK_DATA(current_frame, 1, jobject, ref); \
	if (ref == NULL) { \
		THROW("java/lang/NullPointerException", NULL); \
	} \
	if (index < 0 || index >= get_array_length((jarray) ref)) { \
	    STORE_CONTEXT(); \
		throw_exception_int(current_frame, "java/lang/ArrayIndexOutOfBoundsException", index); \
		CHECK_EXCEPTION;	\
	} \
	type * aptr = (type *) get_object_body(ref); \
	aptr[index] = value; \
	POP_DISCARD_N(current_frame, 2); \
}

/**
 * }Ngp
EXECUTE_PRIMITIVE_ASTORE_BODY(iastore, jint, INT);
EXECUTE_PRIMITIVE_ASTORE_BODY(bastore, jbyte, INT);
EXECUTE_PRIMITIVE_ASTORE_BODY(castore, jchar, INT);
EXECUTE_PRIMITIVE_ASTORE_BODY(sastore, jshort, INT);
EXECUTE_PRIMITIVE_ASTORE_BODY(fastore, jfloat, FLOAT);
EXECUTE_PRIMITIVE_ASTORE_BODY(lastore, jlong, LONG);
*/

/**
 * oCgR[h}N
 */
#define REWRITE_BYTECODE(new_bytecode)	(*bytecode = new_bytecode)

#include "bytecode.h"

/**
 * run_code()switch̒ #include t@CB
 * ȉ̕ϐp\B
 *
 * current_frame - Jgt[(frame*)
 * bytecode      - ݂̃oCgR[hw|C^
 *
 */

/**
 * nops
 */
EXECUTOR ( NOP )
{
	// Ȃ
	bytecode++;
}

/**
 * aconst_nulls
 */
EXECUTOR ( ACONST_NULL )
{
	PUSH_OBJECT(current_frame, NULL);
	bytecode++;
}

/**
 * iconst_m1߂s
 */
EXECUTOR ( ICONST_M1 )
{
	FAST_PUSH_INT(stack_base, pposition, -1);
	bytecode++;
}

/**
 * iconst_0߂s
 */
EXECUTOR ( ICONST_0 )
{
	FAST_PUSH_INT(stack_base, pposition, 0);
	bytecode++;
}

/**
 * iconst_1߂s
 */
EXECUTOR ( ICONST_1 )
{
	FAST_PUSH_INT(stack_base, pposition, 1);
	bytecode++;
}

/**
 * iconst_2߂s
 */
EXECUTOR ( ICONST_2 )
{
	FAST_PUSH_INT(stack_base, pposition, 2);
	bytecode++;
}

/**
 * iconst_3߂s
 */
EXECUTOR ( ICONST_3 )
{
	FAST_PUSH_INT(stack_base, pposition, 3);
	bytecode++;
}

/**
 * iconst_4߂s
 */
EXECUTOR ( ICONST_4 )
{
	FAST_PUSH_INT(stack_base, pposition, 4);
	bytecode++;
}

/**
 * iconst_5߂s
 */
EXECUTOR ( ICONST_5 )
{
	FAST_PUSH_INT(stack_base, pposition, 5);
	bytecode++;
}

/**
 * lconst_0߂s
 */
EXECUTOR ( LCONST_0 )
{
	PUSH_LONG(current_frame, 0);
	bytecode++;
}

/**
 * lconst_1߂s
 */
EXECUTOR ( LCONST_1 )
{
	PUSH_LONG(current_frame, 1);
	bytecode++;
}

/**
 * fconst_0߂s
 */
EXECUTOR ( FCONST_0 )
{
	FAST_PUSH_FLOAT(stack_base, pposition, 0.0f);
	bytecode++;
}

/**
 * fconst_1߂s
 */
EXECUTOR ( FCONST_1 )
{
	FAST_PUSH_FLOAT(stack_base, pposition, 1.0f);
	bytecode++;
}

/**
 * fconst_2߂s
 */
EXECUTOR ( FCONST_2 )
{
	FAST_PUSH_FLOAT(stack_base, pposition, 2.0f);
	bytecode++;
}

/**
 * dconst_0߂s
 */
EXECUTOR ( DCONST_0 )
{
	PUSH_DOUBLE(current_frame, 0.0);
	bytecode++;
}

/**
 * dconst_1߂s
 */
EXECUTOR ( DCONST_1 )
{
	PUSH_DOUBLE(current_frame, 1.0);
	bytecode++;
}

/**
 * bipush߂s
 */
EXECUTOR ( BIPUSH )
{
	__int8 tmp = bytecode[1];
	__int32 v = tmp;	// g
	FAST_PUSH_INT(stack_base, pposition, v);
	bytecode += 2;
}

/**
 * sipush߂s
 */
EXECUTOR ( SIPUSH )
{
	__int16 s = MAKE_INT16(bytecode[1], bytecode[2]);
	FAST_PUSH_INT(stack_base, pposition, (__int32) s);
	bytecode += 3;
}

/**
 * ldc߂s
 */
EXECUTOR ( LDC )
{
	execute_ldc_w(current_frame, 0, bytecode[1]);
	CHECK_EXCEPTION;
	bytecode += 2;
}

/**
 * ldc_w߂s
 */
EXECUTOR ( LDC_W )
{
	execute_ldc_w(current_frame, bytecode[1], bytecode[2]);
	CHECK_EXCEPTION;
	bytecode += 3;
}

/**
 * ldc2_w߂s
 */
EXECUTOR ( LDC2_W )
{
	u2 index = MAKE_U2(GET_PARAMETER(bytecode, 1),
					   GET_PARAMETER(bytecode, 2));
	ClassFile* cfile = current_frame->current_class_file;
	__int64 value = *(__int64*) &cfile->constant_pool[index];
	PUSH_LONG(current_frame, value);
	bytecode += 3;
}

/**
 * iload߂s
 */
EXECUTOR       ( ILOAD )
EXECUTOR_ALIAS ( FLOAD )
{
	FAST_LOAD(stack_base, pposition, local_variables_base, bytecode[1]);
	bytecode += 2;
}

EXECUTOR       ( ALOAD )
{
	ALOAD_N(current_frame, bytecode[1]);
	bytecode += 2;
}

/**
 * lload߂s
 */
EXECUTOR       ( LLOAD )
EXECUTOR_ALIAS ( DLOAD )
{
	LOAD2(current_frame, bytecode[1]);
	bytecode += 2;
}

/**
 * iload_0߂s
 */
EXECUTOR       ( ILOAD_0 )
EXECUTOR_ALIAS ( FLOAD_0 )
{
	FAST_LOAD(stack_base, pposition, local_variables_base, 0);
	bytecode++;
}

EXECUTOR       ( ALOAD_0 )
{
	ALOAD_N(current_frame, 0);
	bytecode++;
}

/**
 * iload_1߂s
 */
EXECUTOR       ( ILOAD_1 )
EXECUTOR_ALIAS ( FLOAD_1 )
{
	FAST_LOAD(stack_base, pposition, local_variables_base, 1);
	bytecode++;
}

EXECUTOR       ( ALOAD_1 )
{
	ALOAD_N(current_frame, 1);
	bytecode++;
}

/**
 * iload_2߂s
 */
EXECUTOR       ( ILOAD_2 )
EXECUTOR_ALIAS ( FLOAD_2 )
{
	FAST_LOAD(stack_base, pposition, local_variables_base, 2);
	bytecode++;
}

EXECUTOR        ( ALOAD_2 )
{
	ALOAD_N(current_frame, 2);
	bytecode++;
}

/**
 * iload_3߂s
 */
EXECUTOR       ( ILOAD_3 )
EXECUTOR_ALIAS ( FLOAD_3 )
{
	FAST_LOAD(stack_base, pposition, local_variables_base, 3);
	bytecode++;
}

EXECUTOR       ( ALOAD_3 )
{
	ALOAD_N(current_frame, 3);
	bytecode++;
}

/**
 * lload_0߂s
 */
EXECUTOR       ( LLOAD_0 )
EXECUTOR_ALIAS ( DLOAD_0 )
{
	LOAD2(current_frame, 0);
	bytecode++;
}

/**
 * lload_1߂s
 */
EXECUTOR       ( LLOAD_1 )
EXECUTOR_ALIAS ( DLOAD_1 )
{
	LOAD2(current_frame, 1);
	bytecode++;
}

/**
 * lload_2߂s
 */
EXECUTOR       ( LLOAD_2 )
EXECUTOR_ALIAS ( DLOAD_2 )
{
	LOAD2(current_frame, 2);
	bytecode++;
}

/**
 * lload_3߂s
 */
EXECUTOR       ( LLOAD_3 )
EXECUTOR_ALIAS ( DLOAD_3 )
{
	LOAD2(current_frame, 3);
	bytecode++;
}

/**
 * iaload, faload, baload, saload߂s
 */
EXECUTOR       ( IALOAD )
EXECUTOR_ALIAS ( FALOAD )
{
	EXECUTE_PRIMITIVE_ALOAD_BODY(iaload, jint, INT);
	bytecode++;
}

EXECUTOR       ( BALOAD )
{
	EXECUTE_PRIMITIVE_ALOAD_BODY(baload, jbyte, INT);
	bytecode++;
}

EXECUTOR       ( SALOAD )
{
	EXECUTE_PRIMITIVE_ALOAD_BODY(saload, jshort, INT);
	bytecode++;
}

/**
 * laload߂s
 */
EXECUTOR       ( LALOAD )
EXECUTOR_ALIAS ( DALOAD )
{
	EXECUTE_PRIMITIVE_ALOAD_BODY(laload, jlong, LONG);
	bytecode++;
}

/**
 * aaload߂s
 */
EXECUTOR ( AALOAD )
{
	// p[^擾
	jint idx;
	PEEK_STACK_DATA(current_frame, 0, jint, idx);
	jobject aref;
	PEEK_STACK_DATA(current_frame, 1, jobject, aref);

	// null`FbN
	if (aref == NULL) {
		THROW("java/lang/NullPointerException", NULL);
	}

	// z񋫊E`FbN
	if (idx < 0 || idx >= get_array_length((jarray) aref)) {
	    STORE_CONTEXT();
		throw_exception_int(current_frame, "java/lang/ArrayIndexOutOfBoundsException", idx);
		CHECK_EXCEPTION;
	}

	// zvf擾
	jobject* parray = (jobject*) get_object_body(aref);
	jobject ref = parray[idx];

	// p[^܂Ƃ߂Ĕj
	POP_DISCARD_N(current_frame, 2);
	
	// ʂPUSH
	PUSH_OBJECT(current_frame, ref);

	CHECK_EXCEPTION;
	bytecode++;
}

/**
 * caload߂s
 */
EXECUTOR ( CALOAD )
{
	EXECUTE_PRIMITIVE_ALOAD_BODY(caload, jchar, INT);
	CHECK_EXCEPTION;
	bytecode++;
}


/**
 * istore߂s
 */
EXECUTOR       ( ISTORE )
EXECUTOR_ALIAS ( FSTORE )
{
	FAST_STORE(stack_base, pposition, local_variables_base, bytecode[1]);
	bytecode += 2;
}

EXECUTOR       ( ASTORE )
{
	ASTORE_N(current_frame, bytecode[1]);
	bytecode += 2;
}

/**
 * lstore߂s
 */
EXECUTOR       ( LSTORE )
EXECUTOR_ALIAS ( DSTORE )
{
	STORE2(current_frame, bytecode[1]);
	bytecode += 2;
}

/**
 * istore_0߂s
 */
EXECUTOR ( ISTORE_0 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 0);
	bytecode++;
}

/**
 * istore_1߂s
 */
EXECUTOR ( ISTORE_1 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 1);
	bytecode++;
}

/**
 * istore_2߂s
 */
EXECUTOR ( ISTORE_2 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 2);
	bytecode++;
}

/**
 * istore_3߂s
 */
EXECUTOR ( ISTORE_3 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 3);
	bytecode++;
}

/**
 * lstore_0߂s
 */
EXECUTOR ( LSTORE_0 )
{
	STORE2(current_frame, 0);
	bytecode++;
}

/**
 * lstore_1߂s
 */
EXECUTOR ( LSTORE_1 )
{
	STORE2(current_frame, 1);
	bytecode++;
}

/**
 * lstore_2߂s
 */
EXECUTOR ( LSTORE_2 )
{
	STORE2(current_frame, 2);
	bytecode++;
}

/**
 * lstore_3߂s
 */
EXECUTOR ( LSTORE_3 )
{
	STORE2(current_frame, 3);
	bytecode++;
}

/**
 * fstore_0߂s
 */
EXECUTOR ( FSTORE_0 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 0);
	bytecode++;
}

/**
 * fstore_1߂s
 */
EXECUTOR ( FSTORE_1 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 1);
	bytecode++;
}

/**
 * fstore_2߂s
 */
EXECUTOR ( FSTORE_2 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 2);
	bytecode++;
}

/**
 * fstore_3߂s
 */
EXECUTOR ( FSTORE_3 )
{
	FAST_STORE(stack_base, pposition, local_variables_base, 3);
	bytecode++;
}

/**
 * dstore_0߂s
 */
EXECUTOR ( DSTORE_0 )
{
	STORE2(current_frame, 0);
	bytecode++;
}

/**
 * dstore_1߂s
 */
EXECUTOR ( DSTORE_1 )
{
	STORE2(current_frame, 1);
	bytecode++;
}

/**
 * dstore_2߂s
 */
EXECUTOR ( DSTORE_2 )
{
	STORE2(current_frame, 2);
	bytecode++;
}

/**
 * dstore_3߂s
 */
EXECUTOR ( DSTORE_3 )
{
	STORE2(current_frame, 3);
	bytecode++;
}

/**
 * astore_0߂s
 */
EXECUTOR ( ASTORE_0 )
{
	ASTORE_N(current_frame, 0);
	bytecode++;
}

/**
 * astore_1߂s
 */
EXECUTOR ( ASTORE_1 )
{
	ASTORE_N(current_frame, 1);
	bytecode++;
}

/**
 * astore_2߂s
 */
EXECUTOR ( ASTORE_2 )
{
	ASTORE_N(current_frame, 2);
	bytecode++;
}

/**
 * astore_3߂s
 */
EXECUTOR ( ASTORE_3 )
{
	ASTORE_N(current_frame, 3);
	bytecode++;
}

/**
 * iastore, fastore, bastore, castore, sastore߂s
 */
EXECUTOR ( IASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(iastore, jint, INT);
	bytecode++;
}

EXECUTOR ( FASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(fastore, jfloat, FLOAT);
	bytecode++;
}

EXECUTOR ( BASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(bastore, jbyte, INT);
	bytecode++;
}

EXECUTOR ( CASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(castore, jchar, INT);
	bytecode++;
}

EXECUTOR ( SASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(sastore, jshort, INT);
	bytecode++;
}

/**
 * lastore, dastore߂s
 */
EXECUTOR       ( LASTORE )
EXECUTOR_ALIAS ( DASTORE )
{
	EXECUTE_PRIMITIVE_ASTORE_BODY(lastore, jlong, LONG);
	bytecode++;
}

/**
 * aastore߂s
 */
EXECUTOR ( AASTORE )
{
	// l
	jobject value;
	PEEK_STACK_DATA(current_frame, 0, jobject, value);

	// CfbNX
	jint index;
	PEEK_STACK_DATA(current_frame, 1, jint, index);
	
	// ̔z
	jobject ref;
	PEEK_STACK_DATA(current_frame, 2, jobject, ref);
	
	if (ref == NULL) {
		// z̎QƂnull̏ꍇANullPointerException𔭐
	    THROW("java/lang/NullPointerException", NULL);
	}
	
	// value  refɑ\𒲂ׂ
	ClassFile* array_class_file = get_ClassFile(ref);
	const java_utf8* component_name = get_array_component_name(array_class_file);
	ClassFile* component_cfile = find_ClassFile(current_frame,
												get_defining_loader(array_class_file),
												component_name);
	if (! component_cfile) {
		// Oݒ肳Ă͂
		CHECK_EXCEPTION;
	}
	ClassFile* value_cfile = value ? get_ClassFile(value) : NULL;
	if (value != NULL
			&& (value_cfile != component_cfile) 
			&& (! is_assignable_from(current_frame, value_cfile, component_cfile))) {
		// lnullȊOŁAzvf̑݊Ȃꍇ
		// ArrayStoreExceptionthrow
	    THROW("java/lang/ArrayStoreException", NULL);
	}

	// z񋫊E`FbN
	if (index < 0 || index >= get_array_length((jarray) ref)) {
	    STORE_CONTEXT(); \
		throw_exception_int(current_frame, "java/lang/ArrayIndexOutOfBoundsException", index);
		CHECK_EXCEPTION;
	}
	jobject* parray = (jobject*) get_object_body(ref);
	parray[index] = value;

	// p[^܂Ƃ߂Ĕj
	POP_DISCARD_N(current_frame, 3);

	bytecode++;
}

/**
 * pop߂s
 */
EXECUTOR ( POP )
{
	POP_DISCARD(current_frame);
	bytecode++;
}

/**
 * pop2߂s
 */
EXECUTOR ( POP2 )
{
	POP2_DISCARD(current_frame);
	bytecode++;
}

/**
 * dup߂s
 */
EXECUTOR ( DUP )
{
	DUP_STACK(current_frame);
	bytecode++;
}

/**
 * dup_x1߂s
 */
EXECUTOR ( DUP_X1 )
{
	dup_x1(current_frame);
	bytecode++;
}

/**
 * dup_x2߂s
 */
EXECUTOR ( DUP_X2 )
{
	dup_x2(current_frame);
	bytecode++;
}

/**
 * dup2߂s
 */
EXECUTOR ( DUP2 )
{
	dup2(current_frame);
	bytecode++;
}

/**
 * dup2_x1߂s
 */
EXECUTOR ( DUP2_X1 )
{
	dup2_x1(current_frame);
	bytecode++;
}

/**
 * dup2_x2߂s
 */
EXECUTOR ( DUP2_X2 )
{
	dup2_x2(current_frame);
	bytecode++;
}

/**
 * swap߂s
 */
EXECUTOR ( SWAP )
{
	swap(current_frame);
	bytecode++;
}


/**
 * iadd߂s
 */
EXECUTOR ( IADD )
{
	ADD_STACK(current_frame, jint);
	bytecode++;
}

/**
 * ladd߂s
 */
EXECUTOR ( LADD )
{
	ADD2_STACK(current_frame, jlong);
	bytecode++;
}

/**
 * fadd߂s
 */
EXECUTOR ( FADD )
{
	ADD_STACK(current_frame, jfloat);
	bytecode++;
}

/**
 * dadd߂s
 */
EXECUTOR ( DADD )
{
	ADD2_STACK(current_frame, jdouble);
	bytecode++;
}

/**
 * isub߂s
 */
EXECUTOR ( ISUB )
{
	SUB_STACK(current_frame, jint);
	bytecode++;
}

/**
 * lsub߂s
 */
EXECUTOR ( LSUB )
{
	SUB2_STACK(current_frame, jlong);
	bytecode++;
}

/**
 * fsub߂s
 */
EXECUTOR ( FSUB )
{
	SUB_STACK(current_frame, jfloat);
	bytecode++;
}

/**
 * dsub߂s
 */
EXECUTOR ( DSUB )
{
	SUB2_STACK(current_frame, jdouble);
	bytecode++;
}

/**
 * imul߂s
 */
EXECUTOR ( IMUL )
{
	MUL_STACK(current_frame, jint);
	bytecode++;
}

/**
 * lmul߂s
 */
EXECUTOR ( LMUL )
{
	MUL2_STACK(current_frame, jlong);
	bytecode++;
}

/**
 * fmul߂s
 */
EXECUTOR ( FMUL )
{
	MUL_STACK(current_frame, jfloat);
	bytecode++;
}

/**
 * dmul߂s
 */
EXECUTOR ( DMUL )
{
	MUL2_STACK(current_frame, jdouble);
	bytecode++;
}

/**
 * idiv߂s
 */
EXECUTOR ( IDIV )
{
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	if (value2 == 0) {
		THROW("java/lang/ArithmeticException", "/ by zero");
	}

	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^2܂Ƃ߂POPĔj
	FAST_POP_DISCARD_N(pposition, 2);
	
	// vZʂPUSH
	FAST_PUSH_INT(stack_base, pposition, value1 / value2);
	bytecode++;
}

/**
 * ldiv߂s
 */
EXECUTOR ( LDIV )
{
	__int64 value2;
	POP_LONG(current_frame, value2);
	if (value2 == 0) {
		THROW("java/lang/ArithmeticException", "/ by zero");
	}
	__int64 value1;
	POP_LONG(current_frame, value1);
	__int64 result = value1 / value2;
	PUSH_LONG(current_frame, value1 / value2);
	bytecode++;
}

/**
 * fdiv߂s
 */
EXECUTOR ( FDIV )
{
	jfloat value2;
	// FAST_POP_FLOAT(stack_base, pposition, value2);
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jfloat, value2);
	jfloat value1;
	// FAST_POP_FLOAT(stack_base, pposition, value1);
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jfloat, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	// ʂPUSH
	FAST_PUSH_FLOAT(stack_base, pposition, value1 / value2);
	bytecode++;
}

/**
 * ddiv߂s
 */
EXECUTOR ( DDIV )
{
	double value2;
	POP_DOUBLE(current_frame, value2);
	double value1;
	POP_DOUBLE(current_frame, value1);
	PUSH_DOUBLE(current_frame, value1 / value2);
	bytecode++;
}

/**
 * irem߂s
 */
EXECUTOR ( IREM )
{
	__int32 value2;
	FAST_POP_INT(stack_base, pposition, value2);
	if (value2 == 0) {
	    THROW("java/lang/ArithmeticException", "% by zero");
	}

	__int32 value1;
	FAST_POP_INT(stack_base, pposition, value1);
	FAST_PUSH_INT(stack_base, pposition, value1 % value2);
	bytecode++;
}

/**
 * lrem߂s
 */
EXECUTOR ( LREM )
{
	__int64 value2;
	POP_LONG(current_frame, value2);
	if (value2 == 0) {
	    THROW("java/lang/ArithmeticException", "% by zero");
	}

	__int64 value1;
	POP_LONG(current_frame, value1);
	PUSH_LONG(current_frame, value1 % value2);
	bytecode++;
}

/**
 * frem߂s
 */
EXECUTOR ( FREM )
{
	float value2;
	FAST_POP_FLOAT(stack_base, pposition, value2);
	float value1;
	FAST_POP_FLOAT(stack_base, pposition, value1);
	float result = (float) fmod(value1, value2);
	// PUSH_FLOAT(current_frame, result);
	FAST_PUSH_FLOAT(stack_base, pposition, result);
	bytecode++;
}

/**
 * drem߂s
 */
EXECUTOR ( DREM )
{
	double value2;
	POP_DOUBLE(current_frame, value2);
	double value1;
	POP_DOUBLE(current_frame, value1);
	double result = fmod(value1, value2);
	PUSH_DOUBLE(current_frame, result);
	bytecode++;
}

/**
 * ineg߂s
 */
EXECUTOR ( INEG )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	FAST_PUSH_INT(stack_base, pposition, -value);
	bytecode++;
}

/**
 * lneg߂s
 */
EXECUTOR ( LNEG )
{
	__int64 value;
	POP_LONG(current_frame, value);
	PUSH_LONG(current_frame, -value);
	bytecode++;
}

/**
 * fneg߂s
 */
EXECUTOR ( FNEG )
{
	float value;
	FAST_POP_FLOAT(stack_base, pposition, value);
	FAST_PUSH_FLOAT(stack_base, pposition, -value);
	bytecode++;
}

/**
 * dneg߂s
 */
EXECUTOR ( DNEG )
{
	double value;
	POP_DOUBLE(current_frame, value);
	PUSH_DOUBLE(current_frame, -value);
	bytecode++;
}


/**
 * ishl߂s
 */
EXECUTOR ( ISHL )
{
	ISHL_STACK(current_frame);
	bytecode++;
}

/**
 * lshl߂s
 */
EXECUTOR ( LSHL )
{
	__int32 value2;
	FAST_POP_INT(stack_base, pposition, value2);
	value2 &= 0x3f;	// Vtg񐔂}XN
	__int64 value1;
	POP_LONG(current_frame, value1);
	PUSH_LONG(current_frame, value1 <<= value2);
	bytecode++;
}

/**
 * ishr߂s
 */
EXECUTOR ( ISHR )
{
	ISHR_STACK(current_frame);
	bytecode++;
}

/**
 * lshr߂s
 */
EXECUTOR ( LSHR )
{
	__int32 value2;
	FAST_POP_INT(stack_base, pposition, value2);
	value2 &= 0x3f;	// Vtg񐔂}XN

	__int64 value1;
	POP_LONG(current_frame, value1);
	
	PUSH_LONG(current_frame, value1 >> value2);
	bytecode++;
}

/**
 * iushr߂s
 */
EXECUTOR ( IUSHR )
{
	IUSHR_STACK(current_frame);
	bytecode++;
}

/**
 * lushr߂s
 */
EXECUTOR ( LUSHR )
{
	__int32 value2;
	FAST_POP_INT(stack_base, pposition, value2);
	__int32 s = value2 & 0x3f;	// Vtg񐔂}XN

	__int64 value1;
	POP_LONG(current_frame, value1);
	
	unsigned __int64 result = value1;
	result >>= s;
	PUSH_LONG(current_frame, result);
	bytecode++;
}

/**
 * iand߂s
 */
EXECUTOR ( IAND )
{
	IAND_STACK(current_frame);
	bytecode++;
}

/**
 * land߂s
 */
EXECUTOR ( LAND )
{
	LAND_STACK(current_frame);
	bytecode++;
}

/**
 * ior߂s
 */
EXECUTOR ( IOR )
{
	IOR_STACK(current_frame);
	bytecode++;
}

/**
 * lor߂s
 */
EXECUTOR ( LOR )
{
	LOR_STACK(current_frame);
	bytecode++;
}


/**
 * ixor߂s
 */
EXECUTOR ( IXOR )
{
	IXOR_STACK(current_frame);
	bytecode++;
}

/**
 * lxor߂s
 */
EXECUTOR ( LXOR )
{
	LXOR_STACK(current_frame);
	bytecode++;
}

/**
 * iinc߂s
 */
EXECUTOR ( IINC )
{
	__int8 count = bytecode[2];
	// IINC_LOCAL(current_frame, bytecode[1], (__int16) count);	// g	
	FAST_IINC_LOCAL(local_variables_base, bytecode[1], (__int16) count);
	bytecode += 3;
}

/**
 * i2l߂s
 */
EXECUTOR ( I2L )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	__int64 result = value;
	PUSH_LONG(current_frame, result);
	bytecode++;
}

/**
 * i2f߂s
 */
EXECUTOR ( I2F )
{
	I2F_STACK(current_frame);
	bytecode++;
}

/**
 * i2d߂s
 */
EXECUTOR ( I2D )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	double result = value;
	PUSH_DOUBLE(current_frame, result);
	bytecode++;
}

/**
 * l2i߂s
 */
EXECUTOR ( L2I )
{
	L2I_STACK(current_frame);
	bytecode++;
}

/**
 * l2f߂s
 */
EXECUTOR ( L2F )
{
	L2F_STACK(current_frame);
	bytecode++;
}

/**
 * l2d߂s
 */
EXECUTOR ( L2D )
{
	L2D_STACK(current_frame);
	bytecode++;
}

/**
 * f2i߂s
 */
EXECUTOR ( F2I )
{
	F2I_STACK(current_frame);
	bytecode++;
}

/**
 * f2l߂s
 */
EXECUTOR ( F2L )
{
	float value;
	FAST_POP_FLOAT(stack_base, pposition, value);
	__int64 result = (__int64) value;
	PUSH_LONG(current_frame, result);
	bytecode++;
}

/**
 * f2d߂s
 */
EXECUTOR ( F2D )
{
	float f;
	FAST_POP_FLOAT(stack_base, pposition, f);
	double d = f;
	PUSH_DOUBLE(current_frame, d);
	bytecode++;
}

/**
 * d2i߂s
 */
EXECUTOR ( D2I )
{
	double value;
	POP_DOUBLE(current_frame, value);
	__int32 result = (__int32) value;
	FAST_PUSH_INT(stack_base, pposition, result);
	bytecode++;
}

/**
 * d2l߂s
 */
EXECUTOR ( D2L )
{
	double value;
	POP_DOUBLE(current_frame, value);
	__int64 result = (__int64) value;
	PUSH_LONG(current_frame, result);
	bytecode++;
}

/**
 * d2f߂s
 */
EXECUTOR ( D2F )
{
	D2F_STACK(current_frame);
	bytecode++;
}

/**
 * i2b߂s
 */
EXECUTOR ( I2B )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	__int8 result = (__int8) value;
	FAST_PUSH_INT(stack_base, pposition, result);
	bytecode++;
}

/**
 * i2c߂s
 */
EXECUTOR ( I2C )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	unsigned __int16 result = (unsigned __int16) value;
	FAST_PUSH_INT(stack_base, pposition, result);
	bytecode++;
}

/**
 * i2s߂s
 */
EXECUTOR ( I2S )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	__int16 result = (__int16) value;
	FAST_PUSH_INT(stack_base, pposition, result);
	bytecode++;
}

/**
 * lcmp߂s
 */
EXECUTOR ( LCMP )
{
	__int64 value2;
	POP_LONG(current_frame, value2);
	
	__int64	value1;
	POP_LONG(current_frame, value1);

	if (value1 > value2) {
		FAST_PUSH_INT(stack_base, pposition, 1);
	} else if (value1 == value2) {
		FAST_PUSH_INT(stack_base, pposition, 0);
	} else {	// value1 > value2
		FAST_PUSH_INT(stack_base, pposition, -1);
	}
	bytecode++;
}

/**
 * fcmpl߂s
 */
EXECUTOR ( FCMPL )
{
	jfloat value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jfloat, value2);
	jfloat value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jfloat, value1);

	// p[^܂Ƃ߂POPAj
	FAST_POP_DISCARD_N(pposition, 2);

	if (_isnan(value1) || _isnan(value2)) {
		// NaN
		FAST_PUSH_INT(stack_base, pposition, -1);
	} else {
		if (value1 > value2) {
			FAST_PUSH_INT(stack_base, pposition, 1);
		} else if (value1 == value2) {
			FAST_PUSH_INT(stack_base, pposition, 0);
		} else {
			FAST_PUSH_INT(stack_base, pposition, -1);
		}
	}
	bytecode++;
}

/**
 * fcmpg߂s
 */
EXECUTOR ( FCMPG )
{
	jfloat value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jfloat, value2);
	jfloat value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jfloat, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	if (_isnan(value1) || _isnan(value2)) {
		// NaN
		FAST_PUSH_INT(stack_base, pposition, 1);
	} else {
		if (value1 > value2) {
			FAST_PUSH_INT(stack_base, pposition, 1);
		} else if (value1 == value2) {
			FAST_PUSH_INT(stack_base, pposition, 0);
		} else {
			FAST_PUSH_INT(stack_base, pposition, -1);
		}
	}
	bytecode++;
}

/**
 * dcmpl߂s
 */
EXECUTOR ( DCMPL )
{
	double value2;
	POP_DOUBLE(current_frame, value2);
	double value1;
	POP_DOUBLE(current_frame, value1);

	if (_isnan(value1) || _isnan(value2)) {
		// NaN
		FAST_PUSH_INT(stack_base, pposition, -1);
	} else {
		if (value1 > value2) {
			FAST_PUSH_INT(stack_base, pposition, 1);
		} else if (value1 == value2) {
			FAST_PUSH_INT(stack_base, pposition, 0);
		} else {
			FAST_PUSH_INT(stack_base, pposition, -1);
		}
	}
	bytecode++;
}

/**
 * dcmpg߂s
 */
EXECUTOR ( DCMPG )
{
	double value2;
	POP_DOUBLE(current_frame, value2);
	double value1;
	POP_DOUBLE(current_frame, value1);

	if (_isnan(value1) || _isnan(value2)) {
		// NaN
		FAST_PUSH_INT(stack_base, pposition, 1);
	} else {
		if (value1 > value2) {
			FAST_PUSH_INT(stack_base, pposition, 1);
		} else if (value1 == value2) {
			FAST_PUSH_INT(stack_base, pposition, 0);
		} else {
			FAST_PUSH_INT(stack_base, pposition, -1);
		}
	}
	bytecode++;
}

/**
 * ifeq߂s
 */
EXECUTOR ( IFEQ )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value == 0), bytecode[1], bytecode[2], 3);
}

/**
 * ifne߂s
 */
EXECUTOR ( IFNE )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value != 0), bytecode[1], bytecode[2], 3);
}

/**
 * iflt߂s
 */
EXECUTOR ( IFLT )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value < 0), bytecode[1], bytecode[2], 3);
}

/**
 * ifle߂s
 */
EXECUTOR ( IFLE )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value <= 0), bytecode[1], bytecode[2], 3);
}

/**
 * ifgt߂s
 */
EXECUTOR ( IFGT )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value > 0), bytecode[1], bytecode[2], 3);
}

/**
 * ifge߂s
 */
EXECUTOR ( IFGE )
{
	__int32 value;
	FAST_POP_INT(stack_base, pposition, value);
	SET_JUMP_ADDRESS(current_frame, (value >= 0), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmpeq߂s
 */
EXECUTOR ( IF_ICMPEQ )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 == value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmpne߂s
 */
EXECUTOR ( IF_ICMPNE )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 != value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmplt߂s
 */
EXECUTOR ( IF_ICMPLT )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 < value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmpge߂s
 */
EXECUTOR ( IF_ICMPGE )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 >= value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmpgt߂s
 */
EXECUTOR ( IF_ICMPGT )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 > value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_icmple߂s
 */
EXECUTOR ( IF_ICMPLE )
{
	// X^bNp[^o
	jint value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jint, value2);
	jint value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jint, value1);

	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 <= value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_acmpeq߂s
 */
EXECUTOR ( IF_ACMPEQ )
{
	jobject value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jobject, value2);
	jobject value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jobject, value1);
	
	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);
	
	SET_JUMP_ADDRESS(current_frame, (value1 == value2), bytecode[1], bytecode[2], 3);
}

/**
 * if_acmpne߂s
 */
EXECUTOR ( IF_ACMPNE )
{
	jobject value2;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jobject, value2);
	jobject value1;
	FAST_PEEK_STACK_DATA(stack_base, pposition, 1, jobject, value1);
	
	// p[^܂Ƃ߂Ĕj
	FAST_POP_DISCARD_N(pposition, 2);

	SET_JUMP_ADDRESS(current_frame, (value1 != value2), bytecode[1], bytecode[2], 3);
}

/**
 * goto߂s
 */
EXECUTOR ( GOTO )
{
	// Thread.interrupt()ꂽꍇɑΉ邽߂ɁAO`FbN
	CHECK_EXCEPTION;
	short branchoffset = (bytecode[1] << 8) | (bytecode[2] & 0xff);
	bytecode += branchoffset;
}

/**
 * jsr߂s
 */
EXECUTOR ( JSR )
{
	STORE_CONTEXT();

	__int16 offset = MAKE_INT16(bytecode[1], bytecode[2]);
	execute_jsr(current_frame, (__int32) offset);
	
	CHECK_EXCEPTION;
	bytecode = code + current_frame->current_pc;
}

/**
 * ret߂s
 */
EXECUTOR ( RET )
{
	__int32 address = get_int(current_frame, bytecode[1]);
	// jsr߂ōŏʃrbgĂĂ邽߁AŏʃrbgNA
	bytecode = (code + (address & ~0x80000000));
}

/**
 * tableswitch߂s
 */
EXECUTOR ( TABLESWITCH )
{
	// v[h
	// _PreLoad((unsigned long*) bytecode);

	// SoCgEf[^ǂݍ
	unsigned int padding = (unsigned int) (bytecode + 1) % 4;
	if (padding != 0) {
		padding = 4 - padding;
	}
	const unsigned int startpos = padding + 1;
	const __int32* data = (__int32*) &bytecode[startpos];

	const __int32 defaultoffset = READ_BIG_ENDIAN(data[0]);
	const __int32 lowvalue      = READ_BIG_ENDIAN(data[1]);
	const __int32 highvalue     = READ_BIG_ENDIAN(data[2]);
	const __int32* jump_table   = &data[3];

	__int32 index;
	POP_INT(current_frame, index);
	if (index < lowvalue || index > highvalue) {
		bytecode += defaultoffset;
	} else {
		__int32 offset = jump_table[index - lowvalue];
		offset = READ_BIG_ENDIAN(offset);
		bytecode += offset;
	}
}

/**
 * lookupswitch߂s
 */
EXECUTOR ( LOOKUPSWITCH )
{
	// SoCgEf[^ǂݍ
	unsigned int padding = (unsigned int) (bytecode + 1) % 4;
	if (padding != 0) {
		padding = 4 - padding;
	}
	const unsigned int startpos = padding + 1;
	const __int32* data = (__int32*) &bytecode[startpos];
	
	const __int32 defaultoffset = READ_BIG_ENDIAN(data[0]);
	const __int32 npairs = READ_BIG_ENDIAN(data[1]);
	const __int32* match_offset = (__int32*) &data[2];
	
	__int32 key;
	POP_INT(current_frame, key);

	// L[Ɉvl
	// ToDo:npairs傫ȏꍇ͓񕪒Ts
	bool found = false;
	for (int i = 0; i < npairs; ++i) {
		__int32 match = READ_BIG_ENDIAN(match_offset[i * 2]);
		if (key == match) {
			__int32 offset = READ_BIG_ENDIAN(match_offset[i * 2 + 1]);
			bytecode += offset;
			found = true;
			break;
		}
	}
	// match-offsetɈvȂꍇ
	if (! found) {
		bytecode += defaultoffset;
	}
}

/**
 * ireturn߂s
 */
EXECUTOR       ( IRETURN )
EXECUTOR_ALIAS ( LRETURN )
EXECUTOR_ALIAS ( FRETURN )
EXECUTOR_ALIAS ( DRETURN )
EXECUTOR_ALIAS ( ARETURN )
EXECUTOR_ALIAS (  RETURN )
{
#if 0
#ifdef DEBUG
	// RETURN߂Java\bhĂяoꍇÂƂfobOo͂
	if (bytecode == code && *bytecode == RETURN) {
		DBG(_T("Empty Java method called."));
		DBG_UTF8(current_frame->current_class_file->this_class_name);
		DBG(_T("."));
		DBG_UTF8(current_frame->current_method_info->name);
		DBG_UTF8(current_frame->current_method_info->descriptor);
		DBG(_T("\n"));
	}
#endif
#endif

	if (current_frame == start_frame) {
		goto END;	// ^[
	} else {
		frame* prev = leave_method(current_frame);
		current_frame = prev;
		LOAD_CONTEXT();
		if (*bytecode == INVOKEINTERFACE) {
			// invokeinterface߂5oCg
			bytecode += 5;
		} else {
			bytecode += 3;
		}
		continue;
	}
}

/**
 * getstatic߂s
 */
EXECUTOR ( GETSTATIC )
{
	execute_getstatic(current_frame, bytecode);
	CHECK_EXCEPTION;
	bytecode += 3;
}

/**
 * putstatic߂s
 */
EXECUTOR ( PUTSTATIC )
{ 
	execute_putstatic(current_frame, bytecode);
	CHECK_EXCEPTION;
	bytecode += 3;
}

/**
 * getfield߂s
 */
EXECUTOR ( GETFIELD )
{
	u1 index1 = GET_PARAMETER(bytecode, 1);
	u1 index2 = GET_PARAMETER(bytecode, 2);
	u2 index = MAKE_U2(index1, index2);

	// CfbNXŎw肳ꂽ CONSTANT_Fieldref_info \̂ւ̃|C^擾
	CONSTANT_Fieldref_info* fieldref = get_CONSTANT_Fieldref_info(current_frame->current_class_file, index);
	
	// FieldrefŎw肳ꂽNX擾
	ClassFile* target_class_file = fieldref->class_file;
	if (target_class_file == NULL) {
		class_loader* loader = get_defining_loader(current_frame->current_class_file);
		target_class_file = find_ClassFile(current_frame, loader, fieldref->class_name);
		if (! target_class_file) {
			// Ɏs
			// Oݒ肳Ă͂
			CHECK_EXCEPTION;
		}
		fieldref->class_file = target_class_file;

	}
	
	// tB[hID擾
	jfieldID fid = fieldref->field_id;
	if (fid == NULL) {
		fid = get_field_id(target_class_file,
						   fieldref->field_name,
						   fieldref->field_descriptor);
		if (fid == NULL) {
			// Oݒ肷
		    THROW("java/lang/NoSuchFieldError", fieldref->field_name);
		}
		fieldref->field_id = fid;
	}

	// ݒΏۂƂȂNXClassFile\̂擾
	field_info* finfo = get_field_info(target_class_file, fid);
	ClassFile* declaring_class_file = finfo->declaring_ClassFile;
	assert(declaring_class_file);

	// [hǉ
	if (! add_loading_constraints_of_method(current_frame,
											declaring_class_file,
											finfo->descriptor)) {
		// [hᔽ
		CHECK_EXCEPTION;
	}
	// ANZX`FbN
	if (! is_accessible(current_frame, current_frame->current_class_file, declaring_class_file, finfo->access_flags)) {
		THROW("java/lang/IllegalAccessError", finfo->name);
	}

	// tB[h̃ItZbgLbVĂ
	// ȒlƋʂ邽߂ɁAŏʃrbg𗧂ĂĂ
	fieldref->field_position = finfo->position | 0x80000000;

	// quick߂ɏ
	REWRITE_BYTECODE(GETFIELD_QUICK);
	continue;
}

/**
 * getfield_quick߂si߁j
 */
EXECUTOR ( GETFIELD_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// CfbNXŎw肳ꂽ CONSTANT_Fieldref_info \̂ւ̃|C^擾
	CONSTANT_Fieldref_info* fieldref = get_CONSTANT_Fieldref_info(current_frame->current_class_file, index);

	// tB[h̍ŏʃrbgNAl
	// ۂ̃|WV
	get_field_by_position(current_frame,
						  fieldref->field_descriptor,
						  (fieldref->field_position & ~0x80000000));
	CHECK_EXCEPTION;
	bytecode += 3;
}


/**
 * putfield߂s
 */
EXECUTOR ( PUTFIELD )
{
//	execute_putfield(current_frame, bytecode);
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// CfbNXŎw肳ꂽ CONSTANT_Fieldref_info \̂ւ̃|C^擾
	CONSTANT_Fieldref_info* fieldref = get_CONSTANT_Fieldref_info(current_frame->current_class_file, index);
	
	// FieldrefŎw肳ꂽNX擾
	ClassFile* target_class_file = fieldref->class_file;
	if (target_class_file == NULL) {
		class_loader* loader = get_defining_loader(current_frame->current_class_file);
		target_class_file = find_ClassFile(current_frame, loader, fieldref->class_name);
		if (! target_class_file) {
			// Ɏs
			CHECK_EXCEPTION;
		}
		fieldref->class_file = target_class_file;
	}

	// tB[hID擾
	jfieldID fid = fieldref->field_id;
	if (fid == NULL) {
		fid = get_field_id(target_class_file,
						   fieldref->field_name,
						   fieldref->field_descriptor);
		if (fid == NULL) {
			// Oݒ肷
			THROW("java/lang/NoSuchFieldError", fieldref->field_name);
		}
		fieldref->field_id = fid;
	}

	// ݒΏۂƂȂNXClassFile\̂擾
	field_info* finfo = get_field_info(target_class_file, fid);
	ClassFile* declaring_class_file = finfo->declaring_ClassFile;
	assert(declaring_class_file);

	// [hǉ
	if (! add_loading_constraints_of_method(current_frame,
											declaring_class_file,
											finfo->descriptor)) {
		CHECK_EXCEPTION;
	}

	// ANZX`FbN
	if (! is_accessible(current_frame, current_frame->current_class_file, declaring_class_file, finfo->access_flags)) {
		THROW("java/lang/IllegalAccessError", finfo->name);
	}
	// tB[h̃|WVLbVĂ
	// NULLƗLȒl(=ItZbg0jƂʂ邽߁Aŏʃrbg𗧂ĂĂ
	fieldref->field_position = finfo->position | 0x80000000;

	// ߂
	REWRITE_BYTECODE(PUTFIELD_QUICK);
	continue;
}

/**
 * putfield_quick߂si߁j
 */
EXECUTOR ( PUTFIELD_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// CfbNXŎw肳ꂽ CONSTANT_Fieldref_info \̂ւ̃|C^擾
	CONSTANT_Fieldref_info* fieldref = get_CONSTANT_Fieldref_info(current_frame->current_class_file, index);
	
	// tB[ḧʒuĂꍇ́A𗘗p
	// AhXɖ߂߂ɁAŏʃrbgNA
	put_field_by_position(current_frame,
						  fieldref->field_descriptor,
						  fieldref->field_position & ~0x80000000);
	CHECK_EXCEPTION;
	bytecode += 3;
}

/**
 * invokevirtual߂s
 */
EXECUTOR ( INVOKEVIRTUAL )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	
	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref
		= get_CONSTANT_Methodref_info(current_frame->current_class_file, index);

	// ΏۃNX
	class_loader* loader = get_defining_loader(current_frame->current_class_file);
	ClassFile* target_class_file = find_ClassFile(current_frame, loader, methodref->class_name);
	if (! target_class_file) {
		// NX̃[hs
		CHECK_EXCEPTION;
	}

	// ΏۃNXɃANZX\H
	if (! is_accessible(current_frame,
						current_frame->current_class_file,
						target_class_file,
						target_class_file->access_flags)) {
		// ΏۃNXɃANZXs\ȏꍇ
		THROW("java/lang/IllegalAccessError", target_class_file->this_class_name);
	}

	// ĂяoΏۂƂȂ郁\bh
	// ́A\bhe[uɑ΂Ă̂ݍs
	int method_table_index = methodref->method_table_index;
	if (method_table_index == -1) {
		method_table_index = get_method_table_index(target_class_file,
													methodref->method_name,
													methodref->method_descriptor);
		if (method_table_index == -1) {
		    STORE_CONTEXT(); \
			throw_exception(current_frame,
							"java/lang/NoSuchMethodError",
							methodref->method_name);
			CHECK_EXCEPTION;
		}
	}
	method_info* target_method_info = get_method_info_by_table_index(target_class_file, method_table_index);
	assert(target_method_info->name == methodref->method_name && target_method_info->descriptor == methodref->method_descriptor);

	// \bhɃANZXł邩𒲂ׂ
	if (! is_accessible(current_frame,
						current_frame->current_class_file,
						target_class_file,
						target_method_info->access_flags)) {
		if (! (target_class_file->this_class_name[0] == '['
				&& target_method_info->name == CLONE_METHOD_NAME)) {
			// zNX clone() \bĥݓʈB(protectedɃANZX\Ƃj
			// ToDo: {ɂ̕@ł悢H
			THROW("java/lang/IllegalAccessError", target_method_info->name);
		}
	}

	// static\bh̏ꍇ̓G[
	if (is_static(target_method_info->access_flags)) {
		THROW("java/lang/IncompatibleClassChangeError", target_method_info->name);
	}

	// [hǉ
	if (! add_loading_constraints_of_method(current_frame,
											target_method_info->declaring_ClassFile,
											target_method_info->descriptor)) {
		CHECK_EXCEPTION;
	}

	if (is_final(target_class_file->access_flags) || is_final(target_method_info->access_flags)) {
		// I[o[Ch邱Ƃ͂Ȃ̂ŁAINVOKENONVIRTUAL_QUICK߂ɏ
		methodref->target_method_info_cache = target_method_info;
		REWRITE_BYTECODE( INVOKENONVIRTUAL_QUICK );
	} else {
		// CfbNXlLbVAINVOKEVIRTUAL_QUICK߂ɏ
		methodref->method_table_index = method_table_index;
		REWRITE_BYTECODE( INVOKEVIRTUAL_QUICK );
	}

	// ߍĕ]
	continue;
}

/**
 * invokevirtual_quick߂si߁j
 */
EXECUTOR ( INVOKEVIRTUAL_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	
	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref
		= get_CONSTANT_Methodref_info(current_frame->current_class_file, index);

	// IyhX^bN objectref (this) 擾
	u2 param_count = get_parameters_count(methodref);
	jobject objectref;
	get_stack_data(current_frame, param_count, (__int32*) &objectref);

	if (! objectref) {
	    THROW("java/lang/NullPointerException", NULL);
	}
	ClassFile* object_class_file = get_ClassFile(objectref);

	// ĂяoΏۂƂȂClassFilemethod_info擾
	// (X^bÑIuWFNg擾Kvj
	method_info* target_method_info = get_method_info_by_table_index(object_class_file,
																	 methodref->method_table_index);

	assert(methodref->method_table_index != -1 && ! is_interface(object_class_file->access_flags));
	assert(target_method_info->name == methodref->method_name && target_method_info->descriptor == methodref->method_descriptor);
	ClassFile* declaring_class_file = target_method_info->declaring_ClassFile;

	// abstract\bh̏ꍇ͗Othrow
	if (is_abstract(target_method_info->access_flags)) {
		THROW("java/lang/AbstractMethodError", target_method_info->name);
	}

	// \bh{̂s
	INVOKE_METHOD(objectref, declaring_class_file, target_method_info);
	bytecode += 3;
}

/**
 * invokespecial߂s
 */
EXECUTOR ( INVOKESPECIAL )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref = get_CONSTANT_Methodref_info(current_frame->current_class_file, index);

	// ĂяoΏۂƂȂNX
	class_loader* loader = get_defining_loader(current_frame->current_class_file);
	ClassFile* target_class_file = find_ClassFile(current_frame, loader, methodref->class_name);
	if (! target_class_file) {
		// [hs
		CHECK_EXCEPTION;
	}
	const java_utf8* target_method_name = methodref->method_name;
	const java_utf8* target_method_desc = methodref->method_descriptor;

	// "super.method()" "non-virtualĂяo" ̂ǂł邩𒲂ׂ
	bool super_method;

	// ȉ̓𖞂Ă邩𒲂ׂ
	//		EJgNXACC_SUPERtOĂ
	//		E^[QbgNX̓JgNX̃X[p[NXł
	//		E"<init>"\bhł͂Ȃ
	// L𖞂Ăꍇ super.\bh() ̏s
	if (INIT_METHOD_NAME != target_method_name) {
		if ((current_frame->current_class_file->access_flags & ACC_SUPER) != 0
				&& ((current_frame->current_class_file != target_class_file)
						&& is_assignable_from(current_frame, current_frame->current_class_file, target_class_file))) {
			// "super.method()"Ăяo
			super_method = true;
			target_class_file = get_superclass_ClassFile(current_frame->current_class_file);

		} else {
			// non-virtualĂяo(private\bh)
			super_method = false;
		}
	} else {
		// <init>\bȟĂяo
		super_method = false;
	}

	// ĂяoΏۃ\bh method_info 𓾂
	// ̊ƂȂNX̓IyhX^bÑIuWFNgł͂ȂA
	// CONSTANT_Methodref_infoŎw肳ꂽNXi܂͂̃X[p[NXjgp_ɒ
	method_info* target_method_info;
	int method_table_index = get_method_table_index(target_class_file,
													target_method_name,
													target_method_desc);
	if (method_table_index != -1) {
		target_method_info = get_method_info_by_table_index(target_class_file, method_table_index);
	} else {
		// \bhe[uɂȂꍇ́Aڐ錾Ă郁\bh猟
		target_method_info = get_declared_method_info(target_class_file, target_method_name, target_method_desc);
	}
	if (! target_method_info) {
		// ȂꍇAAbstractMethodErrorݒ肵A^[
		THROW("java/lang/AbstractMethodError", target_method_name);
	}
	assert((target_method_info->name == target_method_name) && (target_method_info->descriptor == target_method_desc));
	
	// abstract\bhꍇAOthrow
	if (is_abstract(target_method_info->access_flags)) {
		THROW("java/lang/AbstractMethodError", target_method_name);
	}
	// static\bhꍇAIncompatibleClassChangeError 𓊂
	if (is_static(target_method_info->access_flags)) {
		THROW("java/lang/IncompatibleClassChangeError", target_method_name);
	}

	// [hǉ
	ClassFile* declaring_class_file = target_method_info->declaring_ClassFile;
	if (! add_loading_constraints_of_method(current_frame,
											declaring_class_file,
											target_method_info->descriptor)) {
		CHECK_EXCEPTION;
	}

	// ANZX𒲂ׂ
	if (! is_accessible(current_frame,
						current_frame->current_class_file,
						target_class_file,
						target_method_info->access_flags)) {
		THROW("java/lang/IllegalAccessError", target_method_info->name);
	}
	
	// LbV
	methodref->target_method_info_cache = target_method_info;


	// ߂
	if ((target_method_info->access_flags & ACC_EMPTY)) {
		// 󃁃\bh
		REWRITE_BYTECODE( INVOKEEMPTY_QUICK );
	} else if (super_method) {
		// super.method()
		REWRITE_BYTECODE( INVOKESUPER_QUICK );
	} else {
		// non-virtualĂяo
		REWRITE_BYTECODE( INVOKENONVIRTUAL_QUICK );
	}
	continue;
}

/**
 * 󃁃\bhĂяoi߁j
 */
EXECUTOR ( INVOKEEMPTY_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref = get_CONSTANT_Methodref_info(current_frame->current_class_file, index);

	method_info* target_method_info   = methodref->target_method_info_cache;

	// X^bNp[^+1POP
	// static\bhł͂Ȃ߁Athisς܂Ă͂
	POP_DISCARD_N(current_frame, get_parameters_count(target_method_info) + 1);
	bytecode += 3;
}

/**
 * invokesuper_quick߂si߁j
 */
EXECUTOR ( INVOKESUPER_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref = get_CONSTANT_Methodref_info(current_frame->current_class_file, index);

	method_info* target_method_info   = methodref->target_method_info_cache;
	assert(target_method_info);

	ClassFile*   declaring_class_file = target_method_info->declaring_ClassFile;

	// IyhX^bN objectref (this) 擾
	u2 param_count = get_parameters_count(methodref);
	jobject objectref = (jobject) current_frame->operand_stack[current_frame->operand_stack_position - param_count - 1];
	if (objectref  == NULL) {
	    THROW("java/lang/NullPointerException", NULL);
	}

	// \bhs
	INVOKE_METHOD(objectref, declaring_class_file, target_method_info);
	bytecode += 3;
}

/**
 * invokenonvirtual_quick߂si߁j
 */
EXECUTOR ( INVOKENONVIRTUAL_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	// ĂяoΏۂƂȂ郁\bh CONSTANT_Methodref_info 擾
	CONSTANT_Methodref_info* methodref = get_CONSTANT_Methodref_info(current_frame->current_class_file, index);
	method_info* target_method_info   = methodref->target_method_info_cache;
	assert(target_method_info);

	ClassFile*   declaring_class_file = target_method_info->declaring_ClassFile;

	// IyhX^bN objectref (this) 擾
	u2 param_count = get_parameters_count(methodref);
	jobject objectref = (jobject) current_frame->operand_stack[current_frame->operand_stack_position - param_count - 1];
	if (objectref == NULL) {
		THROW("java/lang/NullPointerException", NULL);
	}

	// \bhs
	INVOKE_METHOD(objectref, declaring_class_file, target_method_info);
	bytecode += 3;
}

/**
 * invokestatic߂s
 */
EXECUTOR ( INVOKESTATIC )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// ĂяoΏۂƂȂNX擾
	CONSTANT_Methodref_info* methodref = get_CONSTANT_Methodref_info(current_frame->current_class_file, index);
	
	class_loader* loader = get_defining_loader(current_frame->current_class_file);
	ClassFile* target_class_file = find_ClassFile(current_frame, loader, methodref->class_name);
	if (target_class_file == NULL) {
		if (! exception_occurred(current_frame)) {
			// OĂȂꍇ́ANoClassDefFoundErrorthrow
		    THROW("java/lang/NoClassDefFoundError", methodref->class_name);
		}
		CHECK_EXCEPTION;
	}

	// ĂяoΏۂƂȂ郁\bh擾
	method_info* target_method_info = methodref->target_method_info_cache;
	if (! target_method_info) {
		// ŏɁA\bhe[uT
		int table_index = get_method_table_index(target_class_file, methodref->method_name, methodref->method_descriptor);
		if (table_index != -1) {
			target_method_info = get_method_info_by_table_index(target_class_file, table_index);
		} else {
			// \bhe[uŌȂꍇ́A錾Ă郁\bhT
			// iprivate static \bh̏ꍇ́AŌj
			target_method_info = get_declared_method_info(target_class_file, methodref->method_name, methodref->method_descriptor);
		}
		if (! target_method_info) {
		    THROW("java/lang/NoSuchMethodError", methodref->method_name);
		} else if (! is_static(target_method_info->access_flags)) {
			// static\bhłȂꍇ
			THROW("java/lang/IncompatibleClassChangeError", methodref->method_name);
		}
		
		methodref->target_method_info_cache = target_method_info;
	}

	// \bh`ĂNXƁAmethod_info 擾
	ClassFile* declaring_class_file = target_method_info->declaring_ClassFile;

	// abstract\bhꍇAOthrow
	if (is_abstract(target_method_info->access_flags)) {
		THROW("java/lang/AbstractMethodError", target_method_info->name);
	}
	// static\bhłȂꍇAOthrow
	if (! is_static(target_method_info->access_flags)) {
		THROW("java/lang/IncompatibleClassChangeError", target_method_info->name);
	}
	// \bh`ĂNXC^tF[X̏ꍇAOthrow
	if (is_interface(declaring_class_file->access_flags)) {
		THROW("java/lang/IncompatibleClassChangeError", target_method_info->name);
	}
	
	// ANZX𒲂ׂ
	if (! is_accessible(current_frame,
						current_frame->current_class_file,
						target_class_file,
						target_method_info->access_flags)) {
		THROW("java/lang/IllegalAccessError", target_method_info->name);
	}

	// [hǉ
	if (! add_loading_constraints_of_method(current_frame,
											declaring_class_file,
											target_method_info->descriptor)) {
		CHECK_EXCEPTION;
	}


	REWRITE_BYTECODE(INVOKESTATIC_QUICK);
	continue;
}

/**
 * invokestatic_quick߂si߁j
 */
EXECUTOR ( INVOKESTATIC_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// ĂяoΏۂƂȂNXƃ\bh擾
	CONSTANT_Methodref_info* methodref
								= get_CONSTANT_Methodref_info(current_frame->current_class_file, index);
	
	// method_info 擾
	method_info* target_method_info = methodref->target_method_info_cache;
	assert(target_method_info);

	ClassFile* declaring_class_file = target_method_info->declaring_ClassFile;

	assert((target_method_info->name == methodref->method_name)
			&& (target_method_info->descriptor == methodref->method_descriptor));
	
	// \bhs
	jobject static_data = get_static_data(declaring_class_file);

	INVOKE_METHOD(static_data, declaring_class_file, target_method_info);

	bytecode += 3;
}


/**
 * invokeinterface߂s
 */
EXECUTOR ( INVOKEINTERFACE )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// InterfaceMethodref擾
	// constant_pool[index]̉16rbg class_index A16rbg name_and_type_indexi[Ă
	u4 interface_methodref = (u4) current_frame->current_class_file->constant_pool[index];
	
	// NameAndType擾
	// constant_pool[name_and_type_index] ̉ʃrbg name_index A
	// 16rbg type_index i[Ă
	u4 name_and_type = (u4) current_frame->current_class_file->constant_pool[(u2) (interface_methodref >> 16)];
	java_utf8* target_method_name = get_java_utf8(current_frame->current_class_file, (u2) name_and_type);
	java_utf8* target_method_desc = get_java_utf8(current_frame->current_class_file, (u2) (name_and_type >> 16));
	
	// IyhX^bNIuWFNgQƂ擾
	u1 count = GET_PARAMETER(bytecode, 3);
	jobject objectref = (jobject) current_frame->operand_stack[current_frame->operand_stack_position - (count & 0xff)];
	if (objectref == NULL) {
		THROW("java/lang/NullPointerException", NULL);
	}
	
	// ĂяoΏۂƂȂ郁\bh̏擾
	ClassFile* object_class_file = get_ClassFile(objectref);
	method_info* target_method_info;
	int method_table_index = get_method_table_index(object_class_file,
													target_method_name,
													target_method_desc);
	if (method_table_index != -1) {
		target_method_info = get_method_info_by_table_index(object_class_file, method_table_index);
	} else {
		// ڐ錾Ă郁\bh
		// iɗꍇprivate\bĥ͂Ȃ̂ŁAG[ɂĂ悢Hj
		target_method_info = get_declared_method_info(object_class_file,
													  target_method_name,
													  target_method_desc);
	}
	if (! target_method_info) {
		// \bhłȂ
	    THROW("java/lang/AbstractMethodError", target_method_name);
	}
	ClassFile* declaring_class_file = target_method_info->declaring_ClassFile;

	// abstract\bhꍇAOthrow
	if (is_abstract(target_method_info->access_flags)) {
		THROW("java/lang/AbstractMethodError", target_method_info->name);
	}
	// \bhpublicłȂ΃G[
	if (! is_public(target_method_info->access_flags)) {
		THROW("java/lang/IllegalAccessError", target_method_info->name);
	}

	// [hǉ
	if (! add_loading_constraints_of_method(current_frame,
											target_method_info->declaring_ClassFile,
											target_method_desc)) {
		// ̒ǉɎs
		CHECK_EXCEPTION;
	}

	// \bh{̂s
	INVOKE_METHOD(objectref, declaring_class_file, target_method_info);

	bytecode += 5;
}

/**
 * new߂
 */
EXECUTOR ( NEW )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	ClassFile* cfile = current_frame->current_class_file;
	
	// new̑ΏۂƂȂClassFile\̂ւ̃|C^𓾂
	ClassFile* target_class_file
			= resolve_ClassFile(current_frame,
							    cfile,
								index);
	CHECK_EXCEPTION;

	if (is_abstract(target_class_file->access_flags)) {
		// abstractNXnew悤ƂĂ
	    THROW("java/lang/InstantiationError", target_class_file->this_class_name);
	}

	// NEW_QUICKɏ
	REWRITE_BYTECODE(NEW_QUICK);
	continue;
}

/**
 * new_quick߂i߁j
 */
EXECUTOR ( NEW_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	ClassFile* target_class_file = get_resolved_ClassFile(current_frame->current_class_file,
														  index);

	// mۂAQƂIyhX^bNpush
	alloc_object(target_class_file, current_frame);
	CHECK_EXCEPTION;

	if (bytecode[3] == DUP) {
		// new ߂̒ɂdup߂邱Ƃ̂ŁA
		// ł܂Ƃ߂ďĂ܂
		DUP_STACK(current_frame);
		bytecode += 4;
	} else {
		bytecode += 3;
	}
}


/**
 * newarray߂
 */
EXECUTOR ( NEWARRAY )
{
//	execute_newarray(current_frame, bytecode);
	// z̃^Cv擾
	u1 atype = bytecode[1];
	
	// zTCYpop
	__int32 count;
	POP_INT(current_frame, count);
	if (count < 0) {
	    STORE_CONTEXT();
		throw_exception_int(current_frame,
						"java/lang/NegativeArraySizeException",
						count);
		CHECK_EXCEPTION;
	}

	const java_utf8* name = PRIMITIVE_ARRAY_CLASS_NAMES[atype];
	class_loader* loader = get_defining_loader(current_frame->current_class_file);
	ClassFile* cfile = find_ClassFile(current_frame, loader, name);
	if (! cfile) {
		// s
		CHECK_EXCEPTION;
	}
	if (alloc_array(cfile, count, current_frame) == NULL) {
		CHECK_EXCEPTION;
	}
	CHECK_EXCEPTION;
	bytecode += 2;
}

/**
 * anewarray߂
 */
EXECUTOR ( ANEWARRAY )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	// z̗vfX^bNpop
	__int32 count;
	POP_INT(current_frame, count);
	if (count < 0) {
		// vf̒l
	    STORE_CONTEXT();
		throw_exception_int(current_frame, "java/lang/NegativeArraySizeException", count);
		CHECK_EXCEPTION;
	}

	// zNX[h
	const java_utf8* name
			= get_CONSTANT_Class_info(current_frame->current_class_file, index);
	u4 name_len = strlen(name);
	char* array_name = (char*) malloc(name_len + 2 + 1 + 1);
	if (! array_name) {
		fatal_error(FATAL_ERROR_NO_MEMORY);
	}

	if (name_len >= 2 && name[0] == '[') {
		// vfzNX̏ꍇi [I [Ljava/lang/String; )
		sprintf(array_name, "[%s", name);
	} else {
		// vfNX̏ꍇ
		// "[L" + NX + ";"
		sprintf(array_name, "[L%s;", name);
	}

	class_loader* loader = get_defining_loader(current_frame->current_class_file);
	ClassFile* cfile = find_ClassFile(current_frame, loader, intern_utf8(array_name));
	free(array_name);
	if (! cfile) {
		// s
		CHECK_EXCEPTION;
	}
	
	alloc_array(cfile, count, current_frame);
	CHECK_EXCEPTION;
	bytecode += 3;
}

/**
 * arraylength߂s
 */
EXECUTOR ( ARRAYLENGTH )
{
	jobject arrayref;
	POP_OBJECT(current_frame, arrayref);
	if (arrayref == NULL) {
		// z̎QƂ null
		THROW("java/lang/NullPointerException", NULL);
	}
	__int32 length = get_array_length((jarray) arrayref);
	FAST_PUSH_INT(stack_base, pposition, length);
	bytecode++;
}

/**
 * athrow߂s
 */
EXECUTOR ( ATHROW )
{
	jobject ref;
	POP_OBJECT(current_frame, ref);
	if (ref == NULL) {
		THROW("java/lang/NullPointerException", NULL);
	}
	// ReLXgۑAw肳ꂽOݒ肵AO̔`FbN
	STORE_CONTEXT();
	current_frame->body->current_exception = (jthrowable) ref;
	CHECK_EXCEPTION;
}

/**
 * checkcast߂s
 */
EXECUTOR ( CHECKCAST )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);

	const java_utf8* class_name = get_CONSTANT_Class_info(current_frame->current_class_file, index);
	// X^bNgbṽIuWFNg擾ipop͂Ȃj
	jobject ref;
	get_stack_data(current_frame, 0, (__int32*)&ref);

	if (ref) {
		// LbV̓e𒲂ׂ
		int result = get_instanceof_cache(current_frame, get_ClassFile(ref), class_name);

#if CHECKCAST_STATISTICS
		// instanceof߃LbVɃqbg𒲂ׂ
		g_checkcast_count++;
		if (result != -1) {
			g_checkcast_hits++;
		}
#endif
		// LbVɃqbgȂꍇA`FbNs
		ClassFile* target_cfile
			= resolve_ClassFile(current_frame,
							    current_frame->current_class_file,
							    index);
		if (target_cfile) {
			if (! result || (result < 0) && (! is_assignable_from(current_frame, get_ClassFile(ref), target_cfile))) {
				// s\̏ꍇɂClassCastException𔭐
				THROW("java/lang/ClassCastException", get_ClassFile(ref)->this_class_name);
			}
		}
	}
	bytecode += 3;
}

/**
 * instanceof߂s
 */
EXECUTOR ( INSTANCEOF )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	
	// NX[h
	ClassFile* target_cfile = resolve_ClassFile(current_frame,
											    current_frame->current_class_file,
												index);
	CHECK_EXCEPTION;

	// ߂
	REWRITE_BYTECODE( INSTANCEOF_QUICK );
	continue;
}

/**
 * instanceof_quick߂si߁j
 */
EXECUTOR ( INSTANCEOF_QUICK )
{
	u2 index = MAKE_U2(bytecode[1], bytecode[2]);
	ClassFile* target_cfile = get_resolved_ClassFile(current_frame->current_class_file,
													 index);
	int result;

	// QƒloiɃKx[WRN^ɉĂ܂Ȃ悤Apop͂Ȃj
	jobject ref;
	get_stack_data(current_frame, 0, (__int32*)&ref);
	if (ref) {
		ClassFile* lvalue = get_ClassFile(ref);
		java_utf8* class_name = target_cfile->this_class_name;
		// LbV̓e𒲂ׂ
		result = get_instanceof_cache(current_frame,
									  lvalue,
									  class_name);
		if (result < 0) {
			if (is_assignable_from(current_frame, lvalue, target_cfile)) {
				result = 1;
			} else {
				result = 0;
			}
			// LbVɌʂ
			update_instanceof_cache(current_frame,
									lvalue,
									class_name,
									result);
		}
	} else {
		result = 0;
	}

	POP_DISCARD(current_frame);
	PUSH_INT(current_frame, result);

	bytecode += 3;
}

/**
 * monitorenter߂s
 */
EXECUTOR ( MONITORENTER )
{
	jobject ref;
	// get_stack_data(current_frame, 0, (__int32*) &ref);
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jobject, ref);
	if (ref == NULL) {
		POP_DISCARD(current_frame);
		THROW("java/lang/NullPointerException", NULL);
	}
	if (! monitor_enter(ref)) {
		POP_DISCARD(current_frame);
		// sŔ
		STORE_CONTEXT();
		throw_OutOfMemoryError(current_frame);
		CHECK_EXCEPTION;
	}

	POP_DISCARD(current_frame);
	bytecode++;
}

/**
 * monitorexit߂s
 */
EXECUTOR ( MONITOREXIT )
{
	jobject ref;
	// get_stack_data(current_frame, 0, (__int32*) &ref);
	FAST_PEEK_STACK_DATA(stack_base, pposition, 0, jobject, ref);
	if (ref == NULL) {
		POP_DISCARD(current_frame);
	    THROW("java/lang/NullPointerException", NULL);
	}
	if (! monitor_exit(ref)) {
		POP_DISCARD(current_frame);
	    THROW("java/lang/IllegalMonitorStateException", NULL);
	}
	POP_DISCARD(current_frame);
	bytecode++;
}


/**
 * wide߂s
 */
EXECUTOR ( WIDE )
{
	// ͂̕܂fobOłĂȂ̂assert()d|Ă
	// assert(false);

	u1 opcode = GET_PARAMETER(bytecode, 1);
	u1 indexbyte1 = GET_PARAMETER(bytecode, 2);
	u1 indexbyte2 = GET_PARAMETER(bytecode, 3);
	u2 index = MAKE_U2(indexbyte1, indexbyte2);

	switch (opcode) {
	case ILOAD:	// iload
		LOAD(current_frame, index);
		bytecode += 4;
		break;

	case LLOAD:	// lload
		LOAD2(current_frame, index);
		bytecode += 4;
		break;

	case FLOAD:	// fload
		LOAD(current_frame, index);
		bytecode += 4;
		break;

	case DLOAD:	// dload
		LOAD2(current_frame, index);
		bytecode += 4;
		break;

	case ALOAD:	// aload
		LOAD(current_frame, index);
		bytecode += 4;
		break;

	case ISTORE:	// istore
		STORE(current_frame, index);
		bytecode += 4;
		break;

	case LSTORE:	// lstore
		STORE2(current_frame, index);
		bytecode += 4;
		break;

	case FSTORE:	// fstore
		STORE(current_frame, index);
		bytecode += 4;
		break;

	case DSTORE:	// dstore
		STORE2(current_frame, index);
		bytecode += 4;
		break;

	case ASTORE:	// astore
		STORE(current_frame, index);
		bytecode += 4;
		break;

	case IINC:	// iinc
		{
			u1 constbyte1 = GET_PARAMETER(bytecode, 4);
			u1 constbyte2 = GET_PARAMETER(bytecode, 5);
			__int16 count = MAKE_INT16(constbyte1, constbyte2);
			IINC_LOCAL(current_frame, index, count);
			bytecode += 6;
		}
		break;
	
	case RET:	// ret
		{
			__int32 address = get_int(current_frame, index);
			// jsr߂ōŏʃrbgĂĂ邽߁AŏʃrbgNA
			bytecode = (code + (address & ~0x80000000));
		}
		break;

	default:
		THROW("java/lang/VirtualMachineError", "Unknown WIDE  opcode");
		break;

	}
}

/**
 * multianewarray߂
 */
EXECUTOR ( MULTIANEWARRAY )
{
	STORE_CONTEXT();
	execute_multianewarray(current_frame, bytecode);
	CHECK_EXCEPTION;
	bytecode += 4;
}

/**
 * ifnull߂s
 */
EXECUTOR( IFNULL )
{
	jobject value;
	POP_OBJECT(current_frame, value);
	SET_JUMP_ADDRESS(current_frame, (value == NULL), bytecode[1], bytecode[2], 3);
}

/**
 * ifnonnull߂s
 */
EXECUTOR( IFNONNULL )
{
	jobject value;
	POP_OBJECT(current_frame, value);
	SET_JUMP_ADDRESS(current_frame, (value != NULL), bytecode[1], bytecode[2], 3);
}

/**
 * goto_w߂s
 */
EXECUTOR( GOTO_W )
{
	// Thread.interrupt()ꂽꍇɑΉ邽߂ɁAO`FbN
	CHECK_EXCEPTION;
	bytecode += MAKE_INT32(GET_PARAMETER(bytecode, 1),
									GET_PARAMETER(bytecode, 2),
									GET_PARAMETER(bytecode, 3),
									GET_PARAMETER(bytecode, 4));
}

/**
 * jsr_w߂s
 */
EXECUTOR( JSR_W )
{
	__int32* pbranch = (__int32*) &bytecode[1];
	__int32 branch = READ_BIG_ENDIAN(*pbranch);

	// jsr߂s
	execute_jsr(current_frame, branch);
	CHECK_EXCEPTION;
}
