/* gnu_java_awt_peer_wce_WCEDesktopPeer.c
   Copyright (C) 2008 Free Software Foundation, Inc.

This file is part of Mysaifu JVM.

Mysaifu JVM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

Mysaifu JVM is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mysaifu JVM; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#include <jni.h>
#include <gnu_java_awt_peer_wce_WCEDesktopPeer.h>


/*
 * Class:     gnu_java_awt_peer_wce_WCEDesktopPeer
 * Method:    nativeShellExecuteEx
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_gnu_java_awt_peer_wce_WCEDesktopPeer_nativeShellExecuteEx
(JNIEnv *env, jclass unused, jstring verb, jstring dir, jstring file) {
	SHELLEXECUTEINFO execinfo = {0};
	int verblen, dirlen, filelen;
	_TCHAR* lpVerb, *lpDir, *lpFile;

	if (verb == NULL || file == NULL) {
		jclass clazz = (*env)->FindClass(env, "java/lang/NullPointerException");
		(*env)->ThrowNew(env, clazz, NULL);
	}		
	verblen = (*env)->GetStringLength(env, verb);
	dirlen = (dir != NULL) ? (*env)->GetStringLength(env, dir) : 0;
	filelen = (*env)->GetStringLength(env, file);

	lpVerb = (_TCHAR*) malloc(sizeof(_TCHAR) * (verblen + 1));
	lpDir = (_TCHAR*) malloc(sizeof(_TCHAR) * (dirlen + 1));
	lpFile = (_TCHAR*) malloc(sizeof(_TCHAR) * (filelen + 1));

	if (! lpVerb || ! lpDir || ! lpFile) {
		jclass clazz = (*env)->FindClass(env, "java/io/IOException");
		(*env)->ThrowNew(env, clazz, "No memory");
	} else {
		const _TCHAR* tmp = (*env)->GetStringChars(env, verb, NULL);
		_tcsncpy(lpVerb, tmp, verblen);
		lpVerb[verblen] = _T('\0');
		(*env)->ReleaseStringChars(env, verb, tmp);
		
		if (dir != NULL) {
			tmp = (*env)->GetStringChars(env, dir, NULL);
			_tcsncpy(lpDir, tmp, dirlen);
			lpDir[dirlen] = _T('\0');
			(*env)->ReleaseStringChars(env, dir, tmp);
		} else {
			lpDir[0] = _T('\0');
		}

		tmp = (*env)->GetStringChars(env, file, NULL);
		_tcsncpy(lpFile, tmp, filelen);
		lpFile[filelen] = _T('\0');
		(*env)->ReleaseStringChars(env, file, tmp);

		execinfo.cbSize = sizeof(execinfo);
		execinfo.fMask = SEE_MASK_NOCLOSEPROCESS;
		execinfo.lpVerb = lpVerb;
		execinfo.lpDirectory = lpDir;
		execinfo.lpFile = lpFile;
		if (! ShellExecuteEx(&execinfo)) {
			DWORD dwError = GetLastError();
			jclass clazz = (*env)->FindClass(env, "java/io/IOException");
			char msg[128];
			_snprintf(msg, 128, "GetLastError()=%d", dwError);
			(*env)->ThrowNew(env, clazz, msg);
		}
	}
	free(lpVerb);
	free(lpDir);
	free(lpFile);
}