/* WCEMemoryImage.java
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.java.awt.peer.wce;

import java.awt.AWTError;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;


/**
 * ImageProducer̓eɊÂImage
 */
public class WCEMemoryImage extends WCEImage implements ImageConsumer {
	private ColorModel colorModel;
	private int[] imageData;
	
	public WCEMemoryImage(ImageProducer producer) {
		this.source = producer;
		this.source.startProduction(this);
	}
	
	/**
	 * C[W̃TCYm肵_ŁAImageProducerĂяo
	 */
	public void setDimensions(int width, int height) {
		super.setDimension(width, height);
	}
	
	/**
	 * C[W̃vpeB񍐂
	 */
	public void setProperties(Hashtable props) {
		// ݂̎ł͖
	}
	
	/**
	 * J[fʒm
	 */
	public void setColorModel(ColorModel model) {
		this.colorModel = model;
	}
	
	/**
	 * qgʒm
	 */
	public void setHints(int hintflags) {
		// ݂̎ł͖
	}
	
	/**
	 * C[W̃sNZʒm
	 */
	public void setPixels(int x,
                      int y,
                      int w,
                      int h,
                      ColorModel model,
                      byte[] pixels,
                      int off,
                      int scansize) {
		throw new AWTError("byte[] pixels not supported.");
	}
	
	/**
	 * 
	 */
	public void setPixels(int x,
                      int y,
                      int w,
                      int h,
                      ColorModel model,
                      int[] pixels,
                      int off,
                      int scansize) {
		
		if (this.imageData == null) {
			// RGBC[Wi[obt@쐬
			int width = getWidth();
			int height = getHeight();
			if (width == -1 || height == -1) {
				// C[WTCY킩Ȃꍇ̓^[
				return;
			}
			this.imageData = new int[width * height];
		}
		
		// gpJ[f肷
		ColorModel currentModel = model;
		if (currentModel == null) {
			currentModel = this.colorModel;
		}
		
		if (ColorModel.getRGBdefault().equals(currentModel)) {
			// ftHgRGB`̏ꍇAz̓ePɃRs[
			if (x == 0 && y == 0) {
				System.arraycopy(pixels, off, this.imageData, y * scansize + x, w * h);
			} else {
				for (int j = y; j < h; ++j) {
					for (int i = x; i < w; ++i) {
						this.imageData[i + j * getWidth()] = pixels[i + j * scansize + off];
					}
				}
			}
		} else {
			// RGB`ɕϊAobt@ɓĂ
			for (int i = x; i < w; ++i) {
				for (int j = y; j < h; ++j) {
					// WRGB`ɕϊ
					int pixel = pixels[off + j * scansize + i];
					int rgb = currentModel.getRGB(pixel);
					imageData[j * w + i] = rgb;	// w  scansize ̂ǂgp̂H
				}
			}
		}
	}
	
	/**
	 * C[W̊ʒm
	 */
	public void imageComplete(int status) {
		// System.err.println("WCEMemoryImage.imageComlete() called.");
		switch (status) {
			case STATICIMAGEDONE:
			case SINGLEFRAMEDONE:
			case SINGLEFRAME:		// GNU ClasspathMemoryImageSource͂̃tOnĂ
				{
					if (this.imageData != null) {
						// lCeBurbg}bvXV
						updateNativeBitmap(getWindowHandle(),
										   getBitmapHandle(),
										   this.imageData,
										   getWidth(),
										   getHeight());
						
						// f[^]̂Ńobt@͕svɂȂ
						this.imageData = null;
					}
					// tOݒ肷
					int flags = ((status & STATICIMAGEDONE) != 0)
									? ImageObserver.ALLBITS
									: ImageObserver.FRAMEBITS;
					setFlags(getFlags() | flags);
					
					// IuU[oɒʒm
					notifyImageObservers(getFlags(), 0, 0, getWidth(), getHeight());
				}
				break;
			default:
				{
					// IuU[oɃG[ʒm
					setFlags(ImageObserver.ERROR | ImageObserver.ABORT);
					notifyImageObservers(getFlags(), -1, -1, -1, -1);
				}
				break;
		// System.err.println("\tWCEMemoryImage.imageComlete() return.");
		}
	}
	
	/**
	 * lCeBurbg}bv̓eXV
	 */
	private native void updateNativeBitmap(int windowHandle,
										   int bitmapHandle,
										   int[] imageData,
										   int width,
										   int height);
	
	
	/**
	 * rbg}bv쐬B
	 *
	 * @param	windowHandle			EChEnh
	 * @return	foCXReLXgB쐬łȂꍇ0
	 *
	 */
	protected int createBitmapHandle(int windowHandle) {
		int hBitmap = 0;
		int width = getWidth();
		int height = getHeight();
		if (width >= 0 && height >= 0) {
			// C[W̃TCY肳Ă΁A̎_Ńrbg}bvnh쐬
			// C[W̓e͂̌ύX\
			hBitmap = createNativeBitmapHandle(windowHandle,
										   width,
										   height);
		}
		return hBitmap;
	}
	
	/**
	 * lCeBurbg}bv쐬
	 */
	private native int createNativeBitmapHandle(int windowHandle,
												 int width,
												 int height);
}
