/*
 * get_env.c:   set the values of `memcheck', `memfp', `memlist' or `merrfunc'
 *      by environment variables for memory.c and listheap.c.
 *  1996/09     V.2.0   kmatsui
 *  1997/03     V.2.1   kmatsui
 *  1998/05     V.2.2   kmatsui
 *  1998/11     V.2.3   kmatsui
 */

#include    <stdio.h>
#include    <string.h>
#include    <stdlib.h>
#include    <ctype.h>

extern int      memcheck;
extern unsigned memlist;
extern FILE     *memfp;
extern void     (*merrfunc)( int);
extern void     print_memerror( int);
extern void     memerr_list( int);
extern void     merr_list_exit( int);

#ifdef UNDER_CE
/* Windows CEł getenv ݂͑Ȃ */
#define	getenv(s)	NULL
#endif

int     set_memcheck( void)
/*
 * Get the environment variable `MEMCHECK', evaluate the value and set the
 * value to `memcheck'.
 * Return the value set on success, else return -1.
 */
{
    static int  val = -1;
    char    *env;

    if (val != -1) {
        return val;
    } else if ((env = getenv( "MEMCHECK")) == NULL) {
        return -1;
    } else {
        val = atoi( env);
        if (val < 0 || val > 7) {
            val = -1;
            return val;
        }
        return (memcheck = val);
    }
}

unsigned    set_memlist( void)
/*
 * Get the environment variable `MEMLIST', evaluate the value and set the
 * value to `memlist'.
 * Return the value set on success, else return 0.
 */
{
    static unsigned     val = 0;
    char    *env;
	
    if (val != 0) {
        return val;
    } else if ((env = getenv( "MEMLIST")) == NULL) {
        return 0;
    } else {
        val = (unsigned) atol( env);
            /* Use of atol() is incorrect, yet enough in this case  */
        return (memlist = val);
    }
}

FILE    *set_memfp( void)
/*
 * Get the environment variable `MEMFP', evaluate the value and set `memfp'
 * with stdout on 1, stderr on 2 or FILE* on any file-name.
 * Return the value set to 'memfp' on success, else return NULL.
 */
{
#if 0
    static int  val = -1;
    char    *env;

    if (val != -1) {
        return stdin + val;
    } else if ((env = getenv( "MEMFP")) != NULL) {
        if (isdigit( *env)) {
            val = atoi( env);
            if (val == 1 || val == 2)
                return (memfp = val == 1 ? stdout : stderr);
        } else if (isalpha( *env)) {
            if ((memfp = fopen( env, "a")) != NULL) {
                val = memfp - stdin;
                return memfp;
            }
        }
        val = -1;
    }
#endif
    return (FILE *)NULL;
}

typedef void (*merr_t)( int);

void (*set_merrfunc( void))( int)
/*
 * Get the environment variable `MERRFUNC', evaluate the value and set
 * `merrfunc' with the pointer to the named function.
 * The named functions should be one of `exit', `print_memerror',
 * pmemerr_list' or `merr_list_exit'.
 * Return the value set to `merrfunc' on success, else return NULL.
 */
{
    static merr_t   val = (merr_t)-1;
    char    *env;

    if (val != (merr_t)-1) {
        return val;
    } else if ((env = getenv( "MERRFUNC")) == NULL) {
        return (merr_t)NULL;
    } else {
        if (strcmp( env, "exit") == 0)
            val = exit;
        else if (strcmp( env, "print_memerror") == 0)
            val = print_memerror;
        else if (strcmp( env, "memerr_list") == 0)
            val = memerr_list;
        else if (strcmp( env, "merr_list_exit") == 0)
            val = merr_list_exit;
        else
            return (merr_t)NULL;
        return (merrfunc = val);
    }
}

