/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.event.EventListenerList;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private static Map<String, CommPortIdentifier> identifiersMap;
    private final String name;
    private final int type;
    private final CommDriver driver;
    private String currentOwner;
    private EventListenerList listeners;

    public CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.name = string;
        this.type = n;
        this.driver = commDriver;
    }

    public static Enumeration getPortIdentifiers() {
        return new IdentifiersEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        Map<String, CommPortIdentifier> map = identifiersMap;
        synchronized (map) {
            CommPortIdentifier commPortIdentifier = identifiersMap.get(string);
            if (commPortIdentifier == null) {
                throw new NoSuchPortException();
            }
            return commPortIdentifier;
        }
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        return CommPortIdentifier.getPortIdentifier(commPort.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPortName(String string, int n, CommDriver commDriver) {
        Map<String, CommPortIdentifier> map = identifiersMap;
        synchronized (map) {
            CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, commDriver);
            identifiersMap.put(string, commPortIdentifier);
        }
    }

    public CommPort open(String string, int n) throws PortInUseException {
        CommPort commPort;
        if (this.isCurrentlyOwned()) {
            this.notifyPortOwnershipListeners(3);
            if (this.isCurrentlyOwned()) {
                PortInUseException portInUseException = new PortInUseException();
                portInUseException.currentOwner = this.currentOwner;
                throw portInUseException;
            }
        }
        if ((commPort = this.driver.getCommPort(this.getName(), this.getPortType())) == null) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            commPort = this.driver.getCommPort(this.getName(), this.getPortType());
            if (commPort == null) {
                throw new PortInUseException();
            }
        }
        this.currentOwner = string;
        this.notifyPortOwnershipListeners(1);
        return commPort;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.type;
    }

    public String getCurrentOwner() {
        return this.currentOwner;
    }

    public boolean isCurrentlyOwned() {
        return this.currentOwner != null;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(CommPortOwnershipListener.class, commPortOwnershipListener);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners != null) {
            this.listeners.remove(CommPortOwnershipListener.class, commPortOwnershipListener);
        }
    }

    void portClosed() {
        this.currentOwner = null;
        this.notifyPortOwnershipListeners(2);
    }

    private void notifyPortOwnershipListeners(int n) {
        if (this.listeners != null) {
            CommPortOwnershipListener[] commPortOwnershipListenerArray = (CommPortOwnershipListener[])this.listeners.getListeners(CommPortOwnershipListener.class);
            for (int i = 0; i < commPortOwnershipListenerArray.length; ++i) {
                commPortOwnershipListenerArray[i].ownershipChange(n);
            }
        }
    }

    static {
        try {
            identifiersMap = new TreeMap<String, CommPortIdentifier>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    String string3 = string.substring(3, string.length() - 1);
                    String string4 = string2.substring(3, string2.length() - 1);
                    return Integer.parseInt(string3) - Integer.parseInt(string4);
                }
            });
            Class<?> clazz = Class.forName("gnu.javax.comm.wce.WCECommDriver");
            CommDriver commDriver = (CommDriver)clazz.newInstance();
            commDriver.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Error error = new Error("Failed to load CommDriver");
            error.initCause(exception);
            throw error;
        }
    }

    static class IdentifiersEnumeration
    implements Enumeration {
        Iterator iter = CommPortIdentifier.access$000().keySet().iterator();

        IdentifiersEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return identifiersMap.get(this.iter.next());
        }
    }
}

