/*
 * Decompiled with CFR 0.152.
 */
package com.mysaifu.mobile.device.tg01;

import com.mysaifu.mobile.device.tg01.TG01AccelerationEvent;
import com.mysaifu.mobile.device.tg01.TG01AccelerationListener;
import com.mysaifu.mobile.device.tg01.TG01ActionEvent;
import com.mysaifu.mobile.device.tg01.TG01ActionListener;
import com.mysaifu.mobile.device.tg01.TG01Exception;
import java.awt.Frame;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TooManyListenersException;

public class TG01Accelerometer {
    public final int DEFAULT_INTERVAL = 200;
    private static TG01Accelerometer INSTANCE;
    private boolean opened;
    private TG01AccelerationListener accelerationListener;
    private TG01ActionListener actionListener;
    private Thread notificationThread;
    private Frame foregroundFrame;

    private TG01Accelerometer() throws TG01Exception {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.loadLibrary("devtg01");
                    return null;
                }
            });
        } else {
            System.loadLibrary("devtg01");
        }
        this.initNative();
    }

    private native void initNative() throws TG01Exception;

    public static synchronized TG01Accelerometer getInstance() throws TG01Exception {
        if (INSTANCE == null) {
            INSTANCE = new TG01Accelerometer();
        }
        return INSTANCE;
    }

    public static boolean isAvailable() {
        try {
            TG01Accelerometer.getInstance();
        }
        catch (TG01Exception tG01Exception) {
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        return true;
    }

    public void open() throws TG01Exception {
        this.open(200);
    }

    public synchronized void open(int n) throws TG01Exception {
        if (n <= 0) {
            throw new IllegalArgumentException("interval<=0");
        }
        if (this.opened) {
            throw new TG01Exception("Already open.");
        }
        this.opened = true;
        if (n < 100) {
            n = 100;
        } else if (n % 100 != 0) {
            n += 100 - n % 100;
        }
        this.startNotificationThread(n);
        this.openNative(n);
    }

    private native void openNative(int var1) throws TG01Exception;

    public synchronized void close() throws TG01Exception {
        if (this.opened) {
            this.opened = false;
            this.closeNative();
            this.notificationThread = null;
        }
    }

    private native void closeNative() throws TG01Exception;

    public void addTG01AccelerationListener(TG01AccelerationListener tG01AccelerationListener) throws TooManyListenersException {
        if (this.accelerationListener != null) {
            throw new TooManyListenersException();
        }
        this.accelerationListener = tG01AccelerationListener;
    }

    public void removeTG01AccelerationListener(TG01AccelerationListener tG01AccelerationListener) {
        if (this.accelerationListener == tG01AccelerationListener) {
            this.accelerationListener = null;
        }
    }

    protected TG01AccelerationListener getTG01AccelerationListener() {
        return this.accelerationListener;
    }

    public void addTG01ActionListener(TG01ActionListener tG01ActionListener) throws TooManyListenersException {
        if (this.actionListener != null) {
            throw new TooManyListenersException();
        }
        this.actionListener = tG01ActionListener;
    }

    public void removeTG01ActionListener(TG01ActionListener tG01ActionListener) {
        if (this.actionListener == tG01ActionListener) {
            this.actionListener = null;
        }
    }

    protected TG01ActionListener getTG01ActionListener() {
        return this.actionListener;
    }

    static void notifyTG01AccelerationListener(int n, int n2, int n3) {
        if (INSTANCE == null) {
            throw new IllegalStateException("INSTANCE==null");
        }
        TG01AccelerationListener tG01AccelerationListener = INSTANCE.getTG01AccelerationListener();
        if (tG01AccelerationListener != null) {
            tG01AccelerationListener.notify(new TG01AccelerationEvent(INSTANCE, n, n2, n3));
        }
    }

    static void notifyTG01ActionListener(int n, int n2) {
        if (INSTANCE == null) {
            throw new IllegalStateException("INSTANCE==null");
        }
        TG01ActionListener tG01ActionListener = INSTANCE.getTG01ActionListener();
        if (tG01ActionListener != null) {
            TG01ActionEvent tG01ActionEvent = new TG01ActionEvent(INSTANCE, n, n2);
            switch (n) {
                case 1: {
                    tG01ActionListener.rotated(tG01ActionEvent);
                    break;
                }
                case 2: {
                    tG01ActionListener.shaked(tG01ActionEvent);
                    break;
                }
                case 3: {
                    tG01ActionListener.doubleTapped(tG01ActionEvent);
                    break;
                }
                case 4: {
                    tG01ActionListener.tilted(tG01ActionEvent);
                }
            }
        }
    }

    public synchronized void suspendSystemActionResponse(Frame frame) throws TG01Exception, NullPointerException, IllegalArgumentException {
        if (frame == null) {
            throw new NullPointerException("foregroundFrame");
        }
        if (!frame.isDisplayable()) {
            throw new IllegalArgumentException("foregroundFrame.isDisplayable() returns false");
        }
        this.foregroundFrame = frame;
        this.suspendNativeSystemActionResponse(frame);
    }

    private native void suspendNativeSystemActionResponse(Frame var1);

    public synchronized void resumeSystemActionResponse() throws TG01Exception {
        if (this.foregroundFrame != null) {
            this.resumeNativeSystemActionResponse(this.foregroundFrame);
            this.foregroundFrame = null;
        }
    }

    private native void resumeNativeSystemActionResponse(Frame var1);

    protected void finalize() throws Exception {
        this.close();
    }

    private void startNotificationThread(final int n) {
        this.notificationThread = new Thread(){

            @Override
            public void run() {
                TG01Accelerometer.this.nativeLoop(n);
            }
        };
        this.notificationThread.start();
    }

    private native void nativeLoop(int var1);
}

