/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import jp.co.argo21.commons.swing.ByteLimitedDocument;

public class NumericDocument
extends ByteLimitedDocument {
    private boolean hasPoint = false;
    private boolean hasSign = false;
    private boolean isPositive = false;
    private boolean isInteger = false;

    public NumericDocument(int limit) {
        super(limit);
    }

    public NumericDocument(int limit, boolean isInteger) {
        super(limit);
        this.isInteger = isInteger;
    }

    public NumericDocument(int limit, boolean isInteger, boolean isPositive) {
        super(limit);
        this.isInteger = isInteger;
        this.isPositive = isPositive;
    }

    public void insertString(int offset, String s, AttributeSet a) throws BadLocationException {
        if (s == null) {
            return;
        }
        char[] chars = s.toCharArray();
        int max = chars.length;
        boolean tempPoint = this.hasPoint;
        boolean tempSign = this.hasSign;
        block5: for (int i = 0; i < max; ++i) {
            char c = chars[i];
            switch (c) {
                case '.': {
                    if (this.isInteger) {
                        return;
                    }
                    if (tempPoint) {
                        return;
                    }
                    if (offset == 0) {
                        return;
                    }
                    if (i != 0) {
                        return;
                    }
                    char c2 = this.getText(0, 1).charAt(0);
                    if (c2 == '-' && offset < 2) {
                        return;
                    }
                    tempPoint = true;
                    continue block5;
                }
                case '-': {
                    if (this.isPositive) {
                        return;
                    }
                    if (tempSign) {
                        return;
                    }
                    if (offset != 0) {
                        return;
                    }
                    tempSign = true;
                    continue block5;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                default: {
                    return;
                }
            }
        }
        super.insertString(offset, s, a);
        this.hasPoint = tempPoint;
        this.hasSign = tempSign;
    }

    public void remove(int offset, int len) throws BadLocationException {
        boolean tempPoint = this.hasPoint;
        boolean tempSign = this.hasSign;
        String s = this.getText(offset, len);
        if (s.indexOf(46) > -1) {
            tempPoint = false;
        }
        if (s.indexOf(45) > -1) {
            tempSign = false;
        }
        super.remove(offset, len);
        this.hasPoint = tempPoint;
        this.hasSign = tempSign;
    }
}

