/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;

public class ConcurrentLayer {
    private ActivityElement start;
    private ActivityElement end;
    private ConcurrentLayer parentLayer;
    private List subLayers = new ArrayList();
    private List activities = new ArrayList();

    public ConcurrentLayer(ConcurrentLayer p, ActivityElement s, ActivityElement e) {
        this.parentLayer = p;
        this.start = s;
        this.end = e;
    }

    public ConcurrentLayer() {
    }

    public String getLayerID() {
        return this.start.getBlockID();
    }

    public void addLayerElement(ActivityElement elem) {
        if (elem == null) {
            return;
        }
        elem.setAffiliateBID(this.getStartElement().getBlockID());
        this.activities.add(elem);
    }

    public void removeLayerElement(ActivityElement elem) {
        if (elem == null) {
            return;
        }
        if (this.activities.contains(elem)) {
            this.activities.remove(elem);
        } else {
            Iterator it = this.subLayers.iterator();
            while (it.hasNext()) {
                ConcurrentLayer layer = (ConcurrentLayer)it.next();
                layer.removeLayerElement(elem);
            }
        }
        elem.setAffiliateBID(null);
        elem.setParentBID(null);
    }

    public void addLayer(ConcurrentLayer layer) {
        if (layer == null) {
            return;
        }
        layer.getStartElement().setParentBID(this.getStartElement().getBlockID());
        layer.getEndElement().setParentBID(this.getStartElement().getBlockID());
        this.addLayerElement(layer.getStartElement());
        this.addLayerElement(layer.getEndElement());
        this.subLayers.add(layer);
    }

    public void removeLayer(ConcurrentLayer l) {
        if (l == null) {
            return;
        }
        if (this.subLayers.contains(l)) {
            this.removeLayerElement(l.getStartElement());
            this.removeLayerElement(l.getEndElement());
            l.clearParentLayer();
            this.subLayers.remove(l);
        } else {
            Iterator it = this.subLayers.iterator();
            while (it.hasNext()) {
                ConcurrentLayer layer = (ConcurrentLayer)it.next();
                layer.removeLayer(l);
            }
        }
    }

    public void collectAllLayerElement(List list) {
        Iterator lit = this.subLayers.iterator();
        while (lit.hasNext()) {
            ConcurrentLayer layer = (ConcurrentLayer)lit.next();
            layer.collectAllLayerElement(list);
        }
        Iterator ait = this.activities.iterator();
        while (ait.hasNext()) {
            ActivityElement act = (ActivityElement)ait.next();
            if (list.contains(act)) continue;
            list.add(act);
        }
        if (!list.contains(this.start)) {
            list.add(this.start);
        }
        if (!list.contains(this.end)) {
            list.add(this.end);
        }
    }

    public ConcurrentLayer getReceivableLayer(int lx, int ly) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getReceivableLayer(lx, ly);
            if (layer == null) continue;
            return layer;
        }
        int slx = this.start.getLogicalX();
        int sly = this.start.getLogicalY();
        int elx = this.end.getLogicalX();
        int ely = this.end.getLogicalY();
        if (lx >= slx && lx <= elx && ly >= sly && ly <= ely) {
            return this;
        }
        return null;
    }

    public ConcurrentLayer getContainLayer(ActivityElement elem) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ConcurrentLayer layer = ((ConcurrentLayer)it.next()).getContainLayer(elem);
            if (layer == null) continue;
            return layer;
        }
        if (elem == this.getStartElement()) {
            return this;
        }
        if (elem == this.getEndElement()) {
            return this;
        }
        if (this.activities.contains(elem)) {
            return this;
        }
        return null;
    }

    public ActivityElement getStartElement() {
        return this.start;
    }

    public ActivityElement getEndElement() {
        return this.end;
    }

    public ConcurrentLayer getParentLayer() {
        return this.parentLayer;
    }

    public void clearParentLayer() {
        this.parentLayer = null;
    }

    public Point getMinimumUpperPoint() {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        Iterator it = this.activities.iterator();
        while (it.hasNext()) {
            ActivityElement act = (ActivityElement)it.next();
            if (x > act.getLogicalX()) {
                x = act.getLogicalX();
            }
            if (y <= act.getLogicalY()) continue;
            y = act.getLogicalY();
        }
        return new Point(x, y);
    }

    public Point getMinimumLowerPoint() {
        int x = 0;
        int y = 0;
        Iterator it = this.activities.iterator();
        while (it.hasNext()) {
            ActivityElement act = (ActivityElement)it.next();
            if (x < act.getLogicalX()) {
                x = act.getLogicalX();
            }
            if (y >= act.getLogicalY()) continue;
            y = act.getLogicalY();
        }
        if (x == -1) {
            x = this.start.getLogicalX();
        }
        if (y == -1) {
            y = this.start.getLogicalY();
        }
        return new Point(x, y);
    }

    public void paintLayerBackgroud(Graphics g, Color c, int grid) {
        int x = this.start.getLogicalX() * grid;
        int y = this.start.getLogicalY() * grid;
        int w = this.end.getLogicalX() * grid + grid - x;
        int h = this.end.getLogicalY() * grid + grid - y;
        g.setColor(c);
        g.fillRect(x, y, w, h);
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
        }
    }

    public void paintLayerBorder(Graphics g, Color c, int grid) {
        int x = this.start.getLogicalX() * grid;
        int y = this.start.getLogicalY() * grid;
        int w = this.end.getLogicalX() * grid + grid - x;
        int h = this.end.getLogicalY() * grid + grid - y;
        g.setColor(c);
        g.drawRect(x, y, w, h);
        g.drawRect(x + 1, y + 1, w - 2, h - 2);
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
        }
    }

    public void setEndElement(ActivityElement element) {
        this.end = element;
    }

    public void setParentLayer(ConcurrentLayer layer) {
        this.parentLayer = layer;
    }

    public void setStartElement(ActivityElement element) {
        this.start = element;
    }
}

