/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ConditionEditorView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;

public class ConditionDialog
extends JDialog {
    private ConditionEditorView view;

    public static Expression showDialog(Component c, Expression exp) {
        Frame frame = JOptionPane.getFrameForComponent(c);
        ConditionDialog dialog = new ConditionDialog(frame, exp);
        dialog.setVisible(true);
        Expression result = dialog.view.getExpression();
        dialog.dispose();
        return result;
    }

    private ConditionDialog(Frame frame, Expression exp) {
        super(frame, true);
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.setTitle(rm.getResource("ConditionDialog.title"));
        this.view = new ConditionEditorView();
        this.view.setExpression(exp);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.view);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 10, 10));
        CloseAction listener = new CloseAction();
        JButton setButton = new JButton(rm.getResource("JButton.label.set"));
        setButton.setActionCommand("OK_OPTION");
        setButton.addActionListener(listener);
        this.getRootPane().setDefaultButton(setButton);
        buttonPane.add(setButton);
        JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
        cancelButton.addActionListener(listener);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)scroll, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if ("OK_OPTION".equals(e.getActionCommand())) {
                if (!ConditionDialog.this.view.check()) {
                    return;
                }
                ConditionDialog.this.view.commit();
            }
            ConditionDialog.this.setVisible(false);
        }
    }
}

