/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;

public class ElementReceivableView
extends JComponent
implements MouseListener,
DropTargetListener {
    private static final Dimension VIEW_SIZE = new Dimension(60, 60);
    private static final Color MASK_COLOR = new Color(255, 255, 255, 128);
    private static final Border border = BorderFactory.createLoweredBevelBorder();
    private List listeners = new ArrayList();
    private boolean isReceiving;
    private String elementType;
    private Element element;

    public ElementReceivableView(String type) {
        this.elementType = type;
        this.setSize(VIEW_SIZE);
        this.setPreferredSize(VIEW_SIZE);
        this.setMinimumSize(VIEW_SIZE);
        DropTarget dt = new DropTarget(this, this);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, size.width, size.height);
        if (this.isReceiving || this.element != null) {
            Icon icon = IconManager.getIcon(this.elementType);
            int iconX = (size.width - icon.getIconWidth()) / 2;
            int iconY = (size.height - icon.getIconHeight()) / 2;
            icon.paintIcon(this, g, iconX, iconY);
        }
        if (this.isReceiving) {
            g.setColor(MASK_COLOR);
            g.fillRect(0, 0, size.width, size.height);
        }
        border.paintBorder(this, g, 0, 0, size.width, size.height);
        g.dispose();
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (this.element == null) {
            return;
        }
        if (e.getClickCount() >= 2) {
            InspectorDialog.showDialog((Component)this, this.element);
            this.fireElementChanged();
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent e) {
        this.isReceiving = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragOver(DropTargetDragEvent e) {
        try {
            DataFlavor[] flavors = e.getCurrentDataFlavors();
            if (flavors == null) {
                return;
            }
            if (flavors.length != 1) {
                return;
            }
            DataFlavor df = flavors[0];
            if (df == null) {
                return;
            }
            if (df.getPrimaryType().equals("x-workflowdesigner") && df.getSubType().equals("element") && df.getHumanPresentableName().equals(this.elementType)) {
                this.isReceiving = true;
                this.repaint();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(3);
        try {
            DataFlavor df;
            DataFlavor[] flavors;
            boolean invalid = false;
            Transferable t = e.getTransferable();
            if (t == null) {
                invalid = true;
            }
            if ((flavors = t.getTransferDataFlavors()) == null) {
                invalid = true;
            }
            if (flavors.length != 1) {
                invalid = true;
            }
            if ((df = flavors[0]) == null) {
                invalid = true;
            }
            if (df.getPrimaryType().equals("x-workflowdesigner") && df.getSubType().equals("element")) {
                if (!df.getHumanPresentableName().equals(this.elementType)) {
                    invalid = true;
                }
            } else {
                invalid = true;
            }
            if (invalid) {
                e.dropComplete(false);
                return;
            }
            this.setElement((Element)t.getTransferData(df));
            this.fireElementDropped();
            e.dropComplete(true);
        }
        catch (Exception ex) {
            e.dropComplete(false);
        }
        finally {
            this.isReceiving = false;
            this.repaint();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void addChangeElementListener(DropElementListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeChangeElementListener(DropElementListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void fireElementChanged() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ChangeElementListener l = (ChangeElementListener)it.next();
            l.elementChanged(this.element);
        }
    }

    private void fireElementDropped() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ChangeElementListener l = (ChangeElementListener)it.next();
            l.elementDropped(this.element);
        }
    }
}

