/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.ModeChangeListener;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.dnd.ActivityItemContext;

public class FlowDesignToolBar
extends JToolBar {
    public static final int POINT_MODE = 1;
    public static final int CONNECT_MODE = 2;
    public static final int SIM_MODE = 3;
    private static final Dimension BUTTON_SIZE = new Dimension(50, 50);
    private static final Point CURSOR_POINT = new Point(16, 16);
    JToggleButton pointerButton;
    private List listeners = new ArrayList();
    private int mode = 1;
    private boolean draggable = true;
    private ActivityItem[] buttons = new ActivityItem[WorkflowDesignerConstants.DROPPABLE_ITEMS.length];

    public FlowDesignToolBar() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.setFloatable(false);
        ButtonGroup group = new ButtonGroup();
        this.pointerButton = new ModeButton("pointer");
        this.pointerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlowDesignToolBar.this.mode = 1;
                FlowDesignToolBar.this.setDraggable(true);
                FlowDesignToolBar.this.fireModeChanged();
            }
        });
        this.add(this.pointerButton);
        int maxItem = WorkflowDesignerConstants.DROPPABLE_ITEMS.length;
        for (int i = 0; i < maxItem; ++i) {
            this.buttons[i] = new ActivityItem(WorkflowDesignerConstants.DROPPABLE_ITEMS[i]);
            this.add(this.buttons[i]);
        }
        ModeButton connectButton = new ModeButton("connect");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlowDesignToolBar.this.mode = 2;
                FlowDesignToolBar.this.setDraggable(false);
                FlowDesignToolBar.this.fireModeChanged();
            }
        });
        this.add(connectButton);
        ModeButton simulateButton = new ModeButton("simulate");
        simulateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlowDesignToolBar.this.mode = 3;
                FlowDesignToolBar.this.setDraggable(false);
                FlowDesignToolBar.this.fireModeChanged();
            }
        });
        this.add(simulateButton);
        this.addSeparator();
        JButton validateButton = new JButton(IconManager.getIcon("validation"));
        validateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkflowDesignerManager.getMainFrame().validatePackage();
            }
        });
        validateButton.setPressedIcon(IconManager.getIcon("validation-s"));
        validateButton.setContentAreaFilled(false);
        validateButton.setFocusPainted(false);
        validateButton.setRolloverEnabled(true);
        validateButton.setBorderPainted(false);
        validateButton.setMaximumSize(BUTTON_SIZE);
        validateButton.setPreferredSize(BUTTON_SIZE);
        validateButton.setToolTipText(rm.getResource("FlowDesignToolBar.validation.tooltip"));
        this.add(validateButton);
        this.addSeparator();
        String iconName = "package";
        JButton packageButton = new JButton(IconManager.getIcon(iconName));
        packageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkflowDesignerManager.getMainFrame().showPackageInspector();
            }
        });
        packageButton.setPressedIcon(IconManager.getIcon(iconName + "-s"));
        packageButton.setContentAreaFilled(false);
        packageButton.setFocusPainted(false);
        packageButton.setRolloverEnabled(true);
        packageButton.setBorderPainted(false);
        packageButton.setMaximumSize(BUTTON_SIZE);
        packageButton.setPreferredSize(BUTTON_SIZE);
        packageButton.setToolTipText(rm.getResource("FlowDesignToolBar.model.tooltip"));
        this.add(packageButton);
        group.add(this.pointerButton);
        group.add(connectButton);
        group.add(simulateButton);
        this.pointerButton.setSelected(true);
    }

    void init() {
        this.pointerButton.setSelected(true);
        this.listeners.clear();
    }

    public void addModeChangedListener(ModeChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeModeChangedListener(ModeChangeListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void fireModeChanged() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ModeChangeListener l = (ModeChangeListener)it.next();
            l.modeChanged(this.mode);
        }
    }

    public void setDraggable(boolean flag) {
        this.draggable = flag;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setEnabled(this.draggable);
        }
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    class ActivityItem
    extends JLabel
    implements DragGestureListener {
        private String name;

        public ActivityItem(String name) {
            this.name = name;
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            FlowDesignToolBar.this.setBorderPainted(true);
            this.setIcon(IconManager.getIcon(name));
            this.setMaximumSize(BUTTON_SIZE);
            this.setPreferredSize(BUTTON_SIZE);
            this.setToolTipText(rm.getResource("FlowDesignToolBar." + name + ".tooltip"));
            DragSource dragSource = new DragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Point p = e.getDragOrigin();
            int ix = p.y / 50;
            if (ix < 0) {
                return;
            }
            if (ix >= WorkflowDesignerConstants.DROPPABLE_ITEMS.length) {
                return;
            }
            ActivityItemContext t = new ActivityItemContext(this.name);
            ImageIcon icon = (ImageIcon)IconManager.getIcon(this.name);
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), CURSOR_POINT, this.name);
            e.startDrag(cursor, t);
        }
    }

    class ModeButton
    extends JToggleButton {
        public ModeButton(String name) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setIcon(IconManager.getIcon(name));
            this.setSelectedIcon(IconManager.getIcon(name + "-s"));
            this.setMaximumSize(BUTTON_SIZE);
            this.setPreferredSize(BUTTON_SIZE);
            this.setToolTipText(rm.getResource("FlowDesignToolBar." + name + ".tooltip"));
        }
    }
}

