/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ActivityInspectorView;
import jp.co.argo21.nautica.tool.wfd.FlowDesignToolBar;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

public class ProcessDesignFrame
extends JInternalFrame {
    private JTabbedPane tabbedPane;
    private JSplitPane splitPane;
    private ProcessDesignView view;
    private ActivityInspectorView inspectorView;
    private ProcessElement process;
    private boolean isInfoOpened;

    public ProcessDesignFrame(ProcessElement proc) {
        super("", true, true, true, true);
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.setFrameIcon(IconManager.getIcon("process-frameicon"));
        this.process = proc;
        this.view = new ProcessDesignView(this.process);
        this.view.addProcessInfoActionListener(new ProcessInfoAction());
        this.view.addDividerActionListener(new DividerAction());
        this.inspectorView = new ActivityInspectorView();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(this.view);
        this.splitPane.setRightComponent(this.inspectorView);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(rm.getResource("ProcessDesignFrame.tab.0"), this.splitPane);
        Container contentPane = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        contentPane.setLayout(layout);
        contentPane.add((Component)this.tabbedPane, "Center");
        this.setTitle(rm.getResource("ProcessDesignFrame.title"));
        this.setSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameOpened(InternalFrameEvent e) {
                ProcessDesignFrame.this.opened();
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                ProcessDesignFrame.this.activated();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                ProcessDesignFrame.this.deactivated();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                ProcessDesignFrame.this.close();
            }
        });
        this.validate();
    }

    public ProcessDesignView getView() {
        return this.view;
    }

    public boolean isEditingProcess(ProcessElement proc) {
        return this.process == proc;
    }

    public void setInspector(ActivityElement act) {
        this.inspectorView.inspect(act);
    }

    public void showInspector() {
        this.splitPane.setDividerLocation(0.5);
        this.isInfoOpened = true;
    }

    public ProcessElement getProcess() {
        return this.process;
    }

    void initialize() {
        ActivityElement selected = this.view.getProcessFlowView().getSelectedActivity();
        this.inspectorView.inspect(selected);
        this.isInfoOpened = false;
        this.splitPane.setDividerLocation(1.0);
    }

    void opened() {
        FlowDesignToolBar toolbar = WorkflowDesignerManager.getMainFrame().getToolbox().getToolBar();
        toolbar.addModeChangedListener(this.view);
    }

    void activated() {
        this.view.getProcessFlowView().notifyFrameIsActivated();
    }

    void deactivated() {
        this.view.getProcessFlowView().notifyFrameIsDeactivated();
    }

    void close() {
        FlowDesignToolBar toolbar = WorkflowDesignerManager.getMainFrame().getToolbox().getToolBar();
        toolbar.removeModeChangedListener(this.view);
        this.setVisible(false);
        this.dispose();
    }

    class DividerAction
    implements ActionListener {
        DividerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessDesignFrame.this.isInfoOpened) {
                ProcessDesignFrame.this.splitPane.setDividerLocation(1.0);
            } else {
                ProcessDesignFrame.this.splitPane.setDividerLocation(0.5);
            }
            ProcessDesignFrame.this.isInfoOpened = !ProcessDesignFrame.this.isInfoOpened;
        }
    }

    class ProcessInfoAction
    implements ActionListener {
        ProcessInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            InspectorDialog.showDialog((Component)ProcessDesignFrame.this, ProcessDesignFrame.this.process);
        }
    }
}

