/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.ModeChangeListener;
import jp.co.argo21.nautica.tool.wfd.ProcessFlowView;
import jp.co.argo21.nautica.tool.wfd.ResizingCorner;
import jp.co.argo21.nautica.tool.wfd.Ruler;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

public class ProcessDesignView
extends JScrollPane
implements ModeChangeListener,
ChangeListener {
    private ProcessFlowView view;
    private Ruler topRuler;
    private Ruler leftRuler;
    private JButton processInfoButton;
    private JButton dividerButton;

    public ProcessDesignView(ProcessElement proc) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        Dimension resizingSize = new Dimension(15, 15);
        ResizingCorner topResizing = new ResizingCorner(1);
        topResizing.setToolTipText(rm.getResource("ProcessDesignView.tooltip.0"));
        topResizing.setPreferredSize(resizingSize);
        topResizing.setSize(resizingSize);
        ResizingCorner leftResizing = new ResizingCorner(2);
        leftResizing.setToolTipText(rm.getResource("ProcessDesignView.tooltip.1"));
        leftResizing.setPreferredSize(resizingSize);
        leftResizing.setSize(resizingSize);
        ResizingCorner rightResizing = new ResizingCorner(4);
        rightResizing.setToolTipText(rm.getResource("ProcessDesignView.tooltip.2"));
        rightResizing.setPreferredSize(resizingSize);
        rightResizing.setSize(resizingSize);
        ResizingCorner bottomResizing = new ResizingCorner(3);
        bottomResizing.setToolTipText(rm.getResource("ProcessDesignView.tooltip.3"));
        bottomResizing.setPreferredSize(resizingSize);
        bottomResizing.setSize(resizingSize);
        topResizing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDesignView.this.view.reduceHeight();
            }
        });
        leftResizing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDesignView.this.view.reduceWidth();
            }
        });
        rightResizing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDesignView.this.view.expandWidth();
            }
        });
        bottomResizing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDesignView.this.view.expandHeight();
            }
        });
        Border border = BorderFactory.createRaisedBevelBorder();
        JPanel urCorner = new JPanel();
        urCorner.setLayout(new BorderLayout());
        urCorner.add((Component)leftResizing, "North");
        urCorner.add((Component)rightResizing, "South");
        JPanel llCorner = new JPanel();
        llCorner.setLayout(new BorderLayout());
        llCorner.add((Component)topResizing, "West");
        llCorner.add((Component)bottomResizing, "East");
        this.processInfoButton = new JButton(IconManager.getIcon("process-mini"));
        this.processInfoButton.setToolTipText(rm.getResource("ProcessDesignView.tooltip.4"));
        this.dividerButton = new JButton();
        this.dividerButton.setBackground(Color.orange);
        this.dividerButton.setBackground(Color.orange);
        this.dividerButton.setToolTipText(rm.getResource("ProcessDesignView.tooltip.5"));
        this.topRuler = new Ruler(0, 80);
        this.leftRuler = new Ruler(1, 80);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.setCorner("UPPER_RIGHT_CORNER", urCorner);
        this.setCorner("LOWER_LEFT_CORNER", llCorner);
        this.setCorner("UPPER_LEFT_CORNER", this.processInfoButton);
        this.setCorner("LOWER_RIGHT_CORNER", this.dividerButton);
        this.setColumnHeaderView(this.topRuler);
        this.setRowHeaderView(this.leftRuler);
        this.view = new ProcessFlowView(proc);
        this.setViewportView(this.view);
        this.viewport.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        Dimension viewSize = this.view.getSize();
        Dimension topSize = this.topRuler.getPreferredSize();
        topSize.setSize(topSize.width, 30);
        if (topSize.width != viewSize.width) {
            topSize.width = viewSize.width;
            this.topRuler.setPreferredSize(topSize);
            this.topRuler.setSize(topSize);
            this.topRuler.repaint();
        }
        Dimension leftSize = this.leftRuler.getPreferredSize();
        leftSize.setSize(30, leftSize.height);
        if (leftSize.height != viewSize.height) {
            leftSize.height = viewSize.height;
            this.leftRuler.setPreferredSize(leftSize);
            this.leftRuler.setSize(leftSize);
            this.leftRuler.repaint();
        }
    }

    public void modeChanged(int mode) {
        if (mode == 2) {
            this.view.setControllerID(1);
        } else if (mode == 3) {
            this.view.setControllerID(2);
        } else {
            this.view.setControllerID(0);
        }
    }

    public ProcessFlowView getProcessFlowView() {
        return this.view;
    }

    public void addProcessInfoActionListener(ActionListener listener) {
        this.processInfoButton.addActionListener(listener);
    }

    public void addDividerActionListener(ActionListener listener) {
        this.dividerButton.addActionListener(listener);
    }
}

