/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.Grid;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.ActivityStateFactory;
import jp.co.argo21.nautica.tool.wfd.ConcurrentLayer;
import jp.co.argo21.nautica.tool.wfd.ConcurrentLayerManager;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.ActivityElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.TransitionElementImpl;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;
import jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper;
import jp.co.argo21.nautica.tool.wfd.sim.SimulationListener;
import jp.co.argo21.nautica.tool.wfd.sim.SimurateManager;

public class ProcessFlowView
extends JComponent
implements MouseListener,
MouseMotionListener,
DropTargetListener,
SimulationListener {
    public static final int POINT_CONTROLLER = 0;
    public static final int CONNECT_CONTROLLER = 1;
    public static final int SIMULATE_CONTROLLER = 2;
    public static final int CMODE_CONNECT = 0;
    public static final int CMODE_DISCONNECT = 1;
    public static final int GRID_SIZE = 80;
    private static final int MAX_ICON_SIZE = 48;
    private static final int INSET_SIZE = 9;
    private static final int MIN_LOGICAL_WIDTH = 10;
    private static final int MIN_LOGICAL_HEIGHT = 10;
    private static final Color LAYER_BACKGROUND = new Color(230, 255, 255, 64);
    private static final Color CONNECTION_BACKGROUND = new Color(255, 255, 230);
    private static final Color SIMULATION_BACKGROUND = new Color(230, 255, 255);
    private static final Font VIEW_FONT = new Font("MonoSpaced", 0, 10);
    private static GeneralPath ARROW_PATH = new GeneralPath(0);
    private Rectangle dropRect;
    private Rectangle cursorRect;
    private Rectangle selectedRect;
    private ActivityElement selectedActivity;
    private ActivityElement sourceActivity;
    private List simulatedActivities = new ArrayList();
    private Map waitActivities = new Hashtable();
    private ProcessFlowViewController[] controllers;
    private int controllerID = 0;
    private int connectingMode = 0;
    private ProcessElement proc;
    private ConcurrentLayerManager root;
    private SimurateManager simulator;

    public ProcessFlowView(ProcessElement proc) {
        this.proc = proc;
        int w = proc.getLogicalWidth();
        int h = proc.getLogicalHeight();
        if (w < 10) {
            w = 10;
            proc.setLogicalWidth(10);
        }
        if (h < 10) {
            h = 10;
            proc.setLogicalHeight(10);
        }
        Dimension size = new Dimension(80 * w + 1, 80 * h + 1);
        this.root = new ConcurrentLayerManager();
        this.root.initConcurrentLayer(proc.getActivities());
        this.simulator = new SimurateManager();
        this.controllers = new ProcessFlowViewController[3];
        this.controllers[0] = new PointerModeFlowViewController();
        this.controllers[1] = new ConnectionModeFlowViewController();
        this.controllers[2] = new SimulationModeFlowViewController();
        DropTarget dt = new DropTarget(this, this);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        SimulatableActivityWrapper sa;
        Iterator sait;
        Shape clip = g.getClip();
        Dimension size = this.getSize();
        g.setColor(Color.gray);
        g.fillRect(0, 0, size.width, size.height);
        Dimension psize = this.getPreferredSize();
        if (this.getControllerID() == 1) {
            g.setColor(CONNECTION_BACKGROUND);
        } else if (this.getControllerID() == 2) {
            g.setColor(SIMULATION_BACKGROUND);
        } else {
            g.setColor(Color.white);
        }
        g.fillRect(0, 0, psize.width, psize.height);
        this.root.paintLayerBackgroud(g, LAYER_BACKGROUND, 80);
        if (this.selectedActivity != null) {
            this.paintActivityBackground(g, Color.pink, this.selectedActivity);
        }
        if (this.getControllerID() == 2) {
            sait = this.simulatedActivities.iterator();
            while (sait.hasNext()) {
                sa = (SimulatableActivityWrapper)sait.next();
                if (sa == null) continue;
                this.paintActivityBackground(g, Color.green, sa.getActivity());
            }
        }
        this.paintView(g);
        if (this.cursorRect != null) {
            g.drawRect(this.cursorRect.x, this.cursorRect.y, this.cursorRect.width, this.cursorRect.height);
        }
        this.root.paintLayerBorder(g, Color.blue, 80);
        g.setColor(Color.red);
        if (this.dropRect != null) {
            g.drawRect(this.dropRect.x, this.dropRect.y, this.dropRect.width, this.dropRect.height);
        }
        if (this.selectedRect != null) {
            g.setColor(Color.red);
            g.drawRect(this.selectedRect.x, this.selectedRect.y, this.selectedRect.width, this.selectedRect.height);
        }
        if (this.getControllerID() == 2) {
            sait = this.simulatedActivities.iterator();
            while (sait.hasNext()) {
                sa = (SimulatableActivityWrapper)sait.next();
                TransitionElement tr = sa.getTransition();
                if (tr == null) continue;
                this.paintTransition(g, Color.blue, tr.getSource(), tr.getDestination());
            }
        }
        if (this.getControllerID() == 1 && this.sourceActivity != null) {
            this.paintConnecting(g);
        }
        g.setClip(clip);
        g.dispose();
    }

    public void paintView(Graphics g) {
        Shape clip = g.getClip();
        g.setFont(VIEW_FONT);
        Dimension psize = this.getPreferredSize();
        Grid.draw(new Rectangle(psize), g, 80);
        g.clipRect(0, 0, psize.width, psize.height);
        g.setColor(Color.black);
        List acts = this.proc.getActivities();
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityElement act = (ActivityElement)ait.next();
            this.paintActivity(g, act);
        }
        List trs = this.proc.getTransitions();
        Iterator tit = trs.iterator();
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            this.paintTransition(g, Color.black, tr.getSource(), tr.getDestination());
        }
        g.setClip(clip);
    }

    private void paintActivityBackground(Graphics g, Color c, ActivityElement act) {
        if (act == null) {
            return;
        }
        int ax = act.getLogicalX();
        int ay = act.getLogicalY();
        int x = 80 * ax;
        int y = 80 * ay;
        int w = 80;
        int h = 80;
        g.setColor(c);
        g.fillRect(x, y, w, h);
    }

    private void paintActivity(Graphics g, ActivityElement act) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        String name = act.getName();
        if (StringUtils.checkNull(name)) {
            name = rm.getResource("ProcessFlowView.noname");
        }
        String type = act.getActivityState().getIconName();
        Icon icon = IconManager.getIcon(type.toString());
        int ax = act.getLogicalX();
        int ay = act.getLogicalY();
        int x = 80 * ax;
        int y = 80 * ay;
        int w = 80;
        int h = 80;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight();
        int iconX = x + (w - iconW) / 2;
        int iconY = y + 9;
        icon.paintIcon(this, g, iconX, iconY);
        FontMetrics metrics = g.getFontMetrics();
        int fontH = metrics.getHeight();
        int descent = metrics.getDescent();
        int lineW = metrics.stringWidth(name);
        int dx = x + (w - lineW) / 2;
        int dy = y + 9 + iconH;
        if (dx < 0) {
            dx = 0;
        }
        dy = dy + fontH - descent;
        g.setColor(SystemColor.textText);
        g.drawString(name, dx, dy);
    }

    private void paintTransition(Graphics g, Color c, ActivityElement src, ActivityElement dst) {
        if (src == null) {
            return;
        }
        if (dst == null) {
            return;
        }
        int sx = src.getLogicalX();
        int sy = src.getLogicalY();
        int dx = dst.getLogicalX();
        int dy = dst.getLogicalY();
        Point sp = this.getSourcePoint(sx, sy, dx, dy);
        Point dp = this.getDestinationPoint(sx, sy, dx, dy);
        this.paintArrowLine(g, c, sp.x, sp.y, dp.x, dp.y);
    }

    private void paintConnecting(Graphics g) {
        if (this.controllerID != 1) {
            return;
        }
        if (this.sourceActivity == null) {
            return;
        }
        if (this.cursorRect == null) {
            return;
        }
        int sx = this.sourceActivity.getLogicalX();
        int sy = this.sourceActivity.getLogicalY();
        int dx = this.cursorRect.x / 80;
        int dy = this.cursorRect.y / 80;
        if (this.getConnectingMode() == 0) {
            Point sp = this.getSourcePoint(sx, sy, dx, dy);
            Point dp = this.getDestinationPoint(sx, sy, dx, dy);
            this.paintArrowLine(g, Color.gray, sp.x, sp.y, dp.x, dp.y);
        } else {
            Point sp = this.getSourcePoint(sx, sy, dx, dy);
            Point dp = this.getDestinationPoint(sx, sy, dx, dy);
            this.paintCrossLine(g, Color.gray, sp.x, sp.y, dp.x, dp.y);
        }
    }

    private void paintArrowLine(Graphics g, Color c, int sx, int sy, int dx, int dy) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        g2.setColor(c);
        g2.drawLine(sx, sy, dx, dy);
        g2.translate(dx, dy);
        double theta = Math.atan2(sy - dy, sx - dx);
        g2.rotate(theta);
        g2.fill(ARROW_PATH);
        g2.draw(ARROW_PATH);
        g2.setTransform(tr);
    }

    private void paintCrossLine(Graphics g, Color c, int sx, int sy, int dx, int dy) {
        this.paintArrowLine(g, c, sx, sy, dx, dy);
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f));
        int x = sx + (dx - sx) / 2;
        int y = sy + (dy - sy) / 2;
        g2.setColor(Color.red);
        g2.drawLine(x - 7, y - 7, x + 7, y + 7);
        g2.drawLine(x + 7, y - 7, x - 7, y + 7);
        g2.setStroke(stroke);
    }

    private int getConnectingMode() {
        return this.connectingMode;
    }

    private void setConnectingMode(int mode) {
        this.connectingMode = mode;
    }

    private Point getSourcePoint(int sx, int sy, int dx, int dy) {
        int x = sx * 80 + 40;
        int y = sy * 80 + 40;
        if (sx < dx) {
            x = sx * 80 + 64;
            y = sy * 80 + 9 + 24;
        } else if (sx > dx) {
            x = sx * 80 + 16;
            y = sy * 80 + 9 + 24;
        } else if (sy < dy) {
            y = sy * 80 + 80 - 9;
        } else if (sy > dy) {
            y = sy * 80 + 9;
        }
        return new Point(x, y);
    }

    private Point getDestinationPoint(int sx, int sy, int dx, int dy) {
        int x = dx * 80 + 40;
        int y = dy * 80 + 40;
        if (sx < dx) {
            x = dx * 80 + 16;
            y = dy * 80 + 9 + 24;
        } else if (sx > dx) {
            x = dx * 80 + 64;
            y = dy * 80 + 9 + 24;
        } else if (sy < dy) {
            y = dy * 80 + 9;
        } else if (sy > dy) {
            y = dy * 80 + 80 - 9;
        }
        return new Point(x, y);
    }

    private ActivityElement getActivity(int mx, int my) {
        int lx = mx / 80;
        int ly = my / 80;
        List acts = this.proc.getActivities();
        Iterator it = acts.iterator();
        while (it.hasNext()) {
            ActivityElement a = (ActivityElement)it.next();
            int x = a.getLogicalX();
            int y = a.getLogicalY();
            if (x != lx || y != ly) continue;
            return a;
        }
        return null;
    }

    private boolean dropActivity(String name, int mx, int my) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        if (!this.checkDroppingName(name)) {
            DialogUtilities.showError(rm.getResource("message.error.0021"));
            return false;
        }
        Dimension psize = this.getPreferredSize();
        if (mx >= psize.width || my >= psize.height) {
            DialogUtilities.showError(rm.getResource("message.error.0022"));
            return false;
        }
        if (this.getActivity(mx, my) != null) {
            DialogUtilities.showError(rm.getResource("message.error.0023"));
            return false;
        }
        boolean result = this.addActivity(name, mx, my);
        this.repaint();
        return result;
    }

    private boolean addActivity(String name, int mx, int my) {
        if (name.equals("concurrent")) {
            return this.addConcurrenceActivity(name, mx, my);
        }
        return this.addGeneralActivity(name, mx, my);
    }

    private boolean addConcurrenceActivity(String name, int mx, int my) {
        ConcurrentLayer layer2;
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int mx2 = mx + 80;
        Dimension psize = this.getPreferredSize();
        if (mx2 >= psize.width || my >= psize.height) {
            DialogUtilities.showError(rm.getResource("message.error.0024"));
            return false;
        }
        if (this.getActivity(mx2, my) != null) {
            DialogUtilities.showError(rm.getResource("message.error.0025"));
            return false;
        }
        int x1 = mx / 80;
        int y1 = my / 80;
        int x2 = mx2 / 80;
        int y2 = my / 80;
        ConcurrentLayer layer1 = this.root.getReceivableLayer(x1, y1);
        if (layer1 != (layer2 = this.root.getReceivableLayer(x2, y2))) {
            DialogUtilities.showError(rm.getResource("message.error.0024"));
            return false;
        }
        ActivityState state1 = ActivityStateFactory.getInstance().createElement("CONCUR_START");
        ActivityState state2 = ActivityStateFactory.getInstance().createElement("CONCUR_END");
        if (state1 == null || state2 == null) {
            return false;
        }
        ActivityElementImpl act1 = new ActivityElementImpl(state1);
        ActivityElementImpl act2 = new ActivityElementImpl(state2);
        String blockID = IDGenerator.generate("BK");
        act1.setBlockID(blockID);
        act2.setBlockID(blockID);
        ConcurrentLayer newLayer = new ConcurrentLayer(layer1, act1, act2);
        if (layer1 == null) {
            this.root.addLayer(newLayer);
        } else {
            layer1.addLayer(newLayer);
        }
        act1.setLogicalX(x1);
        act1.setLogicalY(y1);
        act2.setLogicalX(x2);
        act2.setLogicalY(y2);
        this.proc.getActivities().add(act1);
        this.proc.getActivities().add(act2);
        return true;
    }

    private boolean addGeneralActivity(String name, int mx, int my) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        ActivityState state = ActivityStateFactory.getInstance().createElementByPalette(name);
        if (state == null) {
            return false;
        }
        int x = mx / 80;
        int y = my / 80;
        ConcurrentLayer layer = this.root.getReceivableLayer(x, y);
        ActivityElementImpl act = new ActivityElementImpl(state);
        act.setLogicalX(x);
        act.setLogicalY(y);
        if (layer != null) {
            layer.addLayerElement(act);
        }
        this.proc.getActivities().add(act);
        return true;
    }

    private void removeActivity(ActivityElement act) {
        if (act == null) {
            return;
        }
        List trs = this.proc.getTransitions();
        ArrayList<TransitionElement> tempTrs = new ArrayList<TransitionElement>();
        Iterator tit = trs.iterator();
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            if (tr.getSource() != act && tr.getDestination() != act) continue;
            tempTrs.add(tr);
        }
        Iterator tempit = tempTrs.iterator();
        while (tempit.hasNext()) {
            trs.remove((TransitionElement)tempit.next());
        }
        List acts = this.proc.getActivities();
        acts.remove(act);
        this.selectedActivity = null;
        this.inspectSelectedActivity(false);
        this.repaint();
    }

    private ActivityElement getStartActivity() {
        if (this.proc != null) {
            Iterator it = this.proc.getActivities().iterator();
            while (it.hasNext()) {
                ActivityElement act = (ActivityElement)it.next();
                if (!act.getType().equals("START")) continue;
                return act;
            }
        }
        return null;
    }

    private boolean checkDroppingName(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < WorkflowDesignerConstants.DROPPABLE_ITEMS.length; ++i) {
            if (!WorkflowDesignerConstants.DROPPABLE_ITEMS[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private void addTransition(ActivityElement src, ActivityElement dst) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        if (src == dst) {
            return;
        }
        if (dst.getType().equals("START")) {
            DialogUtilities.showError(rm.getResource("message.error.0032"));
            return;
        }
        List acts = this.proc.getActivities();
        Iterator it = acts.iterator();
        boolean existSrc = false;
        boolean existDst = false;
        while (it.hasNext()) {
            ActivityElement a = (ActivityElement)it.next();
            if (a == src) {
                existSrc = true;
                continue;
            }
            if (a != dst) continue;
            existDst = true;
        }
        if (!existSrc || !existDst) {
            DialogUtilities.showError(rm.getResource("message.error.0033"));
            return;
        }
        List trs = this.proc.getTransitions();
        Iterator tit = trs.iterator();
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            if (tr.getSource() != src || tr.getDestination() != dst) continue;
            DialogUtilities.showError(rm.getResource("message.error.0034"));
            return;
        }
        if (this.checkTransitionLayer(src, dst)) {
            TransitionElementImpl newTr = new TransitionElementImpl(src, dst);
            trs.add(newTr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkTransitionLayer(ActivityElement src, ActivityElement dst) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        ConcurrentLayer layer1 = this.root.getContainLayer(src);
        ConcurrentLayer layer2 = this.root.getContainLayer(dst);
        if (layer1 == null && layer2 == null) return true;
        if (layer1 == null) {
            if (dst.getType().equals("CONCUR_START")) {
                ConcurrentLayer pl = layer2.getParentLayer();
                if (pl == null) return true;
                DialogUtilities.showError(rm.getResource("message.error.0037"));
                return false;
            }
            DialogUtilities.showError(rm.getResource("message.error.0036"));
            return false;
        }
        if (layer2 == null) {
            if (src.getType().equals("CONCUR_END")) {
                ConcurrentLayer pl = layer1.getParentLayer();
                if (pl == null) return true;
                DialogUtilities.showError(rm.getResource("message.error.0037"));
                return false;
            }
            DialogUtilities.showError(rm.getResource("message.error.0036"));
            return false;
        }
        if (layer1 != layer2) {
            if (dst.getType().equals("CONCUR_START")) {
                ConcurrentLayer pl = layer2.getParentLayer();
                if (pl == layer1) return true;
                DialogUtilities.showError(rm.getResource("message.error.0037"));
                return false;
            }
            if (src.getType().equals("CONCUR_END")) {
                ConcurrentLayer pl = layer1.getParentLayer();
                if (pl == layer2) return true;
                DialogUtilities.showError(rm.getResource("message.error.0037"));
                return false;
            }
            DialogUtilities.showError(rm.getResource("message.error.0036"));
            return false;
        }
        if (dst.getType().equals("CONCUR_START")) {
            DialogUtilities.showError(rm.getResource("message.error.0038"));
            return false;
        }
        if (!src.getType().equals("CONCUR_END")) return true;
        DialogUtilities.showError(rm.getResource("message.error.0039"));
        return false;
    }

    private void removeTransition(ActivityElement src, ActivityElement dst) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        List trs = this.proc.getTransitions();
        Iterator tit = trs.iterator();
        TransitionElement rmTr = null;
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            if (tr.getSource() != src || tr.getDestination() != dst) continue;
            rmTr = tr;
            break;
        }
        if (rmTr == null) {
            DialogUtilities.showError(rm.getResource("message.error.0035"));
            return;
        }
        trs.remove(rmTr);
    }

    private boolean checkLocation(ConcurrentLayer l, ActivityElement elem, int lx, int ly) {
        if (l == null) {
            return true;
        }
        ActivityElement start = l.getStartElement();
        ActivityElement end = l.getEndElement();
        ConcurrentLayer parentLayer = l.getParentLayer();
        int sx = start.getLogicalX();
        int sy = start.getLogicalY();
        int ex = end.getLogicalX();
        int ey = end.getLogicalY();
        Point mup = l.getMinimumUpperPoint();
        Point mlp = l.getMinimumLowerPoint();
        if (lx == sx && ly == sy) {
            return false;
        }
        if (lx == ex && ly == ey) {
            return false;
        }
        if (elem == start) {
            if (parentLayer != null) {
                int psx = parentLayer.getStartElement().getLogicalX();
                int psy = parentLayer.getStartElement().getLogicalY();
                int pex = parentLayer.getEndElement().getLogicalX();
                int pey = parentLayer.getEndElement().getLogicalY();
                if (lx == psx && ly == psy) {
                    return false;
                }
                if (lx == pex && ly == pey) {
                    return false;
                }
                if (lx < psx || lx > ex) {
                    return false;
                }
                if (ly < psy || ly > ey) {
                    return false;
                }
            }
            if (lx > mup.x || ly > mup.y) {
                return false;
            }
        } else if (elem == end) {
            if (parentLayer != null) {
                int psx = parentLayer.getStartElement().getLogicalX();
                int psy = parentLayer.getStartElement().getLogicalY();
                int pex = parentLayer.getEndElement().getLogicalX();
                int pey = parentLayer.getEndElement().getLogicalY();
                if (lx == psx && ly == psy) {
                    return false;
                }
                if (lx == pex && ly == pey) {
                    return false;
                }
                if (lx < sx || lx > pex) {
                    return false;
                }
                if (ly < sy || ly > pey) {
                    return false;
                }
            }
            if (lx < mlp.x || ly < mlp.y) {
                return false;
            }
        } else {
            if (lx < sx || lx > ex) {
                return false;
            }
            if (ly < sy || ly > ey) {
                return false;
            }
        }
        return true;
    }

    private Dimension getMinimumViewSize() {
        int lw = 10;
        int lh = 10;
        if (this.proc != null) {
            Iterator it = this.proc.getActivities().iterator();
            while (it.hasNext()) {
                ActivityElement act = (ActivityElement)it.next();
                if (act.getLogicalX() >= lw) {
                    lw = act.getLogicalX() + 1;
                }
                if (act.getLogicalY() < lh) continue;
                lh = act.getLogicalY() + 1;
            }
        }
        return new Dimension(80 * lw + 1, 80 * lh + 1);
    }

    public int getControllerID() {
        return this.controllerID;
    }

    public void setControllerID(int i) {
        ActivityElement act;
        this.controllerID = i;
        this.setSelectedActivity(null);
        this.sourceActivity = null;
        this.selectedRect = null;
        this.setToolTipText(null);
        this.inspectSelectedActivity(false);
        this.simulatedActivities.clear();
        this.waitActivities.clear();
        if (this.getControllerID() == 2 && (act = this.getStartActivity()) != null) {
            this.simulatedActivities.add(new SimulatableActivityWrapper(act, null));
        }
        this.repaint();
    }

    public ActivityElement getSelectedActivity() {
        return this.selectedActivity;
    }

    public void setSelectedActivity(ActivityElement element) {
        WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
        this.selectedActivity = element;
        if (this.selectedActivity == null) {
            frame.setEnableCopyAction(false);
            frame.setEnableDeleteAction(false);
            return;
        }
        String type = this.selectedActivity.getType();
        if (type.equals("START")) {
            frame.setEnableCopyAction(false);
            frame.setEnableDeleteAction(false);
        } else if (type.equals("CONCUR_START") || type.equals("CONCUR_END") || type.equals("END")) {
            frame.setEnableCopyAction(false);
            frame.setEnableDeleteAction(true);
        } else {
            frame.setEnableCopyAction(true);
            frame.setEnableDeleteAction(true);
        }
    }

    public void inspectSelectedActivity(boolean withShowing) {
        DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
        ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
        if (frame == null) {
            return;
        }
        frame.setInspector(this.selectedActivity);
        if (withShowing) {
            frame.showInspector();
        }
    }

    public void notifyFrameIsActivated() {
        this.setSelectedActivity(this.selectedActivity);
    }

    public void notifyFrameIsDeactivated() {
        this.sourceActivity = null;
    }

    public void expandWidth() {
        Dimension d = this.getPreferredSize();
        int newWidth = d.width + 80;
        d.setSize(newWidth, d.height);
        this.setPreferredSize(d);
        this.setSize(d);
        this.proc.setLogicalWidth(newWidth / 80);
        this.updateUI();
    }

    public void expandHeight() {
        Dimension d = this.getPreferredSize();
        int newHeight = d.height + 80;
        d.setSize(d.width, newHeight);
        this.setPreferredSize(d);
        this.setSize(d);
        this.proc.setLogicalHeight(newHeight / 80);
        this.updateUI();
    }

    public void reduceWidth() {
        Dimension d = this.getPreferredSize();
        Dimension md = this.getMinimumViewSize();
        int newWidth = d.width - 80;
        if (newWidth >= md.width) {
            d.setSize(newWidth, d.height);
            this.setPreferredSize(d);
            this.setSize(d);
            this.proc.setLogicalWidth(newWidth / 80);
            this.updateUI();
        }
    }

    public void reduceHeight() {
        Dimension d = this.getPreferredSize();
        Dimension md = this.getMinimumViewSize();
        int newHeight = d.height - 80;
        if (newHeight >= md.height) {
            d.setSize(d.width, newHeight);
            this.setPreferredSize(d);
            this.setSize(d);
            this.proc.setLogicalHeight(newHeight / 80);
            this.updateUI();
        }
    }

    public void cut() {
        if (this.selectedActivity == null) {
            return;
        }
        WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
        if (!frame.getEnableCopyAction()) {
            return;
        }
        frame.setPastable(this.selectedActivity);
        this.delete();
        this.repaint();
    }

    public void copy() {
        if (this.selectedActivity == null) {
            return;
        }
        WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
        if (!frame.getEnableCopyAction()) {
            return;
        }
        ActivityElement pastable = this.selectedActivity.copy();
        frame.setPastable(pastable);
        this.repaint();
    }

    public void paste() {
        if (this.selectedRect == null) {
            return;
        }
        WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
        if (!frame.getEnablePasteAction()) {
            return;
        }
        Element pastable = frame.getPastable();
        if (pastable == null) {
            return;
        }
        if (pastable instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)pastable;
            int lx = this.selectedRect.x / 80;
            int ly = this.selectedRect.y / 80;
            act.setLogicalX(lx);
            act.setLogicalY(ly);
            this.proc.addActivity(act);
            this.setSelectedActivity(act);
            ConcurrentLayer layer = this.root.getReceivableLayer(lx, ly);
            if (layer != null) {
                layer.addLayerElement(act);
            }
            frame.setPastable(null);
        }
        this.repaint();
    }

    public void delete() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
        if (!frame.getEnableDeleteAction()) {
            return;
        }
        if (this.selectedActivity == null) {
            return;
        }
        String type = this.selectedActivity.getType();
        if (type.equals("CONCUR_START") || type.equals("CONCUR_END")) {
            int result = DialogUtilities.showOkCancelConfirm(rm.getResource("message.confirm.0001"));
            if (result != 0) {
                return;
            }
            ConcurrentLayer l = this.root.getContainLayer(this.selectedActivity);
            ArrayList temp = new ArrayList();
            l.collectAllLayerElement(temp);
            Iterator tit = temp.iterator();
            while (tit.hasNext()) {
                ActivityElement e = (ActivityElement)tit.next();
                this.removeActivity(e);
            }
            this.root.removeLayer(l);
        } else {
            this.root.removeLayerElement(this.selectedActivity);
        }
        this.removeActivity(this.selectedActivity);
        this.setSelectedActivity(null);
        this.repaint();
    }

    public void simulationStarted(SimulatableActivityWrapper act) {
        this.repaint();
    }

    public void simulationProgressed(SimulatableActivityWrapper sa, List trs) {
        if (trs == null) {
            return;
        }
        this.simulatedActivities.remove(sa);
        Iterator tit = trs.iterator();
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            ActivityElement act = tr.getDestination();
            boolean hasBlockElement = false;
            SimulatableActivityWrapper top = null;
            if (act.getType().equals("CONCUR_END")) {
                top = sa.peekTopBlockWrapper();
                hasBlockElement = this.checkHasBlockElement(top);
            }
            SimulatableActivityWrapper newSimact = new SimulatableActivityWrapper(act, tr, sa.getBlockStack());
            if (hasBlockElement) {
                this.waitActivities.put(newSimact, top);
            }
            this.simulatedActivities.add(newSimact);
        }
        this.repaint();
    }

    private boolean checkHasBlockElement(SimulatableActivityWrapper sa) {
        Iterator sait = this.simulatedActivities.iterator();
        while (sait.hasNext()) {
            SimulatableActivityWrapper w = (SimulatableActivityWrapper)sait.next();
            if (w.searchBlockWrapper(sa) <= -1) continue;
            return true;
        }
        return false;
    }

    private void removeBlock(SimulatableActivityWrapper bk, SimulatableActivityWrapper act) {
        Set wset = this.waitActivities.entrySet();
        Iterator wit = wset.iterator();
        while (wit.hasNext()) {
            Map.Entry entry = wit.next();
            if (entry.getValue() != bk) continue;
            this.waitActivities.remove(entry.getKey());
        }
        ArrayList<SimulatableActivityWrapper> temp = new ArrayList<SimulatableActivityWrapper>();
        Iterator sait = this.simulatedActivities.iterator();
        while (sait.hasNext()) {
            SimulatableActivityWrapper w = (SimulatableActivityWrapper)sait.next();
            if (w == act || w.getActivity() != act.getActivity()) continue;
            temp.add(w);
        }
        Iterator tempit = temp.iterator();
        while (tempit.hasNext()) {
            SimulatableActivityWrapper w = (SimulatableActivityWrapper)tempit.next();
            this.simulatedActivities.remove(w);
        }
    }

    public void simulationFinished(SimulatableActivityWrapper act) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        DialogUtilities.showInfo(rm.getResource("message.info.0001"));
        this.repaint();
    }

    public void simulationTerminated(SimulatableActivityWrapper act) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        DialogUtilities.showInfo(rm.getResource("message.info.0002"));
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.controllers[this.controllerID].mouseClicked(e);
    }

    public void mousePressed(MouseEvent e) {
        this.controllers[this.controllerID].mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.controllers[this.controllerID].mouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.controllers[this.controllerID].mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.controllers[this.controllerID].mouseExited(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.controllers[this.controllerID].mouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.controllers[this.controllerID].mouseMoved(e);
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent e) {
        this.dropRect = null;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent e) {
        try {
            DataFlavor[] flavors = e.getCurrentDataFlavors();
            if (flavors == null) {
                return;
            }
            if (flavors.length != 1) {
                return;
            }
            DataFlavor df = flavors[0];
            if (df == null) {
                return;
            }
            if (df.getPrimaryType().equals("x-workflowdesigner") && df.getSubType().equals("activity-item")) {
                Point location = e.getLocation();
                Dimension psize = this.getPreferredSize();
                if (location.x >= psize.width || location.y >= psize.height) {
                    this.dropRect = null;
                    this.repaint();
                    return;
                }
                int x = location.x / 80;
                int y = location.y / 80;
                if (this.dropRect == null) {
                    this.dropRect = new Rectangle(80, 80);
                }
                this.dropRect.x = x * 80;
                this.dropRect.y = y * 80;
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(3);
        try {
            DataFlavor df;
            DataFlavor[] flavors;
            boolean invalid = false;
            Transferable t = e.getTransferable();
            if (t == null) {
                invalid = true;
            }
            if ((flavors = t.getTransferDataFlavors()) == null) {
                invalid = true;
            }
            if (flavors.length != 1) {
                invalid = true;
            }
            if ((df = flavors[0]) == null) {
                invalid = true;
            }
            if (!df.getPrimaryType().equals("x-workflowdesigner") || !df.getSubType().equals("activity-item")) {
                invalid = true;
            }
            if (invalid) {
                e.dropComplete(false);
                return;
            }
            String s = df.getHumanPresentableName();
            Point location = e.getLocation();
            this.dropActivity(s, location.x, location.y);
            e.dropComplete(true);
        }
        catch (Exception ex) {
            e.dropComplete(false);
        }
        finally {
            this.dropRect = null;
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    static {
        ARROW_PATH.moveTo(0.0f, 0.0f);
        ARROW_PATH.lineTo(15.0f, 5.0f);
        ARROW_PATH.lineTo(15.0f, -5.0f);
        ARROW_PATH.closePath();
    }

    public class SimulationModeFlowViewController
    extends ProcessFlowViewController {
        public void mouseClicked(MouseEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            if (e.getClickCount() >= 2) {
                int my;
                int mx = e.getX();
                ActivityElement act = ProcessFlowView.this.getActivity(mx, my = e.getY());
                if (act == null) {
                    return;
                }
                SimulatableActivityWrapper simact = null;
                Iterator sait = ProcessFlowView.this.simulatedActivities.iterator();
                while (sait.hasNext()) {
                    SimulatableActivityWrapper sa = (SimulatableActivityWrapper)sait.next();
                    if (sa.getActivity() != act) continue;
                    simact = sa;
                    break;
                }
                if (simact != null) {
                    if (ProcessFlowView.this.waitActivities.containsKey(simact)) {
                        SimulatableActivityWrapper top = (SimulatableActivityWrapper)ProcessFlowView.this.waitActivities.get(simact);
                        if (ProcessFlowView.this.checkHasBlockElement(top)) {
                            DialogUtilities.showWarning(rm.getResource("message.warn.0201"));
                            return;
                        }
                        ProcessFlowView.this.removeBlock(top, simact);
                    }
                    PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
                    List vars = this.makeConditionalVariables(pkg.getVariables());
                    if (act == ProcessFlowView.this.getStartActivity()) {
                        ProcessFlowView.this.simulator.start(ProcessFlowView.this, vars, ProcessFlowView.this.proc, simact);
                    } else {
                        ProcessFlowView.this.simulator.simulate(simact);
                    }
                }
            }
        }

        private List makeConditionalVariables(List vars) {
            ArrayList<ConditionalVariable> result = new ArrayList<ConditionalVariable>();
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                VariableElement var = (VariableElement)it.next();
                ConditionalVariable cvar = new ConditionalVariable(var);
                result.add(cvar);
            }
            return result;
        }
    }

    public class ConnectionModeFlowViewController
    extends ProcessFlowViewController {
        public void mouseClicked(MouseEvent e) {
            if (ProcessFlowView.this.sourceActivity == null) {
                ProcessFlowView.this.sourceActivity = ProcessFlowView.this.getActivity(e.getX(), e.getY());
                if (ProcessFlowView.this.sourceActivity != null) {
                    if (ProcessFlowView.this.sourceActivity.getType().equals("END")) {
                        ProcessFlowView.this.sourceActivity = null;
                    } else if (e.isControlDown()) {
                        ProcessFlowView.this.setConnectingMode(1);
                    } else {
                        ProcessFlowView.this.setConnectingMode(0);
                    }
                }
            } else {
                ActivityElement dst = ProcessFlowView.this.getActivity(e.getX(), e.getY());
                if (dst != null) {
                    dst.getID();
                    if (ProcessFlowView.this.connectingMode == 1) {
                        ProcessFlowView.this.removeTransition(ProcessFlowView.this.sourceActivity, dst);
                    } else {
                        ProcessFlowView.this.addTransition(ProcessFlowView.this.sourceActivity, dst);
                    }
                }
                ProcessFlowView.this.sourceActivity = null;
            }
            ProcessFlowView.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            ProcessFlowView.this.cursorRect = null;
            ProcessFlowView.this.dropRect = null;
            ProcessFlowView.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            int mx = e.getX();
            int my = e.getY();
            Dimension psize = ProcessFlowView.this.getPreferredSize();
            if (mx >= psize.width || my >= psize.height) {
                ProcessFlowView.this.cursorRect = null;
                ProcessFlowView.this.repaint();
                return;
            }
            int lx = mx / 80;
            int ly = my / 80;
            if (ProcessFlowView.this.cursorRect == null) {
                ProcessFlowView.this.cursorRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.y = ly * 80;
            ProcessFlowView.this.repaint();
        }
    }

    public class PointerModeFlowViewController
    extends ProcessFlowViewController {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                ProcessFlowView.this.inspectSelectedActivity(true);
            }
        }

        public void mousePressed(MouseEvent e) {
            int mx = e.getX();
            int my = e.getY();
            int lx = mx / 80;
            int ly = my / 80;
            if (ProcessFlowView.this.selectedRect == null) {
                ProcessFlowView.this.selectedRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.y = ly * 80;
            ProcessFlowView.this.setSelectedActivity(ProcessFlowView.this.getActivity(mx, my));
        }

        public void mouseReleased(MouseEvent e) {
            int mx = e.getX();
            int my = e.getY();
            int lx = mx / 80;
            int ly = my / 80;
            if (ProcessFlowView.this.selectedRect == null) {
                ProcessFlowView.this.selectedRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.y = ly * 80;
            ProcessFlowView.this.inspectSelectedActivity(false);
            ProcessFlowView.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            ProcessFlowView.this.cursorRect = null;
            ProcessFlowView.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (ProcessFlowView.this.selectedActivity == null) {
                return;
            }
            int mx = e.getX();
            int my = e.getY();
            int ax = ProcessFlowView.this.selectedActivity.getLogicalX();
            int ay = ProcessFlowView.this.selectedActivity.getLogicalY();
            Dimension psize = ProcessFlowView.this.getPreferredSize();
            if (mx < 0) {
                mx = 0;
            }
            if (my < 0) {
                my = 0;
            }
            if (mx >= psize.width) {
                mx = psize.width - 80;
            }
            if (my >= psize.height) {
                my = psize.height - 80;
            }
            int lx = mx / 80;
            int ly = my / 80;
            ActivityElement elem = ProcessFlowView.this.getActivity(mx, my);
            if (elem != null) {
                return;
            }
            ConcurrentLayer layer = ProcessFlowView.this.root.getContainLayer(ProcessFlowView.this.selectedActivity);
            if (!ProcessFlowView.this.checkLocation(layer, ProcessFlowView.this.selectedActivity, lx, ly)) {
                return;
            }
            if (ax != lx) {
                ProcessFlowView.this.selectedActivity.setLogicalX(lx);
            }
            if (ay != ly) {
                ProcessFlowView.this.selectedActivity.setLogicalY(ly);
            }
            if (ProcessFlowView.this.selectedRect == null) {
                ProcessFlowView.this.selectedRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).selectedRect.y = ly * 80;
            if (ProcessFlowView.this.cursorRect == null) {
                ProcessFlowView.this.cursorRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.y = ly * 80;
            ProcessFlowView.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            int mx = e.getX();
            int my = e.getY();
            Dimension psize = ProcessFlowView.this.getPreferredSize();
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            ActivityElement elem = ProcessFlowView.this.getActivity(mx, my);
            if (elem == null) {
                ProcessFlowView.this.setToolTipText(null);
            } else {
                ProcessFlowView.this.setToolTipText(elem.getTooltipText(rm));
            }
            if (mx >= psize.width || my >= psize.height) {
                ProcessFlowView.this.cursorRect = null;
                ProcessFlowView.this.repaint();
                return;
            }
            int lx = mx / 80;
            int ly = my / 80;
            if (ProcessFlowView.this.cursorRect == null) {
                ProcessFlowView.this.cursorRect = new Rectangle(80, 80);
            }
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.x = lx * 80;
            ((ProcessFlowView)ProcessFlowView.this).cursorRect.y = ly * 80;
            ProcessFlowView.this.repaint();
        }
    }

    class ProcessFlowViewController
    extends MouseAdapter
    implements MouseMotionListener {
        ProcessFlowViewController() {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

