/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Frame;
import javax.swing.ActionMap;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.swing.HelpViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.FileManager;
import jp.co.argo21.nautica.tool.wfd.VersionWindow;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerFrame;
import jp.co.argo21.nautica.tool.wfd.action.CopyActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.CutActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.DeleteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfd.action.ExitAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.HelpAction;
import jp.co.argo21.nautica.tool.wfd.action.NewPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.OpenPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.PasteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfd.action.PrintAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.SavePackageAction;
import jp.co.argo21.nautica.tool.wfd.action.SaveToPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.VersionAction;

public class WorkflowDesignerManager {
    private static final String BUNDLE_PATH = "jp.co.argo21.nautica.tool.wfd.resources.messages";
    private static ResourceManager resourceManager;
    private static WorkflowDesignerFrame mainFrame;
    private static ExceptionViewer exceptionViewer;
    private static VersionWindow versionWindow;
    private static HelpViewer helpViewer;
    private static ActionMap actionMap;
    private static FileManager fileManager;

    public static void boot() throws Exception {
        resourceManager = new ResourceManager(BUNDLE_PATH);
        WorkflowDesignerManager.crerateActionMap();
        fileManager = new FileManager();
        versionWindow = new VersionWindow();
        versionWindow.setVisible(true);
        mainFrame = new WorkflowDesignerFrame();
        exceptionViewer = new ExceptionViewer((Frame)mainFrame, false);
        helpViewer = new HelpViewer();
        mainFrame.newPackage();
        mainFrame.setVisible(true);
        versionWindow.setVisible(false);
    }

    public static ResourceManager getResourceManager() {
        return resourceManager;
    }

    public static void setException(Exception ex) {
        exceptionViewer.setThrowable(ex);
    }

    public static ExceptionViewer getExceptionViewer() {
        return exceptionViewer;
    }

    public static HelpViewer getHelpViewer() {
        return helpViewer;
    }

    public static WorkflowDesignerFrame getMainFrame() {
        return mainFrame;
    }

    public static VersionWindow getVersionWindow() {
        return versionWindow;
    }

    public static ActionMap getActionMap() {
        return actionMap;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    private static void crerateActionMap() {
        actionMap = new ActionMap();
        actionMap.put("newPackage", new NewPackageAction());
        actionMap.put("openPackage", new OpenPackageAction());
        actionMap.put("savePackage", new SavePackageAction());
        actionMap.put("saveToPackage", new SaveToPackageAction());
        actionMap.put("printPackage", new PrintAction());
        actionMap.put("exit", new ExitAction());
        actionMap.put("cutActivity", new CutActivityAction());
        actionMap.put("copyActivity", new CopyActivityAction());
        actionMap.put("pasteActivity", new PasteActivityAction());
        actionMap.put("deleteActivity", new DeleteActivityAction());
        actionMap.put("exceptionViewer", new ExceptionViewerAction());
        actionMap.put("preferences", new PreferencesAction());
        actionMap.put("help", new HelpAction());
        actionMap.put("about", new VersionAction());
        actionMap.put("reduceWidth", new ReduceFlowViewWidthAction());
        actionMap.put("reduceHeight", new ReduceFlowViewHeightAction());
        actionMap.put("expandWidth", new ExpandFlowViewWidthAction());
        actionMap.put("expandHeight", new ExpandFlowViewHeightAction());
    }
}

