/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.ActivityStateFactory;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.impl.AutomaticActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.InteractiveActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.SubprocessActivityState;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ActualParametersDocument;
import org.wfmc.x2002.xpdl10.BlockActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.ImplementationDocument;
import org.wfmc.x2002.xpdl10.SubFlowDocument;
import org.wfmc.x2002.xpdl10.ToolDocument;

public class ActivityElementImpl
implements ActivityElement {
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private int limit;
    private int logicalX;
    private int logicalY;
    private String blockID;
    private String affiliateBID;
    private String parentBID;
    private String applicationID;
    private String subprocessID;
    private String performerID;
    private int sync;
    private List applicationParameters = new ArrayList();
    private List subprocessParameters = new ArrayList();
    private String engineName;
    private ActivityState state;

    public ActivityElementImpl(ActivityState state) {
        this.setID(IDGenerator.generate("AC"));
        this.setName(this.getID());
        this.setDescription("");
        this.setLimit(0);
        this.setLogicalX(0);
        this.setLogicalY(0);
        this.setExecution(2);
        this.setActivityState(state);
    }

    public ActivityElementImpl(ActivityDocument.Activity act) {
        String id = act.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("AC"));
        } else {
            this.setID(id);
        }
        this.setName(act.getName());
        this.setDescription(act.getDescription());
        try {
            this.setLimit(Integer.parseInt(act.getLimit()));
        }
        catch (Exception ex) {
            this.setLimit(0);
        }
        if (act.isSetBlockActivity()) {
            BlockActivityDocument.BlockActivity ba = act.getBlockActivity();
            this.setBlockID(ba.getBlockId());
        }
        if (act.isSetPerformer()) {
            this.setPerformerID(act.getPerformer());
        }
        if (act.isSetImplementation()) {
            int i;
            int count;
            ActualParametersDocument.ActualParameters aps;
            ImplementationDocument.Implementation imp = act.getImplementation();
            if (imp.isSetSubFlow()) {
                SubFlowDocument.SubFlow sf = imp.getSubFlow();
                this.setSubprocessID(sf.getId());
                this.setExecution(sf.getExecution().intValue());
                if (sf.isSetActualParameters()) {
                    aps = sf.getActualParameters();
                    count = aps.sizeOfActualParameterArray();
                    for (i = 0; i < count; ++i) {
                        String pid = aps.getActualParameterArray(i);
                        this.addSubprocessParameterID(pid);
                    }
                }
            }
            if (imp.sizeOfToolArray() == 1) {
                ToolDocument.Tool tool = imp.getToolArray(0);
                this.setApplicationID(tool.getId());
                if (tool.isSetActualParameters()) {
                    aps = tool.getActualParameters();
                    count = aps.sizeOfActualParameterArray();
                    for (i = 0; i < count; ++i) {
                        String aid = aps.getActualParameterArray(i);
                        this.addApplicationParameterID(aid);
                    }
                }
            }
        }
        if (act.isSetExtendedAttributes()) {
            ExtendedAttributesDocument.ExtendedAttributes eas = act.getExtendedAttributes();
            int count = eas.sizeOfExtendedAttributeArray();
            for (int i = 0; i < count; ++i) {
                ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
                String n = ea.getName();
                String v = ea.getValue();
                if (n.equals("LOGICAL_X")) {
                    this.setLogicalX(Integer.parseInt(v));
                    continue;
                }
                if (n.equals("LOGICAL_Y")) {
                    this.setLogicalY(Integer.parseInt(v));
                    continue;
                }
                if (n.equals("AFFILIATE_BID")) {
                    this.setAffiliateBID(v);
                    continue;
                }
                if (n.equals("PARENT_BID")) {
                    this.setParentBID(v);
                    continue;
                }
                if (n.equals("ACTIVITY_TYPE")) {
                    ActivityStateFactory factory = ActivityStateFactory.getInstance();
                    this.state = factory.createElement(v);
                    continue;
                }
                if (!n.equals("ENGINE_NANE")) continue;
                this.setEngineName(v);
            }
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setActivityState(ActivityState state) {
        this.state = state;
    }

    public ActivityState getActivityState() {
        return this.state;
    }

    public String getBlockID() {
        return this.blockID;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getLogicalX() {
        return this.logicalX;
    }

    public int getLogicalY() {
        return this.logicalY;
    }

    public String getType() {
        return this.state.getType();
    }

    public void setBlockID(String id) {
        this.blockID = id;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setLogicalX(int x) {
        this.logicalX = x;
    }

    public void setLogicalY(int y) {
        this.logicalY = y;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addApplicationParameterID(String id) {
        this.applicationParameters.add(id);
    }

    public void addSubprocessParameterID(String id) {
        this.subprocessParameters.add(id);
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public List getApplicationParameters() {
        return this.applicationParameters;
    }

    public String getSubprocessID() {
        return this.subprocessID;
    }

    public List getSubprocessParameters() {
        return this.subprocessParameters;
    }

    public void removeApplicationParameterID(String id) {
        this.applicationParameters.remove(id);
    }

    public void removeSubprocessParameterID(String id) {
        this.subprocessParameters.remove(id);
    }

    public void setApplicationID(String id) {
        this.applicationID = id;
    }

    public void setSubprocessID(String id) {
        this.subprocessID = id;
    }

    public int getExecution() {
        return this.sync;
    }

    public void setExecution(int sync) {
        this.sync = sync;
    }

    public ActivityElement copy() {
        ActivityElementImpl copy = new ActivityElementImpl(this.getActivityState());
        copy.setName(this.getName());
        copy.setDescription(this.getDescription());
        copy.setLimit(this.getLimit());
        copy.setLogicalX(this.getLogicalX());
        copy.setLogicalY(this.getLogicalY());
        copy.setExecution(this.getExecution());
        return copy;
    }

    public String getAffiliateBID() {
        return this.affiliateBID;
    }

    public String getParentBID() {
        return this.parentBID;
    }

    public void setAffiliateBID(String id) {
        this.affiliateBID = id;
    }

    public void setParentBID(String id) {
        this.parentBID = id;
    }

    public String getPerformerID() {
        return this.performerID;
    }

    public void setPerformerID(String id) {
        this.performerID = id;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ActivityElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ActivityElement.label.4")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        block9: {
            ActivityState as;
            String eid;
            block10: {
                block8: {
                    if (elem == null) {
                        return false;
                    }
                    eid = elem.getID();
                    as = this.getActivityState();
                    if (!(as instanceof InteractiveActivityState)) break block8;
                    if (this.performerID != null && this.performerID.equals(eid)) {
                        return true;
                    }
                    break block9;
                }
                if (!(as instanceof AutomaticActivityState)) break block10;
                if (this.performerID != null && this.performerID.equals(eid)) {
                    return true;
                }
                if (this.applicationID == null) break block9;
                if (this.applicationID.equals(eid)) {
                    return true;
                }
                Iterator tit = this.applicationParameters.iterator();
                while (tit.hasNext()) {
                    String id = (String)tit.next();
                    if (id == null || !id.equals(eid)) continue;
                    return true;
                }
                break block9;
            }
            if (as instanceof SubprocessActivityState && this.subprocessID != null) {
                if (this.subprocessID.equals(eid)) {
                    return true;
                }
                Iterator tit = this.subprocessParameters.iterator();
                while (tit.hasNext()) {
                    String id = (String)tit.next();
                    if (id == null || !id.equals(eid)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

