/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParameterElementImpl;
import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;

public class ApplicationElementImpl
implements ApplicationElement {
    private String id;
    private String name;
    private String description;
    private List parameters = new ArrayList();

    public ApplicationElementImpl(String n) {
        this.setID(IDGenerator.generate("AP"));
        this.setName(n);
        this.setDescription("");
    }

    public ApplicationElementImpl(ApplicationDocument.Application app) {
        String id = app.getId();
        if (StringUtils.checkNull(id)) {
            this.setID(IDGenerator.generate("AP"));
        } else {
            this.setID(id);
        }
        this.setName(app.getName());
        this.setDescription(app.getDescription());
        if (app.isSetFormalParameters()) {
            FormalParametersDocument.FormalParameters pms = app.getFormalParameters();
            int count = pms.sizeOfFormalParameterArray();
            for (int i = 0; i < count; ++i) {
                FormalParameterDocument.FormalParameter pm = pms.getFormalParameterArray(i);
                ParameterElementImpl e = new ParameterElementImpl(pm);
                this.addParameter(e);
            }
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    public void addParameter(ParameterElement param) {
        this.parameters.add(param);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void removeParameter(ParameterElement param) {
        this.parameters.remove(param);
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ApplicationElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ApplicationElement.label.2")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        return false;
    }
}

