/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.ActivityElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParameterElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.StartActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.TransitionElementImpl;
import org.wfmc.x2002.xpdl10.ActivitiesDocument;
import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;
import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.ResponsiblesDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;
import org.wfmc.x2002.xpdl10.TransitionsDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

public class ProcessElementImpl
implements ProcessElement {
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private int durationUnit;
    private int limit;
    private int accessLevel;
    private int logicalWidth;
    private int logicalHeight;
    private List responsibles = new ArrayList();
    private List parameters = new ArrayList();
    private List activities = new ArrayList();
    private List transitions = new ArrayList();

    public ProcessElementImpl(String n) {
        this.setID(IDGenerator.generate("PS"));
        this.setName(this.getID());
        this.setDescription("");
        this.setDurationUnit(3);
        this.setLimit(0);
        this.setAccessLevel(2);
        this.setLogicalWidth(10);
        this.setLogicalHeight(10);
        StartActivityState state = new StartActivityState();
        ActivityElementImpl act = new ActivityElementImpl(state);
        act.setName("Start");
        this.getActivities().add(act);
    }

    public ProcessElementImpl(WorkflowProcessDocument.WorkflowProcess proc) {
        Element e;
        int i;
        RedefinableHeaderDocument.RedefinableHeader rhd;
        String id = proc.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("PS"));
        } else {
            this.setID(id);
        }
        this.setName(proc.getName());
        ProcessHeaderDocument.ProcessHeader ph = proc.getProcessHeader();
        this.setDescription(ph.getDescription());
        this.setDurationUnit(ph.getDurationUnit().intValue());
        try {
            this.setLimit(Integer.parseInt(ph.getLimit()));
        }
        catch (Exception ex) {
            this.setLimit(0);
        }
        this.setAccessLevel(proc.getAccessLevel().intValue());
        if (proc.isSetRedefinableHeader() && (rhd = proc.getRedefinableHeader()).isSetResponsibles()) {
            ResponsiblesDocument.Responsibles rsps = rhd.getResponsibles();
            int count = rsps.sizeOfResponsibleArray();
            for (int i2 = 0; i2 < count; ++i2) {
                String rsp = rsps.getResponsibleArray(i2);
                this.addResponsible(rsp);
            }
        }
        if (proc.isSetExtendedAttributes()) {
            ExtendedAttributesDocument.ExtendedAttributes eas = proc.getExtendedAttributes();
            int count = eas.sizeOfExtendedAttributeArray();
            for (i = 0; i < count; ++i) {
                ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
                String n = ea.getName();
                String v = ea.getValue();
                if (n.equals("LOGICAL_WIDTH")) {
                    this.setLogicalWidth(Integer.parseInt(v));
                    continue;
                }
                if (!n.equals("LOGICAL_HEIGHT")) continue;
                this.setLogicalHeight(Integer.parseInt(v));
            }
        }
        if (proc.isSetFormalParameters()) {
            FormalParametersDocument.FormalParameters pms = proc.getFormalParameters();
            int count = pms.sizeOfFormalParameterArray();
            for (i = 0; i < count; ++i) {
                FormalParameterDocument.FormalParameter pm = pms.getFormalParameterArray(i);
                e = new ParameterElementImpl(pm);
                this.addParameter((ParameterElement)e);
            }
        }
        if (proc.isSetActivities()) {
            ActivitiesDocument.Activities acts = proc.getActivities();
            int count = acts.sizeOfActivityArray();
            for (i = 0; i < count; ++i) {
                ActivityDocument.Activity act = acts.getActivityArray(i);
                e = new ActivityElementImpl(act);
                this.addActivity((ActivityElement)e);
            }
        }
        if (proc.isSetTransitions()) {
            TransitionsDocument.Transitions trs = proc.getTransitions();
            int count = trs.sizeOfTransitionArray();
            for (i = 0; i < count; ++i) {
                TransitionDocument.Transition tr = trs.getTransitionArray(i);
                e = new TransitionElementImpl(tr, this.getActivities());
                this.addTransition((TransitionElement)e);
            }
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setAccessLevel(int i) {
        this.accessLevel = i;
    }

    public void addActivity(ActivityElement act) {
        this.activities.add(act);
    }

    public void addParameter(ParameterElement param) {
        this.parameters.add(param);
    }

    public void addResponsible(String r) {
        this.responsibles.add(r);
    }

    public void addTransition(TransitionElement tr) {
        this.transitions.add(tr);
    }

    public void removeActivity(ActivityElement act) {
        this.activities.remove(act);
    }

    public void removeParameter(ParameterElement param) {
        this.parameters.remove(param);
    }

    public void removeResponsible(String r) {
        this.responsibles.remove(r);
    }

    public void removeTransition(TransitionElement tr) {
        this.transitions.remove(tr);
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getActivities() {
        return this.activities;
    }

    public int getDurationUnit() {
        return this.durationUnit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public int getLogicalWidth() {
        return this.logicalWidth;
    }

    public List getParameters() {
        return this.parameters;
    }

    public List getTransitions() {
        return this.transitions;
    }

    public void setDurationUnit(int i) {
        this.durationUnit = i;
    }

    public void setLimit(int i) {
        this.limit = i;
    }

    public void setLogicalHeight(int i) {
        this.logicalHeight = i;
    }

    public void setLogicalWidth(int i) {
        this.logicalWidth = i;
    }

    public List getResponsibles() {
        return this.responsibles;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ProcessElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ProcessElement.label.3")).append("</td><td width=150>");
        int a = this.getAccessLevel();
        s = a == 1 ? s.append(rm.getResource("ProcessElement.access.0")) : s.append(rm.getResource("ProcessElement.access.1"));
        s = s.append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ProcessElement.label.2")).append("</td><td width=150>").append(this.getLimit()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ProcessElement.label.6")).append("</td><td width=150>");
        int u = this.getDurationUnit();
        s = u == 1 ? s.append(rm.getResource("ProcessElement.unit.0")) : (u == 2 ? s.append(rm.getResource("ProcessElement.unit.1")) : (u == 3 ? s.append(rm.getResource("ProcessElement.unit.2")) : (u == 4 ? s.append(rm.getResource("ProcessElement.unit.3")) : (u == 5 ? s.append(rm.getResource("ProcessElement.unit.4")) : s.append(rm.getResource("ProcessElement.unit.2"))))));
        s = s.append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("ProcessElement.label.4")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        if (elem == null) {
            return false;
        }
        Iterator ait = this.activities.iterator();
        while (ait.hasNext()) {
            Element e = (Element)ait.next();
            boolean isUsed = e.isUsed(elem);
            if (!isUsed) continue;
            return true;
        }
        Iterator tit = this.activities.iterator();
        while (tit.hasNext()) {
            Element e = (Element)tit.next();
            boolean isUsed = e.isUsed(elem);
            if (!isUsed) continue;
            return true;
        }
        return false;
    }
}

