/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;

public class VariableElementImpl
implements VariableElement {
    private String id;
    private String name;
    private String description;
    private int type;
    private String initialValue;
    private boolean isInitialized;

    public VariableElementImpl(String n) {
        this.setID(IDGenerator.generate("VR"));
        this.setName(n);
        this.setDescription("");
        this.setType(1);
        this.setInitialValue("");
        this.isInitialized = false;
    }

    public VariableElementImpl(DataFieldDocument.DataField df) {
        String id = df.getId();
        if (StringUtils.checkNull(id)) {
            this.setID(IDGenerator.generate("VR"));
        } else {
            this.setID(id);
        }
        this.setName(df.getName());
        this.setDescription(df.getDescription());
        this.setInitialValue(df.getInitialValue());
        DataTypeDocument.DataType t = df.getDataType();
        if (t != null && t.isSetBasicType()) {
            BasicTypeDocument.BasicType bt = t.getBasicType();
            BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
            this.setType(type.intValue());
            this.isInitialized = true;
        } else {
            this.setType(1);
            this.isInitialized = false;
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public int getType() {
        return this.type;
    }

    public void setInitialValue(String v) {
        this.initialValue = v;
    }

    public void setType(int i) {
        this.type = i;
        this.isInitialized = true;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("VariableElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("VariableElement.label.7")).append("</td><td width=150>");
        int t = this.getType();
        s = t == 1 ? s.append(rm.getResource("VariableElement.label.3")) : (t == 3 ? s.append(rm.getResource("VariableElement.label.4")) : (t == 6 ? s.append(rm.getResource("VariableElement.label.5")) : s.append(rm.getResource("VariableElement.label.3"))));
        s = s.append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("VariableElement.label.6")).append("</td><td width=150>").append(this.getInitialValue()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("VariableElement.label.2")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        return false;
    }
}

