/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ElementReceivableView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;
import jp.co.argo21.nautica.tool.wfd.inspector.MappedParam;
import jp.co.argo21.nautica.tool.wfd.inspector.ParamMappingTableModel;
import jp.co.argo21.nautica.tool.wfd.inspector.ProcessInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.TransitionalActivityInspector;

public class AutomaticActivityInspector
extends TransitionalActivityInspector {
    private JTextField limitField;
    private JLabel unitField;
    private ElementReceivableView performerIconField;
    private JLabel performerIDField;
    private JLabel performerNameField;
    private ElementReceivableView appIconField;
    private JLabel appIDField;
    private JLabel appNameField;
    private JTable paramTable;
    private ElementReceivableView varIconField;
    private JButton unbindButton;
    private ParamMappingTableModel paramModel;
    private ChangeProcessElementAction changeProcAction;
    private ChangeParticipantElementAction changeParticipantAction;
    private ChangeApplicationElementAction changeAppAction;
    private ChangeVariableElementAction changeVarAction;
    private ParticipantElement performer;
    private ApplicationElement app;

    public AutomaticActivityInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.changeProcAction = new ChangeProcessElementAction();
        this.changeParticipantAction = new ChangeParticipantElementAction();
        this.changeAppAction = new ChangeApplicationElementAction();
        this.changeVarAction = new ChangeVariableElementAction();
        JPanel panel1 = this.createAutomaticInfoPanel(rm);
        this.addTab(rm.getResource("AutomaticActivityInspector.tab.0"), panel1);
        JPanel panel2 = this.createAppInfoPanel(rm);
        this.addTab(rm.getResource("AutomaticActivityInspector.tab.1"), panel2);
        this.validate();
    }

    private JPanel createAutomaticInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension size = new Dimension(380, 140);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("AutomaticActivityInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("AutomaticActivityInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("AutomaticActivityInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("AutomaticActivityInspector.label.3"));
        this.limitField = new JTextField();
        this.limitField.setHorizontalAlignment(4);
        this.limitField.setDocument(new NumericDocument(3, true, true));
        this.unitField = new JLabel();
        this.performerIconField = new ElementReceivableView("participant");
        this.performerIconField.addChangeElementListener(this.changeParticipantAction);
        this.performerIDField = new JLabel();
        this.performerIDField.setBorder(border);
        this.performerNameField = new JLabel();
        this.performerNameField.setBorder(border);
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(this.limitField, 110, 10, 70, 25));
        panel.add(this.locate(this.unitField, 180, 10, 70, 25));
        panel.add(this.locate(l1, 10, 40, 100, 25));
        panel.add(this.locate(this.performerIconField, 10, 70, 60, 60));
        panel.add(this.locate(l2, 80, 72, 100, 25));
        panel.add(this.locate(l3, 80, 102, 100, 25));
        panel.add(this.locate(this.performerIDField, 180, 72, 190, 25));
        panel.add(this.locate(this.performerNameField, 180, 102, 190, 25));
        this.validate();
        return panel;
    }

    private JPanel createAppInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension size = new Dimension(380, 270);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("AutomaticActivityInspector.label.4"));
        JLabel l1 = new JLabel(rm.getResource("AutomaticActivityInspector.label.5"));
        JLabel l2 = new JLabel(rm.getResource("AutomaticActivityInspector.label.6"));
        JLabel l3 = new JLabel(rm.getResource("AutomaticActivityInspector.label.7"));
        this.appIconField = new ElementReceivableView("application");
        this.appIconField.addChangeElementListener(this.changeAppAction);
        this.appIDField = new JLabel();
        this.appIDField.setBorder(border);
        this.appNameField = new JLabel();
        this.appNameField.setBorder(border);
        this.paramModel = new ParamMappingTableModel();
        this.paramTable = new JTable(this.paramModel);
        this.paramTable.setSelectionMode(0);
        ListSelectionModel selectModel = this.paramTable.getSelectionModel();
        selectModel.addListSelectionListener(new SelectParamTableAction());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.paramTable);
        this.varIconField = new ElementReceivableView("variable");
        this.varIconField.addChangeElementListener(this.changeVarAction);
        this.unbindButton = new JButton(rm.getResource("JButton.label.unbind"));
        this.unbindButton.addActionListener(new UnbindParamAction());
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(this.appIconField, 10, 40, 60, 60));
        panel.add(this.locate(l1, 80, 42, 100, 25));
        panel.add(this.locate(l2, 80, 72, 100, 25));
        panel.add(this.locate(this.appIDField, 180, 42, 190, 25));
        panel.add(this.locate(this.appNameField, 180, 72, 190, 25));
        panel.add(this.locate(l3, 10, 100, 250, 25));
        panel.add(this.locate(sp, 10, 130, 270, 160));
        panel.add(this.locate(this.varIconField, 300, 130, 60, 60));
        panel.add(this.locate(this.unbindButton, 290, 200, 80, 25));
        this.validate();
        return panel;
    }

    public void commit() {
        super.commit();
        Element e = this.getInspectable();
        if (e != null && e instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)e;
            try {
                int limit = Integer.parseInt(this.limitField.getText());
                act.setLimit(limit);
            }
            catch (Exception ex) {
                act.setLimit(0);
            }
            if (this.performer != null) {
                act.setPerformerID(this.performer.getID());
            } else {
                act.setPerformerID(null);
            }
            if (this.app != null) {
                act.setApplicationID(this.app.getID());
                act.getApplicationParameters().clear();
                Iterator pit = this.paramModel.getAllMappedParams().iterator();
                while (pit.hasNext()) {
                    MappedParam mp = (MappedParam)pit.next();
                    VariableElement v = mp.getActualParam();
                    if (v == null) {
                        act.addApplicationParameterID("");
                        continue;
                    }
                    act.addApplicationParameterID(v.getID());
                }
            } else {
                act.setApplicationID(null);
                act.getApplicationParameters().clear();
            }
        }
    }

    public final void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ActivityElement) {
            String aid;
            PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
            this.updateDurationUnit(null);
            ActivityElement act = (ActivityElement)elem;
            this.limitField.setText("" + act.getLimit());
            String pfid = act.getPerformerID();
            if (!StringUtils.checkNull(pfid)) {
                Iterator it = pkg.getParticipants().iterator();
                while (it.hasNext()) {
                    ParticipantElement e = (ParticipantElement)it.next();
                    if (!pfid.equals(e.getID())) continue;
                    this.performer = e;
                    break;
                }
                this.performerIconField.setElement(this.performer);
                this.updatePerformerInfo();
            }
            if (!StringUtils.checkNull(aid = act.getApplicationID())) {
                Iterator it = pkg.getApplications().iterator();
                while (it.hasNext()) {
                    ApplicationElement e = (ApplicationElement)it.next();
                    if (!aid.equals(e.getID())) continue;
                    this.app = e;
                    break;
                }
                this.appIconField.setElement(this.app);
                this.updateApplicationInfo();
                if (this.app != null) {
                    List params = act.getApplicationParameters();
                    block2: for (int i = 0; i < params.size(); ++i) {
                        String vid = (String)params.get(i);
                        if (StringUtils.checkNull(vid)) continue;
                        Iterator vit = pkg.getVariables().iterator();
                        while (vit.hasNext()) {
                            VariableElement e = (VariableElement)vit.next();
                            if (!vid.equals(e.getID())) continue;
                            this.paramModel.updateMapping(i, e);
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    public void init() {
        super.init();
        this.limitField.setText("0");
        this.unitField.setText("");
        this.performerIDField.setText("");
        this.performerNameField.setText("");
        this.appIDField.setText("");
        this.appNameField.setText("");
        this.performerIconField.setElement(null);
        this.appIconField.setElement(null);
        this.varIconField.setElement(null);
        this.paramModel.clearAllParams();
        this.performer = null;
        this.app = null;
        InspectorDialog.addChangeElementListener("process", this.changeProcAction);
        InspectorDialog.addChangeElementListener("participant", this.changeParticipantAction);
        InspectorDialog.addChangeElementListener("application", this.changeAppAction);
        InspectorDialog.addChangeElementListener("variable", this.changeVarAction);
    }

    public void unload() {
        InspectorDialog.removeChangeElementListener("process", this.changeProcAction);
        InspectorDialog.removeChangeElementListener("participant", this.changeParticipantAction);
        InspectorDialog.removeChangeElementListener("application", this.changeAppAction);
        InspectorDialog.removeChangeElementListener("variable", this.changeVarAction);
    }

    private void updatePerformerInfo() {
        if (this.performer != null) {
            this.performerIDField.setText(this.performer.getID());
            this.performerNameField.setText(this.performer.getName());
        }
    }

    private void updateApplicationInfo() {
        if (this.app != null) {
            this.appIDField.setText(this.app.getID());
            this.appNameField.setText(this.app.getName());
            this.paramModel.initParams(this.app.getParameters());
        }
    }

    private void updateVariableInfo() {
        this.paramModel.fireTableDataChanged();
    }

    private void updateVariableInfo(VariableElement var) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
            this.varIconField.setElement(null);
            return;
        }
        if (var != null) {
            int aptype;
            if (!var.isInitialized()) {
                DialogUtilities.showError(rm.getResource("message.error.0028"));
                this.varIconField.setElement(null);
                return;
            }
            MappedParam mp = this.paramModel.getMappedParam(selected);
            int ptype = mp.getParam().getType();
            if (ptype != (aptype = var.getType())) {
                DialogUtilities.showError(rm.getResource("message.error.0029"));
                this.varIconField.setElement(null);
                return;
            }
            this.paramModel.updateMapping(selected, var);
        }
        this.paramModel.fireTableDataChanged();
        this.varIconField.setElement(null);
    }

    private void unbindSelectedMapping() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
            this.varIconField.setElement(null);
            return;
        }
        this.paramModel.removeMapping(selected);
        this.varIconField.setElement(null);
    }

    private void showVariableIcon() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        MappedParam mp = this.paramModel.getMappedParam(selected);
        if (mp != null) {
            this.varIconField.setElement(mp.getActualParam());
        }
    }

    private void updateDurationUnit(ProcessElement p) {
        int u;
        ProcessElement proc = p;
        if (proc == null) {
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
            if (frame == null) {
                return;
            }
            proc = frame.getProcess();
        }
        if ((u = proc.getDurationUnit()) == 1) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[0]);
        } else if (u == 2) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[1]);
        } else if (u == 3) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        } else if (u == 4) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[3]);
        } else if (u == 5) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[4]);
        } else if (u == 6) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[5]);
        } else {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        }
    }

    class ChangeVariableElementAction
    implements ChangeElementListener {
        ChangeVariableElementAction() {
        }

        public void elementChanged(Element elem) {
            AutomaticActivityInspector.this.updateVariableInfo();
        }

        public void elementDropped(Element elem) {
            if (elem instanceof VariableElement) {
                AutomaticActivityInspector.this.updateVariableInfo((VariableElement)elem);
            }
        }
    }

    class ChangeApplicationElementAction
    implements ChangeElementListener {
        ChangeApplicationElementAction() {
        }

        public void elementChanged(Element elem) {
            AutomaticActivityInspector.this.updateApplicationInfo();
        }

        public void elementDropped(Element elem) {
            if (elem instanceof ApplicationElement) {
                AutomaticActivityInspector.this.app = (ApplicationElement)elem;
                AutomaticActivityInspector.this.updateApplicationInfo();
            }
        }
    }

    class ChangeParticipantElementAction
    implements ChangeElementListener {
        ChangeParticipantElementAction() {
        }

        public void elementChanged(Element elem) {
            AutomaticActivityInspector.this.updatePerformerInfo();
        }

        public void elementDropped(Element elem) {
            if (elem instanceof ParticipantElement) {
                AutomaticActivityInspector.this.performer = (ParticipantElement)elem;
                AutomaticActivityInspector.this.updatePerformerInfo();
            }
        }
    }

    class UnbindParamAction
    implements ActionListener {
        UnbindParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AutomaticActivityInspector.this.unbindSelectedMapping();
        }
    }

    class SelectParamTableAction
    implements ListSelectionListener {
        SelectParamTableAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            AutomaticActivityInspector.this.showVariableIcon();
        }
    }

    class ChangeProcessElementAction
    implements ChangeElementListener {
        ChangeProcessElementAction() {
        }

        public void elementChanged(Element elem) {
            AutomaticActivityInspector.this.updateDurationUnit((ProcessElement)elem);
        }

        public void elementDropped(Element elem) {
        }
    }
}

