/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ElementReceivableView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;
import jp.co.argo21.nautica.tool.wfd.inspector.ProcessInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.TransitionalActivityInspector;

public class InteractiveActivityInspector
extends TransitionalActivityInspector {
    private JTextField limitField;
    private JLabel unitField;
    private ElementReceivableView performerIconField;
    private JLabel performerIDField;
    private JLabel performerNameField;
    private ChangeProcessElementAction changeProcAction;
    private ChangeParticipantElementAction changePartAction;
    private ParticipantElement performer;

    public InteractiveActivityInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.changeProcAction = new ChangeProcessElementAction();
        this.changePartAction = new ChangeParticipantElementAction();
        JPanel panel = this.createInteractiveInfoPanel(rm);
        this.addTab(rm.getResource("InteractiveActivityInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createInteractiveInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension size = new Dimension(380, 210);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("InteractiveActivityInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("InteractiveActivityInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("InteractiveActivityInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("InteractiveActivityInspector.label.3"));
        this.limitField = new JTextField();
        this.limitField.setHorizontalAlignment(4);
        this.limitField.setDocument(new NumericDocument(3, true, true));
        this.unitField = new JLabel();
        this.performerIconField = new ElementReceivableView("participant");
        this.performerIconField.addChangeElementListener(this.changePartAction);
        this.performerIDField = new JLabel();
        this.performerIDField.setBorder(border);
        this.performerNameField = new JLabel();
        this.performerNameField.setBorder(border);
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(this.limitField, 110, 10, 70, 25));
        panel.add(this.locate(this.unitField, 180, 10, 70, 25));
        panel.add(this.locate(l1, 10, 40, 100, 25));
        panel.add(this.locate(this.performerIconField, 10, 70, 60, 60));
        panel.add(this.locate(l2, 80, 72, 100, 25));
        panel.add(this.locate(l3, 80, 102, 100, 25));
        panel.add(this.locate(this.performerIDField, 180, 72, 190, 25));
        panel.add(this.locate(this.performerNameField, 180, 102, 190, 25));
        this.validate();
        return panel;
    }

    public void commit() {
        super.commit();
        Element e = this.getInspectable();
        if (e != null && e instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)e;
            try {
                int limit = Integer.parseInt(this.limitField.getText());
                act.setLimit(limit);
            }
            catch (Exception ex) {
                act.setLimit(0);
            }
            if (this.performer != null) {
                act.setPerformerID(this.performer.getID());
            } else {
                act.setPerformerID(null);
            }
        }
    }

    public final void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ActivityElement) {
            PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
            this.updateDurationUnit(null);
            ActivityElement act = (ActivityElement)elem;
            this.limitField.setText("" + act.getLimit());
            String pfid = act.getPerformerID();
            if (!StringUtils.checkNull(pfid)) {
                Iterator it = pkg.getParticipants().iterator();
                while (it.hasNext()) {
                    ParticipantElement e = (ParticipantElement)it.next();
                    if (!pfid.equals(e.getID())) continue;
                    this.performer = e;
                    break;
                }
                this.performerIconField.setElement(this.performer);
                this.updatePerformerInfo();
            }
        }
    }

    public void init() {
        super.init();
        this.unitField.setText("");
        this.performerIDField.setText("");
        this.performerNameField.setText("");
        this.limitField.setText("0");
        this.performerIconField.setElement(null);
        this.performer = null;
        InspectorDialog.addChangeElementListener("process", this.changeProcAction);
        InspectorDialog.addChangeElementListener("participant", this.changePartAction);
    }

    public void unload() {
        InspectorDialog.removeChangeElementListener("process", this.changeProcAction);
        InspectorDialog.removeChangeElementListener("participant", this.changePartAction);
    }

    private void updatePerformerInfo() {
        if (this.performer != null) {
            this.performerIDField.setText(this.performer.getID());
            this.performerNameField.setText(this.performer.getName());
        }
    }

    private void updateDurationUnit(ProcessElement p) {
        int u;
        ProcessElement proc = p;
        if (proc == null) {
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
            if (frame == null) {
                return;
            }
            proc = frame.getProcess();
        }
        if ((u = proc.getDurationUnit()) == 1) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[0]);
        } else if (u == 2) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[1]);
        } else if (u == 3) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        } else if (u == 4) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[3]);
        } else if (u == 5) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[4]);
        } else if (u == 6) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[5]);
        } else {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        }
    }

    class ChangeParticipantElementAction
    implements ChangeElementListener {
        ChangeParticipantElementAction() {
        }

        public void elementChanged(Element elem) {
            InteractiveActivityInspector.this.updatePerformerInfo();
        }

        public void elementDropped(Element elem) {
            if (elem instanceof ParticipantElement) {
                InteractiveActivityInspector.this.performer = (ParticipantElement)elem;
                InteractiveActivityInspector.this.updatePerformerInfo();
            }
        }
    }

    class ChangeProcessElementAction
    implements ChangeElementListener {
        ChangeProcessElementAction() {
        }

        public void elementChanged(Element elem) {
            InteractiveActivityInspector.this.updateDurationUnit((ProcessElement)elem);
        }

        public void elementDropped(Element elem) {
        }
    }
}

