/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ParameterInspector;

public class ProcessInspector
extends AbstractElementInspector {
    private static String[] columnNames;
    private static String rspColumnName;
    public static String[] DURATION_UNITS;
    private static String[] accessLevels;
    protected static final Border border;
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JTextField limitField;
    private JComboBox unitBox;
    private JLabel accessField;
    private JTextField descriptionField;
    private JTable paramTable;
    private JButton addParamButton;
    private JButton editParamButton;
    private JButton delParamButton;
    private JTable rspTable;
    private JButton addRspButton;
    private JButton updRspButton;
    private JButton delRspButton;
    private JTextField rspField;
    private List responsibles = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public ProcessInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel0 = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("ProcessInspector.tab.0"), panel0);
        JPanel panel1 = this.createParamInfoPanel(rm);
        this.addTab(rm.getResource("ProcessInspector.tab.1"), panel1);
        JPanel panel2 = this.createResponsibleInfoPanel(rm);
        this.addTab(rm.getResource("ProcessInspector.tab.2"), panel2);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 170);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("ProcessInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("ProcessInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("ProcessInspector.label.3"));
        JLabel l4 = new JLabel(rm.getResource("ProcessInspector.label.4"));
        this.iconView = new IconView();
        this.iconView.setIconName("process");
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        this.limitField = new JTextField();
        this.limitField.setHorizontalAlignment(4);
        this.limitField.setDocument(new NumericDocument(3, true, true));
        this.unitBox = new JComboBox<String>(DURATION_UNITS);
        this.accessField = new JLabel();
        this.accessField.setBorder(border);
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(l2, 80, 70, 100, 25));
        panel.add(this.locate(l3, 80, 100, 100, 25));
        panel.add(this.locate(l4, 80, 130, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.limitField, 180, 70, 110, 25));
        panel.add(this.locate(this.unitBox, 290, 70, 80, 25));
        panel.add(this.locate(this.accessField, 180, 100, 190, 25));
        panel.add(this.locate(this.descriptionField, 180, 130, 190, 25));
        this.validate();
        return panel;
    }

    private JPanel createParamInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.5"));
        this.paramTable = new JTable(new ParamTableModel());
        this.paramTable.setSelectionMode(0);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.paramTable);
        this.addParamButton = new JButton(rm.getResource("JButton.label.add"));
        this.addParamButton.addActionListener(new AddParamAction());
        this.editParamButton = new JButton(rm.getResource("JButton.label.edit"));
        this.editParamButton.addActionListener(new EditParamAction());
        this.delParamButton = new JButton(rm.getResource("JButton.label.delete"));
        this.delParamButton.addActionListener(new DeleteParamAction());
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(sp, 10, 40, 270, 145));
        panel.add(this.locate(this.addParamButton, 290, 40, 80, 25));
        panel.add(this.locate(this.editParamButton, 290, 70, 80, 25));
        panel.add(this.locate(this.delParamButton, 290, 100, 80, 25));
        this.validate();
        return panel;
    }

    private JPanel createResponsibleInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.5"));
        this.rspField = new JTextField();
        this.rspField.setDocument(new ByteLimitedDocument(64));
        this.rspTable = new JTable(new ResponsibleTableModel());
        this.rspTable.setSelectionMode(0);
        ListSelectionModel lsm = this.rspTable.getSelectionModel();
        lsm.addListSelectionListener(new ResponsibleSelectAction());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.rspTable);
        this.addRspButton = new JButton(rm.getResource("JButton.label.add"));
        this.addRspButton.addActionListener(new AddResponsibleAction());
        this.updRspButton = new JButton(rm.getResource("JButton.label.update"));
        this.updRspButton.addActionListener(new EditResponsibleAction());
        this.delRspButton = new JButton(rm.getResource("JButton.label.delete"));
        this.delRspButton.addActionListener(new DeleteResponsibleAction());
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(sp, 10, 40, 270, 115));
        panel.add(this.locate(this.addRspButton, 290, 40, 80, 25));
        panel.add(this.locate(this.updRspButton, 290, 70, 80, 25));
        panel.add(this.locate(this.delRspButton, 290, 100, 80, 25));
        panel.add(this.locate(this.rspField, 10, 160, 270, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.limitField.setText("0");
        this.unitBox.setSelectedIndex(2);
        this.responsibles.clear();
        this.rspField.setText("");
        this.paramTable.clearSelection();
        this.rspTable.clearSelection();
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ProcessElement) {
            ProcessElement proc = (ProcessElement)elem;
            this.idField.setText(proc.getID());
            this.nameField.setText(proc.getName());
            this.limitField.setText("" + proc.getLimit());
            int u = proc.getDurationUnit();
            if (u == 1) {
                this.unitBox.setSelectedIndex(0);
            } else if (u == 2) {
                this.unitBox.setSelectedIndex(1);
            } else if (u == 3) {
                this.unitBox.setSelectedIndex(2);
            } else if (u == 4) {
                this.unitBox.setSelectedIndex(3);
            } else if (u == 5) {
                this.unitBox.setSelectedIndex(4);
            } else if (u == 6) {
                this.unitBox.setSelectedIndex(5);
            } else {
                this.unitBox.setSelectedIndex(2);
            }
            int a = proc.getAccessLevel();
            if (a == 1) {
                this.accessField.setText(accessLevels[0]);
            } else {
                this.accessField.setText(accessLevels[1]);
            }
            this.descriptionField.setText(proc.getDescription());
            Iterator rit = proc.getResponsibles().iterator();
            while (rit.hasNext()) {
                this.responsibles.add(rit.next());
            }
        }
        this.setSelectedIndex(0);
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof ProcessElement) {
            ProcessElement proc = (ProcessElement)e;
            proc.setName(this.nameField.getText());
            try {
                int limit = Integer.parseInt(this.limitField.getText());
                proc.setLimit(limit);
            }
            catch (Exception ex) {
                proc.setLimit(0);
            }
            int u = this.unitBox.getSelectedIndex();
            if (u == 0) {
                proc.setDurationUnit(1);
            } else if (u == 1) {
                proc.setDurationUnit(2);
            } else if (u == 2) {
                proc.setDurationUnit(3);
            } else if (u == 3) {
                proc.setDurationUnit(4);
            } else if (u == 4) {
                proc.setDurationUnit(5);
            } else if (u == 5) {
                proc.setDurationUnit(6);
            }
            proc.setDescription(this.descriptionField.getText());
            proc.getResponsibles().clear();
            Iterator rit = this.responsibles.iterator();
            while (rit.hasNext()) {
                proc.addResponsible((String)rit.next());
            }
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        DURATION_UNITS = new String[6];
        ProcessInspector.DURATION_UNITS[0] = rm.getResource("ProcessInspector.unit.0");
        ProcessInspector.DURATION_UNITS[1] = rm.getResource("ProcessInspector.unit.1");
        ProcessInspector.DURATION_UNITS[2] = rm.getResource("ProcessInspector.unit.2");
        ProcessInspector.DURATION_UNITS[3] = rm.getResource("ProcessInspector.unit.3");
        ProcessInspector.DURATION_UNITS[4] = rm.getResource("ProcessInspector.unit.4");
        ProcessInspector.DURATION_UNITS[5] = rm.getResource("ProcessInspector.unit.5");
        accessLevels = new String[2];
        ProcessInspector.accessLevels[0] = rm.getResource("ProcessInspector.access.0");
        ProcessInspector.accessLevels[1] = rm.getResource("ProcessInspector.access.1");
        columnNames = new String[3];
        ProcessInspector.columnNames[0] = rm.getResource("ParamTableModel.columnName.0");
        ProcessInspector.columnNames[1] = rm.getResource("ParamTableModel.columnName.1");
        ProcessInspector.columnNames[2] = rm.getResource("ParamTableModel.columnName.2");
        rspColumnName = rm.getResource("ResponsibleTableModel.columnName.0");
    }

    class ResponsibleTableModel
    extends AbstractTableModel {
        ResponsibleTableModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return ProcessInspector.this.responsibles.size();
        }

        public String getColumnName(int col) {
            return rspColumnName;
        }

        public Object getValueAt(int row, int col) {
            return ProcessInspector.this.responsibles.get(row);
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = ProcessInspector.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class ResponsibleSelectAction
    implements ListSelectionListener {
        ResponsibleSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                ProcessInspector.this.rspField.setText((String)ProcessInspector.this.responsibles.get(selected));
            }
        }
    }

    class DeleteResponsibleAction
    extends AbstractAction {
        DeleteResponsibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ProcessInspector.this.rspTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0003"));
                return;
            }
            ProcessInspector.this.responsibles.remove(selected);
            ProcessInspector.this.rspField.setText("");
            ProcessInspector.this.rspTable.clearSelection();
            ProcessInspector.this.rspTable.updateUI();
        }
    }

    class EditResponsibleAction
    extends AbstractAction {
        EditResponsibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ProcessInspector.this.rspTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0003"));
                return;
            }
            String addr = ProcessInspector.this.rspField.getText();
            if (StringUtils.checkNull(addr)) {
                DialogUtilities.showError(rm.getResource("message.error.0026"));
            } else if (ProcessInspector.this.responsibles.contains(addr)) {
                if (!addr.equals(ProcessInspector.this.responsibles.get(selected))) {
                    DialogUtilities.showError(rm.getResource("message.error.0027"));
                }
            } else {
                ProcessInspector.this.responsibles.set(selected, addr);
            }
            ProcessInspector.this.responsibles.set(selected, addr);
            ProcessInspector.this.rspTable.clearSelection();
            ProcessInspector.this.rspTable.updateUI();
        }
    }

    class AddResponsibleAction
    extends AbstractAction {
        AddResponsibleAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            String addr = ProcessInspector.this.rspField.getText();
            if (StringUtils.checkNull(addr)) {
                DialogUtilities.showError(rm.getResource("message.error.0026"));
            } else if (ProcessInspector.this.responsibles.contains(addr)) {
                DialogUtilities.showError(rm.getResource("message.error.0027"));
            } else {
                ProcessInspector.this.responsibles.add(addr);
            }
            ProcessInspector.this.rspTable.clearSelection();
            ProcessInspector.this.rspTable.updateUI();
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            Element e = ProcessInspector.this.getInspectable();
            if (e == null) {
                return 0;
            }
            return ((ProcessElement)e).getParameters().size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Element e = ProcessInspector.this.getInspectable();
            if (e == null) {
                return "";
            }
            List list = ((ProcessElement)e).getParameters();
            ParameterElement p = (ParameterElement)list.get(row);
            if (col == 0) {
                int m = p.getMode();
                if (m == 1) {
                    return ParameterInspector.PARAM_MODES[0];
                }
                if (m == 2) {
                    return ParameterInspector.PARAM_MODES[1];
                }
                if (m == 3) {
                    return ParameterInspector.PARAM_MODES[2];
                }
            } else if (col == 1) {
                int t = p.getType();
                if (t == 1) {
                    return ParameterInspector.PARAM_TYPES[0];
                }
                if (t == 3) {
                    return ParameterInspector.PARAM_TYPES[1];
                }
                if (t == 6) {
                    return ParameterInspector.PARAM_TYPES[2];
                }
            } else if (col == 2) {
                return p.getDescription();
            }
            return "";
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = ProcessInspector.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class DeleteParamAction
    extends AbstractAction {
        DeleteParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ProcessInspector.this.paramTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
                return;
            }
            Element proc = ProcessInspector.this.getInspectable();
            if (proc == null) {
                return;
            }
            List list = ((ProcessElement)proc).getParameters();
            ParameterElement p = (ParameterElement)list.remove(selected);
            ProcessInspector.this.paramTable.clearSelection();
            ProcessInspector.this.paramTable.updateUI();
        }
    }

    class EditParamAction
    extends AbstractAction {
        EditParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ProcessInspector.this.paramTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
                return;
            }
            Element proc = ProcessInspector.this.getInspectable();
            if (proc == null) {
                return;
            }
            List list = ((ProcessElement)proc).getParameters();
            ParameterElement p = (ParameterElement)list.get(selected);
            InspectorDialog.showDialog((Component)ProcessInspector.this, p);
            ProcessInspector.this.paramTable.clearSelection();
            ProcessInspector.this.paramTable.updateUI();
        }
    }

    class AddParamAction
    extends AbstractAction {
        AddParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Element newElem = InspectorDialog.showDialog((Component)ProcessInspector.this, "parameter");
            if (newElem == null) {
                return;
            }
            Element proc = ProcessInspector.this.getInspectable();
            if (proc == null) {
                return;
            }
            ((ProcessElement)proc).addParameter((ParameterElement)newElem);
            ProcessInspector.this.paramTable.clearSelection();
            ProcessInspector.this.paramTable.updateUI();
        }
    }
}

