/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;

public class VariableInspector
extends AbstractElementInspector {
    private static String[] bools;
    protected static final Border border;
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JTextField descriptionField;
    private JRadioButton strButton;
    private JRadioButton numButton;
    private JRadioButton boolButton;
    private JTextField strField;
    private JTextField numField;
    private JComboBox boolBox;

    public VariableInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("VariableInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("VariableInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("VariableInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("VariableInspector.label.2"));
        this.iconView = new IconView();
        this.iconView.setIconName("variable");
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        this.strButton = new JRadioButton(rm.getResource("VariableInspector.label.3"));
        this.numButton = new JRadioButton(rm.getResource("VariableInspector.label.4"));
        this.boolButton = new JRadioButton(rm.getResource("VariableInspector.label.5"));
        this.strButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.strButton);
        group.add(this.numButton);
        group.add(this.boolButton);
        this.strField = new JTextField();
        this.strField.setDocument(new ByteLimitedDocument(128));
        this.numField = new JTextField();
        this.numField.setDocument(new NumericDocument(9, true));
        this.numField.setHorizontalAlignment(4);
        this.boolBox = new JComboBox<String>(bools);
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(this.strButton, 80, 70, 100, 25));
        panel.add(this.locate(this.numButton, 80, 100, 100, 25));
        panel.add(this.locate(this.boolButton, 80, 130, 100, 25));
        panel.add(this.locate(l2, 80, 160, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.strField, 180, 70, 190, 25));
        panel.add(this.locate(this.numField, 180, 100, 190, 25));
        panel.add(this.locate(this.boolBox, 180, 130, 190, 25));
        panel.add(this.locate(this.descriptionField, 180, 160, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        this.idField.setText("");
        this.nameField.setEditable(true);
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.nameField.setEditable(true);
        this.nameField.setText("");
        this.strButton.setEnabled(true);
        this.strField.setEditable(true);
        this.strField.setText("");
        this.numButton.setEnabled(true);
        this.numField.setEditable(true);
        this.numField.setText("0");
        this.boolButton.setEnabled(true);
        this.boolBox.setEnabled(true);
        this.boolBox.setSelectedIndex(0);
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof VariableElement) {
            VariableElement var = (VariableElement)elem;
            this.idField.setText(var.getID());
            this.nameField.setText(var.getName());
            int t = var.getType();
            boolean initialized = var.isInitialized();
            if (initialized) {
                this.nameField.setEditable(false);
            }
            if (t == 1) {
                this.strButton.setSelected(true);
                this.strField.setText(var.getInitialValue());
                if (initialized) {
                    this.numButton.setEnabled(false);
                    this.numField.setEditable(false);
                    this.boolButton.setEnabled(false);
                    this.boolBox.setEnabled(false);
                }
            } else if (t == 3) {
                this.numButton.setSelected(true);
                this.numField.setText(var.getInitialValue());
                if (initialized) {
                    this.strButton.setEnabled(false);
                    this.strField.setEditable(false);
                    this.boolButton.setEnabled(false);
                    this.boolBox.setEnabled(false);
                }
            } else if (t == 6) {
                this.boolButton.setSelected(true);
                String v = var.getInitialValue();
                if (v != null && v.equals("true")) {
                    this.boolBox.setSelectedIndex(0);
                } else {
                    this.boolBox.setSelectedIndex(1);
                }
                if (initialized) {
                    this.strButton.setEnabled(false);
                    this.strField.setEditable(false);
                    this.numButton.setEnabled(false);
                    this.numField.setEditable(false);
                }
            } else {
                this.strButton.setSelected(true);
                this.strField.setText(var.getInitialValue());
            }
            this.descriptionField.setText(var.getDescription());
        }
        this.setSelectedIndex(0);
    }

    public boolean check() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        VariableElement var = (VariableElement)this.getInspectable();
        String name = this.nameField.getText();
        PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
        Iterator vit = pkg.getVariables().iterator();
        while (vit.hasNext()) {
            VariableElement v = (VariableElement)vit.next();
            if (v == var) continue;
            String n = v.getName();
            if (StringUtils.checkNull(name)) {
                DialogUtilities.showError(rm.getResource("message.error.0030"));
                return false;
            }
            if (!name.equals(n)) continue;
            DialogUtilities.showError(rm.getResource("message.error.0031"));
            return false;
        }
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof VariableElement) {
            VariableElement var = (VariableElement)e;
            var.setName(this.nameField.getText());
            int b = this.boolBox.getSelectedIndex();
            if (this.numButton.isSelected()) {
                var.setType(3);
                var.setInitialValue(this.numField.getText());
            } else if (this.boolButton.isSelected()) {
                var.setType(6);
                if (b == 0) {
                    var.setInitialValue("true");
                } else if (b == 1) {
                    var.setInitialValue("false");
                }
            } else {
                var.setType(1);
                var.setInitialValue(this.strField.getText());
            }
            var.setDescription(this.descriptionField.getText());
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        bools = new String[4];
        VariableInspector.bools[0] = rm.getResource("VariableInspector.bool.0");
        VariableInspector.bools[1] = rm.getResource("VariableInspector.bool.1");
    }
}

