/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;
import org.apache.log4j.Logger;

public class WorkflowEngineShutdown {
    private static final Logger log = Logger.getLogger((Class)(class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown == null ? (class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown = WorkflowEngineShutdown.class$("jp.co.argo21.nautica.workflow.WorkflowEngineShutdown")) : class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown));
    private static final String version = "0.9";
    private static String naming = "iiop://localhost:1050";
    private static String scope = "";
    private static String user = "";
    private static String pass = "";
    private static String adminKey = "";
    static /* synthetic */ Class class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown;

    public static void main(String[] args) {
        try {
            WorkflowEngineShutdown.parseOption(args);
            WorkflowServiceAccessor accessor = new WorkflowServiceAccessor(new ConnectionInfo(naming, scope, user, pass));
            String session = accessor.open();
            WorkflowAdminHandlerRemote handler = accessor.getWorkflowAdminHandler();
            handler.shutdown(session, adminKey);
        }
        catch (Exception ex) {
            WorkflowEngineShutdown.exitWithException(ex);
        }
    }

    private static void parseOption(String[] args) {
        int argc = args.length;
        if (argc < 1) {
            WorkflowEngineShutdown.usage(null);
        }
        for (int i = 0; i < argc; ++i) {
            String token = args[i];
            if (token.equals("-jndi")) {
                if (++i == argc) {
                    WorkflowEngineShutdown.usage("Invalid usage: " + token);
                }
                naming = args[i];
                continue;
            }
            if (token.equals("-scope")) {
                if (++i == argc) {
                    WorkflowEngineShutdown.usage("Invalid usage: " + token);
                }
                scope = args[i];
                continue;
            }
            if (token.equals("-u")) {
                if (++i == argc) {
                    WorkflowEngineShutdown.usage("Invalid usage: " + token);
                }
                user = args[i];
                continue;
            }
            if (token.equals("-p")) {
                if (++i == argc) {
                    WorkflowEngineShutdown.usage("Invalid usage: " + token);
                }
                pass = args[i];
                continue;
            }
            if (token.equals("-admin")) {
                if (++i == argc) {
                    WorkflowEngineShutdown.usage("Invalid usage: " + token);
                }
                adminKey = args[i];
                continue;
            }
            if (token.equals("-v")) {
                WorkflowEngineShutdown.version();
                continue;
            }
            if (token.equals("-h")) {
                WorkflowEngineShutdown.usage(null);
                continue;
            }
            if (!token.startsWith("-")) break;
            WorkflowEngineShutdown.usage("Unknown option.: " + token);
        }
    }

    private static void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("WorkflowEngineShutdown 0.9\nCopyright (c)2005 ARGO 21, Corp. All rights reserved.\nUsage: java [<java options>...] " + (class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown == null ? (class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown = WorkflowEngineShutdown.class$("jp.co.argo21.nautica.workflow.WorkflowEngineShutdown")) : class$jp$co$argo21$nautica$workflow$WorkflowEngineShutdown).getName() + "\n" + "            [-home <nautica_home_dir>]\n\n" + " OPTIONS:\n" + "   -jndi <naming_url>\n" + "                    Naitica Workflow naming url.\n" + "   -scope <scope>\n" + "                    Naitica Workflow naming scope.\n" + "   -u <user>\n" + "                    Naitica Workflow user.\n" + "   -p <password>\n" + "                    Naitica Workflow password.\n" + "   -admin <admin_key>\n" + "                    Naitica Workflow admin key.\n" + "   -v               print version.\n" + "   -h               print this message.\n");
        System.exit(1);
    }

    private static void version() {
        System.err.println("WorkflowEngineShutdown version 0.9");
        System.exit(0);
    }

    private static void exitWithException(Exception ex) {
        log.error((Object)"Shutdown failed.", (Throwable)ex);
        ex.printStackTrace();
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

