/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.client;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import org.apache.log4j.Logger;

public class WorkflowServiceAccessorManager {
    private static Logger log = Logger.getLogger((Class)(class$jp$co$argo21$nautica$workflow$client$WorkflowServiceAccessorManager == null ? (class$jp$co$argo21$nautica$workflow$client$WorkflowServiceAccessorManager = WorkflowServiceAccessorManager.class$("jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessorManager")) : class$jp$co$argo21$nautica$workflow$client$WorkflowServiceAccessorManager));
    private static WorkflowServiceAccessorManager wsam = new WorkflowServiceAccessorManager();
    private static final long CHECK_TIMEOUT_INTERVAL = 1800000L;
    private static final long VALID_TERM = 1800000L;
    private Map accessors = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$jp$co$argo21$nautica$workflow$client$WorkflowServiceAccessorManager;

    private WorkflowServiceAccessorManager() {
        TimeoutTimerTask task = new TimeoutTimerTask(this);
        new Timer().schedule((TimerTask)task, 0L, 1800000L);
    }

    public static WorkflowServiceAccessorManager getInstance() {
        return wsam;
    }

    public String open(ConnectionInfo conn) throws ConnectionFailedException, RemoteException {
        WorkflowServiceAccessor wsa = new WorkflowServiceAccessor(conn);
        String sessionID = wsa.open();
        ManagedServiceAccessor msa = new ManagedServiceAccessor(wsa);
        this.accessors.put(sessionID, msa);
        return sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String sessionID) throws InvalidSessionException, RemoteException {
        ManagedServiceAccessor msa = (ManagedServiceAccessor)this.accessors.get(sessionID);
        if (msa == null) {
            String warnMsg = StringManager.get("E8002");
            throw new InvalidSessionException(warnMsg);
        }
        try {
            msa.getServiceAccessor().close();
        }
        finally {
            this.accessors.remove(sessionID);
        }
    }

    public WorkflowServiceAccessor getServiceAccessor(String sessionID) throws InvalidSessionException {
        ManagedServiceAccessor msa = (ManagedServiceAccessor)this.accessors.get(sessionID);
        if (msa == null) {
            String errMsg = StringManager.get("E8002") + "(SessionID=" + sessionID + ")";
            log.error((Object)errMsg);
            throw new InvalidSessionException(errMsg);
        }
        return msa.getServiceAccessor();
    }

    private void timerRaised() {
        HashSet<String> timeouts = new HashSet<String>();
        Iterator<Object> i = this.accessors.keySet().iterator();
        while (i.hasNext()) {
            String sessionID = (String)i.next();
            ManagedServiceAccessor msa = (ManagedServiceAccessor)this.accessors.get(sessionID);
            long notAccessedTerm = System.currentTimeMillis() - msa.getLastAccessedTime().getTime();
            if (notAccessedTerm < 1800000L) continue;
            timeouts.add(sessionID);
        }
        i = timeouts.iterator();
        while (i.hasNext()) {
            String timeoutSessionID = (String)i.next();
            this.accessors.remove(timeoutSessionID);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private WorkflowServiceAccessorManager wam;

        private TimeoutTimerTask(WorkflowServiceAccessorManager wam) {
            this.wam = wam;
        }

        public void run() {
            this.wam.timerRaised();
        }
    }

    private class ManagedServiceAccessor {
        private Date lastAccessedTime;
        private WorkflowServiceAccessor wsa;

        private ManagedServiceAccessor(WorkflowServiceAccessor wsa) {
            this.wsa = wsa;
            this.lastAccessedTime = new Date();
        }

        private WorkflowServiceAccessor getServiceAccessor() {
            this.updateLastAccessedTime();
            return this.wsa;
        }

        private Date getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        private void updateLastAccessedTime() {
            this.lastAccessedTime = new Date();
        }
    }
}

