/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationTypeBean;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationTypeDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLApplicationTypeDAO
extends AbstractDAO
implements ApplicationTypeDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String APP_TYPE = "APP_TYPE";
    public static final String APP_TYPE_NAME = "APP_TYPE_NAME";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from APPTYPE where APP_TYPE = ? ";
    private static final String SQL_INSERT = "insert into APPTYPE (APP_TYPE, APP_TYPE_NAME) values (?,?)";

    MySQLApplicationTypeDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationTypeBean findByPrimaryKey(String appType) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, appType);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ApplicationTypeBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ApplicationTypeBean applicationTypeBean = bean;
            return applicationTypeBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ApplicationTypeBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setInt(1, bean.getAppType());
            st.setString(2, bean.getAppTypeName());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0013");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ApplicationTypeBean createBean(ResultSet rs) throws SQLException {
        ApplicationTypeBean bean = new ApplicationTypeBean();
        bean.setAppType(rs.getInt(APP_TYPE));
        bean.setAppTypeName(rs.getString(APP_TYPE_NAME));
        return bean;
    }
}

