/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLSourceActivityDAO
extends AbstractDAO
implements SourceActivityDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String ENGINE_ID = "ENGINE_ID";
    public static final String ROOT_PROC_ID = "ROOT_PROC_ID";
    public static final String ROOT_ACT_ID = "ROOT_ACT_ID";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from ETAACTIVITY where PROCESS_ID = ? ";
    private static final String SQL_INSERT = "insert into ETAACTIVITY (PROCESS_ID, ENGINE_ID, ROOT_PROC_ID, ROOT_ACT_ID) values (?,?,?,?)";
    private static final String SQL_DELETE = "delete from ETAACTIVITY where PROCESS_ID = ? ";

    MySQLSourceActivityDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceActivityBean findByPrimaryKey(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            SourceActivityBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            SourceActivityBean sourceActivityBean = bean;
            return sourceActivityBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(SourceActivityBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcessID());
            st.setString(2, bean.getEngineID());
            st.setString(3, bean.getRootProcID());
            st.setString(4, bean.getRootActID());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0026");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE);
        try {
            st.setString(1, pid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0025");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private SourceActivityBean createBean(ResultSet rs) throws SQLException {
        SourceActivityBean bean = new SourceActivityBean();
        bean.setProcessID(rs.getString(PROCESS_ID));
        bean.setEngineID(rs.getString(ENGINE_ID));
        bean.setRootProcID(rs.getString(ROOT_PROC_ID));
        bean.setRootActID(rs.getString(ROOT_ACT_ID));
        return bean;
    }
}

