/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import jp.co.argo21.nautica.workflow.definition.VariableDefinition;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;

public class VariableDefinitionImpl
implements VariableDefinition {
    private static final long serialVersionUID = 20050000000000001L;
    private String id;
    private String name;
    private String description;
    private int type;
    private String initialValue;
    private boolean isInitialized;

    public VariableDefinitionImpl(DataFieldDocument.DataField df) {
        String id = df.getId();
        if (StringUtils.checkNull(id)) {
            this.setID(IDGenerator.generate("VR"));
        } else {
            this.setID(id);
        }
        this.setName(df.getName());
        this.setDescription(df.getDescription());
        this.setInitialValue(df.getInitialValue());
        DataTypeDocument.DataType t = df.getDataType();
        if (t != null && t.isSetBasicType()) {
            BasicTypeDocument.BasicType bt = t.getBasicType();
            BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
            this.setType(type.intValue());
            this.isInitialized = true;
        } else {
            this.setType(1);
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public int getType() {
        return this.type;
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setInitialValue(String v) {
        this.initialValue = v;
    }

    private void setType(int i) {
        this.type = i;
        this.isInitialized = true;
    }
}

