/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.jdbc.DataSourceFactory;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class DataAccessManager {
    private static final ThreadLocal connectionHolder = new ThreadLocal();
    private static final ThreadLocal timestampHolder = new ThreadLocal();
    private static Logger eLog = LogManager.getEngineLogger();
    private static DataSource ds;
    private static WorkflowDAOFactory daoFactory;

    static void create() throws WorkflowException {
        if (ds != null) {
            String msg = StringManager.get("E0070");
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        try {
            String dsfcn = System.getProperty("nautica.workflow.datasource.factory");
            DataSourceFactory factory = (DataSourceFactory)Class.forName(dsfcn).newInstance();
            ds = factory.getDataSource();
            String daofcn = System.getProperty("nautica.workflow.dao.factory");
            daoFactory = (WorkflowDAOFactory)Class.forName(daofcn).newInstance();
        }
        catch (Exception ex) {
            String msg = StringManager.get("E0071");
            eLog.error((Object)msg, (Throwable)ex);
            throw new WorkflowException(msg, ex);
        }
    }

    public static DataSource getDataSource() {
        return ds;
    }

    public static WorkflowDAOFactory getDAOFactory() {
        return daoFactory;
    }

    public static void begin(boolean isAutoCommit) throws SQLException {
        Connection conn = DataAccessManager.getConnection();
        conn.setAutoCommit(isAutoCommit);
    }

    public static void commit() throws SQLException, WorkflowException {
        Connection conn = DataAccessManager.getConnection();
        conn.commit();
        DataAccessManager.close();
        SystemMessageTransporter.execute();
    }

    public static void rollback() throws SQLException {
        Connection conn = DataAccessManager.getConnection();
        if (conn != null && !conn.isClosed()) {
            conn.rollback();
        }
        DataAccessManager.close();
    }

    public static Connection getConnection() throws SQLException {
        Connection conn = (Connection)connectionHolder.get();
        if (conn == null) {
            conn = ds.getConnection();
            connectionHolder.set(conn);
            long now = System.currentTimeMillis();
            Timestamp ts = new Timestamp(now);
            timestampHolder.set(ts);
        }
        return conn;
    }

    public static Timestamp getAccessTime() throws SQLException {
        DataAccessManager.getConnection();
        Timestamp ts = (Timestamp)timestampHolder.get();
        return ts;
    }

    public static void close() throws SQLException {
        Connection conn = (Connection)connectionHolder.get();
        connectionHolder.set(null);
        timestampHolder.set(null);
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }
}

