/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.DefinitionLoader;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionNotFoundException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

class DefinitionCache {
    private static Logger eLog = LogManager.getEngineLogger();
    private static DefinitionLoader loader;
    private static int DEFAULT_MAX_COUNT;
    private int maxCacheCount = DEFAULT_MAX_COUNT;
    private List definitions = new ArrayList();

    DefinitionCache() {
        String s = System.getProperty("nautica.workflow.repository.maxCacheCount");
        try {
            int count = Integer.parseInt(s);
            if (count < DEFAULT_MAX_COUNT) {
                count = DEFAULT_MAX_COUNT;
            }
            this.maxCacheCount = count;
            this.preload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getMaxCacheCount() {
        return this.maxCacheCount;
    }

    synchronized PackageDefinition getPackageDefinition(String name) throws DefinitionNotFoundException, WorkflowException {
        try {
            DefinitionBean bean = this.getDefinitionBean(name);
            return this.findDefinition(bean);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0096 = StringManager.get("E0096");
            throw new WorkflowException(E0096, ex);
        }
    }

    synchronized ProcessDefinition getProcessDefinition(String name) throws DefinitionNotFoundException, WorkflowException {
        try {
            DefinitionBean bean = this.getDefinitionBean(name);
            String id = bean.getInternalPDID();
            PackageDefinition pkg = this.findDefinition(bean);
            Iterator it = pkg.getProcesses().iterator();
            while (it.hasNext()) {
                ProcessDefinition p = (ProcessDefinition)it.next();
                if (!p.getID().equals(id)) continue;
                return p;
            }
            String E0094 = StringManager.get("E0094") + "(" + name + ")";
            throw new DefinitionNotFoundException(E0094);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0097 = StringManager.get("E0097") + "(" + name + ")";
            throw new WorkflowException(E0097, ex);
        }
    }

    synchronized DefinitionBean getDefinitionBean(String name) throws DefinitionNotFoundException, Exception {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            DefinitionDAO dao = daoFactory.getDefinitionDAO();
            DefinitionBean bean = dao.findByPrimaryKey(name);
            if (bean == null) {
                String E0095 = StringManager.get("E0095") + "(" + name + ")";
                eLog.error((Object)E0095);
                throw new DefinitionNotFoundException(E0095);
            }
            return bean;
        }
        catch (DefinitionNotFoundException ex) {
            throw ex;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0098 = StringManager.get("E0098") + "(" + name + ")";
            throw new WorkflowException(E0098, ex);
        }
    }

    private void preload() throws Exception {
        String s = System.getProperty("nautica.workflow.repository.preloadPath");
        if (s == null || s.trim().equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            try {
                this.preloadDefinition(path);
            }
            catch (Exception ex) {
                String W0005 = StringManager.get("W0005") + "(" + path + ")";
                eLog.warn((Object)W0005);
            }
        }
    }

    private PackageDefinition findDefinition(DefinitionBean bean) throws Exception {
        String path = bean.getPath();
        String id = bean.getProcessDefinitionID();
        PackageDefinition pkg = this.findDefinitionByPath(path);
        if (pkg == null) {
            pkg = loader.load(path);
            QueueItem item = new QueueItem(path, pkg);
            this.cache(item);
        }
        return pkg;
    }

    private void preloadDefinition(String path) throws Exception {
        PackageDefinition pkg = this.findDefinitionByPath(path);
        if (pkg == null) {
            pkg = loader.load(path);
            QueueItem item = new QueueItem(path, pkg);
            this.cache(item);
        }
    }

    private PackageDefinition findDefinitionByPath(String path) {
        Iterator it = this.definitions.iterator();
        PackageDefinition pkg = null;
        while (it.hasNext()) {
            QueueItem item = (QueueItem)it.next();
            if (!path.equals(item.path)) continue;
            pkg = item.packageDefinition;
        }
        return pkg;
    }

    private void cache(QueueItem item) {
        int count = this.definitions.size();
        if (count == this.getMaxCacheCount()) {
            this.definitions.remove(0);
        }
        this.definitions.add(item);
    }

    static {
        DEFAULT_MAX_COUNT = 20;
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        loader = new DefinitionLoader(home + separator + "repository");
    }

    private class QueueItem {
        private String path;
        private PackageDefinition packageDefinition;

        private QueueItem(String path, PackageDefinition pkg) {
            this.path = path;
            this.packageDefinition = pkg;
        }
    }
}

