/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.EndProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorImpl;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessage;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

class EndProcessRequestWatcher
extends WorkflowMessageAdapter {
    private static Logger eLog = LogManager.getEngineLogger();
    public static final String NAME = "END_PROCESS_REQUEST";

    EndProcessRequestWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(WorkflowMessage message) {
        if (!(message instanceof EndProcessRequestMessage)) {
            String E0099 = StringManager.get("E0099");
            eLog.error((Object)E0099);
            return;
        }
        EndProcessRequestMessage msg = (EndProcessRequestMessage)message;
        String eid = msg.getEngineID();
        String spid = msg.getProcessID();
        ActivityState astate = msg.getActivityState();
        try {
            DataAccessManager.begin(false);
            this.endProcess(eid, spid, astate);
        }
        catch (Exception ex) {
            try {
                String E0101 = StringManager.get("E0101");
                eLog.error((Object)E0101, (Throwable)ex);
                this.endProcess(eid, spid, ActivityState.CLOSED_ABORTED);
            }
            catch (Exception ex2) {
                String F0101 = StringManager.get("F0101");
                eLog.fatal((Object)F0101, (Throwable)ex);
            }
        }
        finally {
            try {
                DataAccessManager.commit();
            }
            catch (Exception ex3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endProcess(String eid, String spid, ActivityState astate) throws Exception {
        if (eid == null || eid.trim().equals("")) {
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(spid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(spid);
            ProcessState pstate = null;
            if (astate == null || ActivityState.CLOSED_COMPLETED.equals(astate)) {
                proc.complete();
                pstate = ProcessState.CLOSED_COMPLETED;
            } else if (ActivityState.CLOSED_TERMINATED.equals(astate)) {
                proc.terminate(false);
                pstate = ProcessState.CLOSED_TERMINATED;
            } else if (ActivityState.CLOSED_ABORTED.equals(astate)) {
                proc.abort(true);
                pstate = ProcessState.CLOSED_ABORTED;
            }
            InterWorkflowConnectorImpl iwc = (InterWorkflowConnectorImpl)InterWorkflowConnectorImpl.getInstance();
            iwc.processStateChangedLocal(spid, pstate);
        } else {
            InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(eid);
            String session = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
            try {
                ProcessState pstate = null;
                if (astate == null || ActivityState.CLOSED_COMPLETED.equals(astate)) {
                    pstate = ProcessState.CLOSED_COMPLETED;
                } else if (ActivityState.CLOSED_TERMINATED.equals(astate)) {
                    pstate = ProcessState.CLOSED_TERMINATED;
                } else if (ActivityState.CLOSED_ABORTED.equals(astate)) {
                    pstate = ProcessState.CLOSED_ABORTED;
                }
                iwc.changeProcessState(session, spid, pstate);
            }
            finally {
                iwc.disconnect(session);
            }
        }
    }
}

