/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.ta.SystemCommandConfig;
import jp.co.argo21.nautica.workflow.ta.config.SystemCommandsDocument;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.xmlbeans.XmlOptions;

public class SystemCommandConfigFactory {
    public static String CONFIG_FILENAME = "systemcommand.xml";
    private static long lastModified = 0L;
    private static SystemCommandConfig config = null;

    private SystemCommandConfigFactory() {
    }

    public static synchronized SystemCommandConfig getConfig() throws WorkflowException {
        try {
            File configFile = new File(SystemCommandConfigFactory.getConfigPath());
            if (config == null || lastModified < configFile.lastModified()) {
                FileInputStream in = new FileInputStream(configFile);
                XmlOptions opts = new XmlOptions();
                opts.setCharacterEncoding("utf-8");
                SystemCommandsDocument doc = SystemCommandsDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
                SystemCommandsDocument.SystemCommands commands = doc.getSystemCommands();
                config = new SystemCommandConfig(commands);
                lastModified = configFile.lastModified();
            }
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E2005");
            throw new WorkflowException(errMsg, ex);
        }
        return config;
    }

    private static URI getConfigPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        String conf = CONFIG_FILENAME;
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + conf;
        File confFile = new File(path);
        if (!confFile.exists()) {
            throw new WorkflowException(path + " is not found.");
        }
        if (!confFile.isFile()) {
            throw new WorkflowException(path + " is not file.");
        }
        return confFile.toURI();
    }
}

