/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.io.Serializable;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.omg.WfState;

public final class ProcessState
implements WfState,
Serializable {
    private static final long serialVersionUID = 20050000000000001L;
    public static final ProcessState OPEN_NOT_RUNNING_NOT_STARTED = new ProcessState("open.not_running.not_started", 1);
    public static final ProcessState OPEN_NOT_RUNNING_SUSPENDED = new ProcessState("open.not_running.suspended", 2);
    public static final ProcessState OPEN_RUNNING = new ProcessState("open.running", 3);
    public static final ProcessState CLOSED_COMPLETED = new ProcessState("closed.completed", 4);
    public static final ProcessState CLOSED_TERMINATED = new ProcessState("closed.terminated", 5);
    public static final ProcessState CLOSED_ABORTED = new ProcessState("closed.aborted", 6);
    private String stateString;
    private int stateNum;

    public static ProcessState getState(int n) {
        switch (n) {
            case 1: {
                return OPEN_NOT_RUNNING_NOT_STARTED;
            }
            case 2: {
                return OPEN_NOT_RUNNING_SUSPENDED;
            }
            case 3: {
                return OPEN_RUNNING;
            }
            case 4: {
                return CLOSED_COMPLETED;
            }
            case 5: {
                return CLOSED_TERMINATED;
            }
            case 6: {
                return CLOSED_ABORTED;
            }
        }
        return null;
    }

    public static ProcessState[] getTransitableStates(int n) {
        ArrayList<ProcessState> states = new ArrayList<ProcessState>();
        switch (n) {
            case 1: 
            case 2: {
                states.add(OPEN_RUNNING);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
                break;
            }
            case 3: {
                states.add(OPEN_NOT_RUNNING_SUSPENDED);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
            }
        }
        return states.toArray(new ProcessState[0]);
    }

    private ProcessState(String s, int i) {
        this.stateString = s;
        this.stateNum = i;
    }

    public String toString() {
        return this.stateString;
    }

    public int toInt() {
        return this.stateNum;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcessState)) {
            return false;
        }
        ProcessState s = (ProcessState)obj;
        return this.stateNum == s.stateNum && this.stateString.equals(s.stateString);
    }

    public int hashCode() {
        return this.stateString.hashCode();
    }
}

