/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.ResultSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BlobFromLocator
implements Blob {
    private List primaryKeyColumns = null;
    private List primaryKeyValues = null;
    private ResultSet creatorResultSet;
    private String blobColumnName = null;
    private String tableName = null;
    private int numColsInResultSet = 0;
    private int numPrimaryKeys = 0;

    BlobFromLocator(ResultSet creatorResultSetToSet, int blobColumnIndex) throws SQLException {
        this.creatorResultSet = creatorResultSetToSet;
        this.numColsInResultSet = this.creatorResultSet.fields.length;
        if (this.numColsInResultSet > 1) {
            this.primaryKeyColumns = new ArrayList();
            this.primaryKeyValues = new ArrayList();
            for (int i = 0; i < this.numColsInResultSet; ++i) {
                if (!this.creatorResultSet.fields[i].isPrimaryKey()) continue;
                this.primaryKeyColumns.add(this.creatorResultSet.fields[i].getName());
                this.primaryKeyValues.add(this.creatorResultSet.getString(i + 1));
            }
        } else {
            throw new SQLException("Emulated BLOB locators must come from a ResultSet with only one table selected, and all primary keys selected", "S1000");
        }
        this.numPrimaryKeys = this.primaryKeyColumns.size();
        this.tableName = this.creatorResultSet.fields[0].getTableName();
        this.blobColumnName = this.creatorResultSet.getString(blobColumnIndex);
    }

    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        throw new NotImplemented();
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytes(1L, (int)this.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        block10: {
            int i;
            PreparedStatement pStmt = null;
            if (offset + length > bytes.length) {
                length = bytes.length - offset;
            }
            byte[] bytesToWrite = new byte[length];
            System.arraycopy(bytes, offset, bytesToWrite, 0, length);
            StringBuffer query = new StringBuffer("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append(this.blobColumnName);
            query.append(" = INSERT(");
            query.append(this.blobColumnName);
            query.append(", ");
            query.append(writeAt);
            query.append(", ");
            query.append(length);
            query.append(", ?) WHERE ");
            query.append((String)this.primaryKeyColumns.get(0));
            query.append(" = ?");
            for (i = 1; i < this.numPrimaryKeys; ++i) {
                query.append(" AND ");
                query.append((String)this.primaryKeyColumns.get(i));
                query.append(" = ?");
            }
            try {
                pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                pStmt.setBytes(1, bytesToWrite);
                for (i = 0; i < this.numPrimaryKeys; ++i) {
                    pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                }
                int rowsUpdated = pStmt.executeUpdate();
                if (rowsUpdated != 1) {
                    throw new SQLException("BLOB data not found! Did primary keys change?", "S1000");
                }
                Object var11_9 = null;
                if (pStmt == null) break block10;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                    pStmt = null;
                }
                throw throwable;
            }
            try {
                pStmt.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            pStmt = null;
            {
            }
        }
        return (int)this.length();
    }

    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        return this.setBytes(writeAt, bytes, 0, bytes.length);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        block13: {
            SQLException sqlEx22;
            byte[] byArray;
            PreparedStatement pStmt;
            block14: {
                int i;
                java.sql.ResultSet blobRs = null;
                pStmt = null;
                StringBuffer query = new StringBuffer("SELECT SUBSTRING(");
                query.append(this.blobColumnName);
                query.append(", ");
                query.append(pos);
                query.append(", ");
                query.append(length);
                query.append(") FROM ");
                query.append(this.tableName);
                query.append(" WHERE ");
                query.append((String)this.primaryKeyColumns.get(0));
                query.append(" = ?");
                for (i = 1; i < this.numPrimaryKeys; ++i) {
                    query.append(" AND ");
                    query.append((String)this.primaryKeyColumns.get(i));
                    query.append(" = ?");
                }
                try {
                    pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                    for (i = 0; i < this.numPrimaryKeys; ++i) {
                        pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block13;
                    byArray = ((ResultSet)blobRs).getBytes(1, true);
                    Object var9_8 = null;
                    if (blobRs == null) break block14;
                }
                catch (Throwable throwable) {
                    block17: {
                        SQLException sqlEx22;
                        Object var9_9 = null;
                        if (blobRs != null) {
                            try {
                                blobRs.close();
                            }
                            catch (SQLException sqlEx22) {
                                // empty catch block
                            }
                            blobRs = null;
                        }
                        if (pStmt == null) break block17;
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            // empty catch block
                        }
                        pStmt = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                blobRs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                pStmt = null;
            }
            return byArray;
        }
        throw new SQLException("BLOB data not found! Did primary keys change?", "S1000");
    }

    public long length() throws SQLException {
        block13: {
            SQLException sqlEx22;
            long l;
            PreparedStatement pStmt;
            block14: {
                int i;
                java.sql.ResultSet blobRs = null;
                pStmt = null;
                StringBuffer query = new StringBuffer("SELECT LENGTH(");
                query.append(this.blobColumnName);
                query.append(") FROM ");
                query.append(this.tableName);
                query.append(" WHERE ");
                query.append((String)this.primaryKeyColumns.get(0));
                query.append(" = ?");
                for (i = 1; i < this.numPrimaryKeys; ++i) {
                    query.append(" AND ");
                    query.append((String)this.primaryKeyColumns.get(i));
                    query.append(" = ?");
                }
                try {
                    pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                    for (i = 0; i < this.numPrimaryKeys; ++i) {
                        pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block13;
                    l = blobRs.getLong(1);
                    Object var7_6 = null;
                    if (blobRs == null) break block14;
                }
                catch (Throwable throwable) {
                    block17: {
                        SQLException sqlEx22;
                        Object var7_7 = null;
                        if (blobRs != null) {
                            try {
                                blobRs.close();
                            }
                            catch (SQLException sqlEx22) {
                                // empty catch block
                            }
                            blobRs = null;
                        }
                        if (pStmt == null) break block17;
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            // empty catch block
                        }
                        pStmt = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                blobRs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                pStmt = null;
            }
            return l;
        }
        throw new SQLException("BLOB data not found! Did primary keys change?", "S1000");
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        block13: {
            SQLException sqlEx22;
            long l;
            PreparedStatement pStmt;
            block14: {
                int i;
                java.sql.ResultSet blobRs = null;
                pStmt = null;
                StringBuffer query = new StringBuffer("SELECT LOCATE(");
                query.append("?, ");
                query.append(this.blobColumnName);
                query.append(", ");
                query.append(start);
                query.append(") FROM ");
                query.append(this.tableName);
                query.append(" WHERE ");
                query.append((String)this.primaryKeyColumns.get(0));
                query.append(" = ?");
                for (i = 1; i < this.numPrimaryKeys; ++i) {
                    query.append(" AND ");
                    query.append((String)this.primaryKeyColumns.get(i));
                    query.append(" = ?");
                }
                try {
                    pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                    pStmt.setBytes(1, pattern);
                    for (i = 0; i < this.numPrimaryKeys; ++i) {
                        pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block13;
                    l = blobRs.getLong(1);
                    Object var10_8 = null;
                    if (blobRs == null) break block14;
                }
                catch (Throwable throwable) {
                    block17: {
                        SQLException sqlEx22;
                        Object var10_9 = null;
                        if (blobRs != null) {
                            try {
                                blobRs.close();
                            }
                            catch (SQLException sqlEx22) {
                                // empty catch block
                            }
                            blobRs = null;
                        }
                        if (pStmt == null) break block17;
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            // empty catch block
                        }
                        pStmt = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                blobRs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sqlEx22) {
                    // empty catch block
                }
                pStmt = null;
            }
            return l;
        }
        throw new SQLException("BLOB data not found! Did primary keys change?", "S1000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long length) throws SQLException {
        block9: {
            int i;
            PreparedStatement pStmt = null;
            StringBuffer query = new StringBuffer("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append(this.blobColumnName);
            query.append(" = LEFT(");
            query.append(this.blobColumnName);
            query.append(", ");
            query.append(length);
            query.append(") WHERE ");
            query.append((String)this.primaryKeyColumns.get(0));
            query.append(" = ?");
            for (i = 1; i < this.numPrimaryKeys; ++i) {
                query.append(" AND ");
                query.append((String)this.primaryKeyColumns.get(i));
                query.append(" = ?");
            }
            try {
                pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                for (i = 0; i < this.numPrimaryKeys; ++i) {
                    pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                }
                int rowsUpdated = pStmt.executeUpdate();
                if (rowsUpdated != 1) {
                    throw new SQLException("BLOB data not found! Did primary keys change?", "S1000");
                }
                Object var7_5 = null;
                if (pStmt == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                    pStmt = null;
                }
                throw throwable;
            }
            try {
                pStmt.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            pStmt = null;
            {
            }
        }
    }
}

