/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.Slot;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.AsynchChannel;
import org.activeio.ChannelFactory;
import org.activeio.FilterAsynchChannel;
import org.activeio.Packet;
import org.activeio.PacketData;
import org.activeio.RequestChannel;
import org.activeio.RequestListener;
import org.activeio.packet.AppendedPacket;
import org.activeio.packet.ByteArrayPacket;

public final class AsynchChannelToConcurrentRequestChannel
extends FilterAsynchChannel
implements RequestChannel {
    private static final byte PASSTHROUGH = 0;
    private static final byte REQUEST = 1;
    private static final byte RESPONSE = 2;
    private static final ByteArrayPacket PASSTHROUGH_PACKET = new ByteArrayPacket(new byte[]{0});
    private final ConcurrentHashMap requestMap = new ConcurrentHashMap();
    private final Executor requestExecutor;
    private short nextRequestId = 0;
    private final Object writeMutex = new Object();
    private RequestListener requestListener;

    public AsynchChannelToConcurrentRequestChannel(AsynchChannel next) {
        this(next, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public AsynchChannelToConcurrentRequestChannel(AsynchChannel next, Executor requestExecutor) {
        super(next);
        this.requestExecutor = requestExecutor;
    }

    synchronized short getNextRequestId() {
        short s = this.nextRequestId;
        this.nextRequestId = (short)(s + 1);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Packet packet) throws IOException {
        Packet passThrough = AppendedPacket.join(PASSTHROUGH_PACKET.duplicate(), packet);
        Object object = this.writeMutex;
        synchronized (object) {
            super.write(passThrough);
        }
    }

    public void onPacket(final Packet packet) {
        switch (packet.read()) {
            case 0: {
                super.onPacket(packet);
                break;
            }
            case 1: {
                try {
                    this.requestExecutor.execute(new Runnable(){

                        public void run() {
                            AsynchChannelToConcurrentRequestChannel.this.serviceRequest(packet);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                break;
            }
            case 2: {
                this.serviceReponse(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRequest(Packet packet) {
        try {
            if (this.requestListener == null) {
                throw new IOException("The RequestListener has not been set.");
            }
            PacketData data = new PacketData(packet);
            short requestId = data.readShort();
            Packet reponse = this.requestListener.onRequest(packet);
            Packet header = this.createHeaderPacket((byte)2, requestId);
            Packet rc = AppendedPacket.join(header, packet);
            Object object = this.writeMutex;
            synchronized (object) {
                super.write(rc);
            }
        }
        catch (IOException e) {
            super.onPacketError(e);
        }
    }

    private void serviceReponse(Packet packet) {
        try {
            PacketData data = new PacketData(packet);
            short requestId = data.readShort();
            Slot responseSlot = (Slot)this.requestMap.get((Object)new Short(requestId));
            responseSlot.put((Object)packet);
        }
        catch (IOException e) {
            super.onPacketError(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet request(Packet request, long timeout) throws IOException {
        Short requestId = new Short(this.getNextRequestId());
        Slot responseSlot = new Slot();
        this.requestMap.put((Object)requestId, (Object)responseSlot);
        Packet header = this.createHeaderPacket((byte)1, requestId);
        Packet packet = AppendedPacket.join(header, request);
        Object object = this.writeMutex;
        synchronized (object) {
            super.write(packet);
        }
        try {
            if (timeout == -1L) {
                object = (Packet)responseSlot.take();
                return object;
            }
            if (timeout == 0L) {
                object = (Packet)responseSlot.poll(1L);
                return object;
            }
            object = (Packet)responseSlot.poll(timeout);
            return object;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        finally {
            this.requestMap.remove((Object)requestId);
        }
    }

    private Packet createHeaderPacket(byte type, short requestId) throws IOException {
        ByteArrayPacket header = new ByteArrayPacket(new byte[]{3});
        PacketData data = new PacketData(header);
        data.writeByte(type);
        data.writeShort(requestId);
        header.flip();
        return header;
    }

    public void setRequestListener(RequestListener requestListener) throws IOException {
        this.requestListener = requestListener;
    }

    public RequestListener getRequestListener() {
        return this.requestListener;
    }
}

