/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Channel;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.adapter.SynchToAsynchChannelAdapter;

public final class AsynchToSynchChannelAdapter
implements SynchChannel,
AsynchChannelListener {
    private final AsynchChannel asynchChannel;
    private final EDU.oswego.cs.dl.util.concurrent.Channel buffer;

    public static SynchChannel adapt(Channel channel) {
        return AsynchToSynchChannelAdapter.adapt(channel, (EDU.oswego.cs.dl.util.concurrent.Channel)new LinkedQueue());
    }

    public static SynchChannel adapt(Channel channel, EDU.oswego.cs.dl.util.concurrent.Channel upPacketChannel) {
        if (channel instanceof SynchChannel) {
            return (SynchChannel)channel;
        }
        if (channel.getClass() == SynchToAsynchChannelAdapter.class) {
            return ((SynchToAsynchChannelAdapter)channel).getSynchChannel();
        }
        return new AsynchToSynchChannelAdapter((AsynchChannel)channel, upPacketChannel);
    }

    public AsynchToSynchChannelAdapter(AsynchChannel asynchChannel) {
        this(asynchChannel, (EDU.oswego.cs.dl.util.concurrent.Channel)new LinkedQueue());
    }

    public AsynchToSynchChannelAdapter(AsynchChannel asynchChannel, EDU.oswego.cs.dl.util.concurrent.Channel upPacketChannel) {
        this.asynchChannel = asynchChannel;
        this.asynchChannel.setAsynchChannelListener(this);
        this.buffer = upPacketChannel;
    }

    public void write(Packet packet) throws IOException {
        this.asynchChannel.write(packet);
    }

    public void flush() throws IOException {
        this.asynchChannel.flush();
    }

    public Packet read(long timeout) throws IOException {
        try {
            Object o = timeout == 0L ? this.buffer.poll(0L) : (timeout == -1L ? this.buffer.take() : this.buffer.poll(timeout));
            if (o == null) {
                return null;
            }
            if (o instanceof Packet) {
                return (Packet)o;
            }
            Throwable e = (Throwable)o;
            throw (IOException)new IOException("Asynch error occured: " + e).initCause(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public void dispose() {
        this.asynchChannel.dispose();
    }

    public void start() throws IOException {
        this.asynchChannel.start();
    }

    public void stop(long timeout) throws IOException {
        this.asynchChannel.stop(timeout);
    }

    public void onPacket(Packet packet) {
        try {
            this.buffer.put((Object)packet);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onPacketError(IOException error) {
        try {
            this.buffer.put((Object)error);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.asynchChannel.narrow(target);
    }

    public AsynchChannel getAsynchChannel() {
        return this.asynchChannel;
    }

    public String toString() {
        return this.asynchChannel.toString();
    }
}

