/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.adapter.SynchChannelInputStream;
import org.activeio.adapter.SynchChannelOutputStream;
import org.activeio.net.SocketMetadata;
import org.activeio.packet.ByteArrayPacket;

public class SynchChannelToSocketAdapter
extends Socket {
    private final SynchChannel channel;
    private final SynchChannelInputStream inputStream;
    private final SynchChannelOutputStream outputStream;
    private final SocketMetadata socketMetadata;
    private final Packet urgentPackget = new ByteArrayPacket(new byte[1]);
    boolean closed;

    public SynchChannelToSocketAdapter(SynchChannel channel) {
        this(channel, (SocketMetadata)channel.narrow(SocketMetadata.class));
    }

    public SynchChannelToSocketAdapter(SynchChannel channel, SocketMetadata socketMetadata) {
        this.channel = channel;
        this.socketMetadata = socketMetadata;
        this.inputStream = new SynchChannelInputStream(channel);
        this.outputStream = new SynchChannelOutputStream(channel);
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new IOException("Not supported");
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.inputStream.close();
        this.outputStream.close();
        this.channel.dispose();
    }

    public void connect(SocketAddress endpoint) throws IOException {
        throw new IOException("Not supported");
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new IOException("Not supported");
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public boolean isInputShutdown() {
        return this.inputStream.isClosed();
    }

    public boolean isOutputShutdown() {
        return this.outputStream.isClosed();
    }

    public void sendUrgentData(int data) throws IOException {
        this.urgentPackget.clear();
        this.urgentPackget.write(data);
        this.urgentPackget.flip();
        this.channel.write(this.urgentPackget);
    }

    public int getSoTimeout() throws SocketException {
        return (int)this.inputStream.getTimeout();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.inputStream.setTimeout(timeout);
    }

    public void shutdownOutput() throws IOException {
        this.outputStream.close();
    }

    public void shutdownInput() throws IOException {
        this.inputStream.close();
    }

    protected SocketMetadata getSocketMetadata() throws SocketException {
        if (this.socketMetadata == null) {
            throw new SocketException("No socket metadata available.");
        }
        return this.socketMetadata;
    }

    public InetAddress getInetAddress() {
        if (this.socketMetadata == null) {
            return null;
        }
        return this.socketMetadata.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.getSocketMetadata().getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        if (this.socketMetadata == null) {
            return null;
        }
        return this.socketMetadata.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.socketMetadata == null) {
            return -1;
        }
        return this.socketMetadata.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.socketMetadata == null) {
            return null;
        }
        return this.socketMetadata.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.getSocketMetadata().getOOBInline();
    }

    public int getPort() {
        if (this.socketMetadata == null) {
            return -1;
        }
        return this.socketMetadata.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.getSocketMetadata().getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.socketMetadata == null) {
            return null;
        }
        return this.socketMetadata.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.getSocketMetadata().getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.getSocketMetadata().getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.getSocketMetadata().getSoLinger();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.getSocketMetadata().getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.getSocketMetadata().getTrafficClass();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.getSocketMetadata().setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.getSocketMetadata().setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.getSocketMetadata().setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.getSocketMetadata().setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.getSocketMetadata().setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.getSocketMetadata().setSoLinger(on, linger);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.getSocketMetadata().setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.getSocketMetadata().setTrafficClass(tc);
    }
}

