/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Channel;
import org.activeio.ChannelFactory;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.adapter.AsynchToSynchChannelAdapter;
import org.activeio.packet.EOSPacket;

public final class SynchToAsynchChannelAdapter
implements AsynchChannel,
Runnable {
    private final SynchronizedBoolean running = new SynchronizedBoolean(false);
    private final SynchChannel synchChannel;
    private final Executor executor;
    private AsynchChannelListener channelListener;
    private Latch doneLatch;

    public static AsynchChannel adapt(Channel channel) {
        return SynchToAsynchChannelAdapter.adapt(channel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public static AsynchChannel adapt(Channel channel, Executor executor) {
        if (channel instanceof AsynchChannel) {
            return (AsynchChannel)channel;
        }
        if (channel.getClass() == SynchToAsynchChannelAdapter.class) {
            return ((AsynchToSynchChannelAdapter)channel).getAsynchChannel();
        }
        return new SynchToAsynchChannelAdapter((SynchChannel)channel, executor);
    }

    public SynchToAsynchChannelAdapter(SynchChannel synchChannel) {
        this(synchChannel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public SynchToAsynchChannelAdapter(SynchChannel synchChannel, Executor executor) {
        this.synchChannel = synchChannel;
        this.executor = executor;
    }

    public synchronized void start() throws IOException {
        if (this.running.commit(false, true)) {
            if (this.channelListener == null) {
                throw new IllegalStateException("UpPacketListener must be set before object can be started.");
            }
            this.synchChannel.start();
            try {
                this.doneLatch = new Latch();
                this.executor.execute((Runnable)this);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    public synchronized void stop(long timeout) throws IOException {
        if (this.running.commit(true, false)) {
            try {
                if (timeout == 0L) {
                    this.synchChannel.stop(0L);
                } else if (timeout == -1L) {
                    this.doneLatch.acquire();
                    this.synchChannel.stop(-1L);
                } else {
                    long start = System.currentTimeMillis();
                    timeout = this.doneLatch.attempt(timeout) ? (timeout -= System.currentTimeMillis() - start) : 0L;
                    if (timeout <= 0L) {
                        this.synchChannel.stop(0L);
                    } else {
                        this.synchChannel.stop(timeout);
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (IOException)new IOException("stop failed: " + e.getMessage()).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.synchChannel.toString());
        try {
            while (this.running.get()) {
                Packet packet;
                block10: {
                    packet = this.synchChannel.read(500L);
                    if (packet == null) continue;
                    if (packet != EOSPacket.EOS_PACKET) break block10;
                    this.channelListener.onPacket(packet);
                    Object var4_5 = null;
                    if (this.doneLatch != null) {
                        this.doneLatch.release();
                    }
                    Thread.currentThread().setName(oldName);
                    return;
                }
                try {
                    if (!packet.hasRemaining()) continue;
                    this.channelListener.onPacket(packet);
                }
                catch (IOException e) {
                    this.channelListener.onPacketError(e);
                }
                catch (Throwable e) {
                    this.channelListener.onPacketError((IOException)new IOException("Unexpected Error: " + e).initCause(e));
                }
            }
            Object var4_6 = null;
            if (this.doneLatch != null) {
                this.doneLatch.release();
            }
            Thread.currentThread().setName(oldName);
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (this.doneLatch != null) {
                this.doneLatch.release();
            }
            Thread.currentThread().setName(oldName);
            throw throwable;
        }
    }

    public void setAsynchChannelListener(AsynchChannelListener channelListener) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot change the UpPacketListener while the object is running.");
        }
        this.channelListener = channelListener;
    }

    public void write(Packet packet) throws IOException {
        this.synchChannel.write(packet);
    }

    public void flush() throws IOException {
        this.synchChannel.flush();
    }

    public void dispose() {
        try {
            this.stop(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.synchChannel.dispose();
    }

    public AsynchChannelListener getAsynchChannelListener() {
        return this.channelListener;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.synchChannel.narrow(target);
    }

    public SynchChannel getSynchChannel() {
        return this.synchChannel;
    }

    public String toString() {
        return this.synchChannel.toString();
    }
}

