/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.journal.active;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import org.activeio.Packet;
import org.activeio.journal.active.Location;
import org.activeio.journal.active.Record;

public final class BatchedWrite {
    private final Packet packet;
    public Throwable error;
    private Location mark;
    private boolean appendDisabled = false;
    private boolean appendInProgress = false;
    private Latch writeDoneLatch;

    public BatchedWrite(Packet packet) {
        this.packet = packet;
    }

    private synchronized void disableAppend() throws InterruptedException {
        this.appendDisabled = true;
        while (this.appendInProgress) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Record record, Location recordMark, boolean force) {
        BatchedWrite batchedWrite = this;
        synchronized (batchedWrite) {
            if (this.appendDisabled) {
                return false;
            }
            this.appendInProgress = true;
        }
        if (force && this.writeDoneLatch == null) {
            this.writeDoneLatch = new Latch();
        }
        record.read(this.packet);
        if (!record.hasRemaining() && recordMark != null) {
            this.mark = recordMark;
        }
        batchedWrite = this;
        synchronized (batchedWrite) {
            this.appendInProgress = false;
            this.notify();
            if (this.appendDisabled) {
                return false;
            }
            return this.packet.remaining() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForForce() throws Throwable {
        if (this.writeDoneLatch != null) {
            this.writeDoneLatch.acquire();
            BatchedWrite batchedWrite = this;
            synchronized (batchedWrite) {
                if (this.error != null) {
                    throw this.error;
                }
            }
        }
    }

    public void forced() {
        if (this.writeDoneLatch != null) {
            this.writeDoneLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFailed(Throwable error) {
        if (this.writeDoneLatch != null) {
            BatchedWrite batchedWrite = this;
            synchronized (batchedWrite) {
                this.error = error;
            }
            this.writeDoneLatch.release();
        }
    }

    public Packet getPacket() {
        return this.packet;
    }

    public Location getMark() {
        return this.mark;
    }

    public void flip() throws InterruptedException {
        this.disableAppend();
        this.packet.flip();
    }

    public boolean getForce() {
        return this.writeDoneLatch != null;
    }
}

