/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import com.ibm.io.async.AsyncServerSocketChannel;
import com.ibm.io.async.AsyncSocketChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelFactory;
import org.activeio.AsynchChannelServer;
import org.activeio.adapter.SynchToAsynchChannelServerAdapter;
import org.activeio.filter.WriteBufferedAsynchChannel;
import org.activeio.net.AIOAsynchChannel;
import org.activeio.net.AIOSynchChannelServer;
import org.activeio.net.URISupport;
import org.activeio.packet.ByteBufferPacket;

public class AIOAsynchChannelFactory
implements AsynchChannelFactory {
    protected static final int DEFAULT_BACKLOG = 500;
    private int backlog = 500;

    public AsynchChannel openAsynchChannel(URI location) throws IOException {
        AsyncSocketChannel channel = AsyncSocketChannel.open();
        channel.connect((SocketAddress)new InetSocketAddress(location.getHost(), location.getPort()));
        return this.createAsynchChannel(channel);
    }

    protected AsynchChannel createAsynchChannel(AsyncSocketChannel socketChannel) throws IOException {
        AsynchChannel channel = new AIOAsynchChannel(socketChannel);
        channel = new WriteBufferedAsynchChannel(channel, ByteBufferPacket.createDefaultBuffer(true), false);
        return channel;
    }

    public AsynchChannelServer bindAsynchChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetSocketAddress address = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") ? new InetSocketAddress(bindURI.getPort()) : new InetSocketAddress(bindURI.getHost(), bindURI.getPort());
        AsyncServerSocketChannel serverSocketChannel = AsyncServerSocketChannel.open();
        serverSocketChannel.socket().bind(address, this.backlog);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changeHost(connectURI, InetAddress.getLocalHost().getHostName());
            connectURI = URISupport.changePort(connectURI, serverSocketChannel.socket().getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could not build connect URI: " + e).initCause(e);
        }
        return SynchToAsynchChannelServerAdapter.adapt(new AIOSynchChannelServer(serverSocketChannel, bindURI, connectURI));
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

