/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.activeio.Packet;
import org.activeio.SynchChannel;
import org.activeio.net.DatagramContext;
import org.activeio.packet.ByteArrayPacket;
import org.activeio.packet.FilterPacket;

public final class DatagramSocketSynchChannel
implements SynchChannel {
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private final DatagramSocket socket;
    private boolean disposed;
    private int curentSoTimeout;

    protected DatagramSocketSynchChannel(DatagramSocket socket) throws IOException {
        this.socket = socket;
        socket.setReceiveBufferSize(65536);
        socket.setSendBufferSize(65536);
    }

    public Packet read(long timeout) throws IOException {
        try {
            if (timeout == -1L) {
                this.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.setSoTimeout(1);
            } else {
                this.setSoTimeout((int)timeout);
            }
            byte[] data = new byte[65536];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            this.socket.receive(packet);
            return new UDPFilterPacket(new ByteArrayPacket(data, 0, packet.getLength()), packet);
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    private void setSoTimeout(int i) throws SocketException {
        if (this.curentSoTimeout != i) {
            this.socket.setSoTimeout(i);
            this.curentSoTimeout = i;
        }
    }

    public void write(Packet packet) throws IOException {
        Packet.ByteSequence sequence = packet.asByteSequence();
        DatagramContext context = (DatagramContext)packet.narrow(DatagramContext.class);
        if (context != null) {
            this.socket.send(new DatagramPacket(sequence.getData(), sequence.getOffset(), sequence.getLength(), context.address, context.port));
        } else {
            this.socket.send(new DatagramPacket(sequence.getData(), sequence.getOffset(), sequence.getLength()));
        }
    }

    public void flush() throws IOException {
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.socket.close();
        this.disposed = true;
    }

    public void start() throws IOException {
    }

    public void stop(long timeout) throws IOException {
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "Datagram Connection: " + this.socket.getLocalSocketAddress() + " -> " + this.socket.getRemoteSocketAddress();
    }

    private final class UDPFilterPacket
    extends FilterPacket {
        private final DatagramPacket packet;

        private UDPFilterPacket(Packet next, DatagramPacket packet) {
            super(next);
            this.packet = packet;
        }

        public Object narrow(Class target) {
            if (target == (class$org$activeio$net$DatagramContext == null ? (class$org$activeio$net$DatagramContext = DatagramSocketSynchChannel.class$("org.activeio.net.DatagramContext")) : class$org$activeio$net$DatagramContext)) {
                return new DatagramContext(this.packet);
            }
            return super.narrow(target);
        }

        public Packet filter(Packet packet) {
            return new UDPFilterPacket(packet, this.packet);
        }
    }
}

