/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelFactory;
import org.activeio.AsynchChannelServer;
import org.activeio.adapter.SynchToAsynchChannelServerAdapter;
import org.activeio.filter.WriteBufferedAsynchChannel;
import org.activeio.net.NIOAsynchChannel;
import org.activeio.net.NIOAsynchChannelServer;
import org.activeio.net.URISupport;
import org.activeio.packet.ByteBufferPacket;

public class NIOAsynchChannelFactory
implements AsynchChannelFactory {
    protected static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.activeio.net.nio.BufferSize", "65536"));
    protected static final int DEFAULT_BACKLOG = 500;
    boolean useDirectBuffers = true;
    private final boolean createWriteBufferedChannels;
    private int backlog = 500;

    public NIOAsynchChannelFactory() {
        this(true);
    }

    public NIOAsynchChannelFactory(boolean createWriteBufferedChannels) {
        this.createWriteBufferedChannels = createWriteBufferedChannels;
    }

    public AsynchChannel openAsynchChannel(URI location) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(location.getHost(), location.getPort()));
        return this.createAsynchChannel(channel);
    }

    protected AsynchChannel createAsynchChannel(SocketChannel socketChannel) throws IOException {
        AsynchChannel channel = new NIOAsynchChannel(socketChannel, this.useDirectBuffers);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedAsynchChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers), false);
        }
        return channel;
    }

    public AsynchChannelServer bindAsynchChannel(URI bindURI) throws IOException {
        String host = bindURI.getHost();
        InetSocketAddress address = host == null || host.length() == 0 || host.equals("localhost") || host.equals("0.0.0.0") ? new InetSocketAddress(bindURI.getPort()) : new InetSocketAddress(bindURI.getHost(), bindURI.getPort());
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().bind(address, this.backlog);
        URI connectURI = bindURI;
        try {
            connectURI = URISupport.changeHost(connectURI, InetAddress.getLocalHost().getHostName());
            connectURI = URISupport.changePort(connectURI, serverSocketChannel.socket().getLocalPort());
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException("Could not build connect URI: " + e).initCause(e);
        }
        return SynchToAsynchChannelServerAdapter.adapt(new NIOAsynchChannelServer(serverSocketChannel, bindURI, connectURI, this.createWriteBufferedChannels, this.useDirectBuffers));
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }
}

