/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.activeio.AsynchChannel;
import org.activeio.Channel;
import org.activeio.filter.WriteBufferedAsynchChannel;
import org.activeio.net.NIOAsynchChannel;
import org.activeio.net.SocketSynchChannelServer;
import org.activeio.packet.ByteBufferPacket;

public class NIOAsynchChannelServer
extends SocketSynchChannelServer {
    private final boolean createWriteBufferedChannels;
    private final boolean useDirectBuffers;

    public NIOAsynchChannelServer(ServerSocketChannel socketChannel, URI bindURI, URI connectURI, boolean createWriteBufferedChannels, boolean useDirectBuffers) {
        super(socketChannel.socket(), bindURI, connectURI);
        this.createWriteBufferedChannels = createWriteBufferedChannels;
        this.useDirectBuffers = useDirectBuffers;
    }

    protected Channel createChannel(Socket socket) throws IOException {
        AsynchChannel channel = new NIOAsynchChannel(socket.getChannel(), this.useDirectBuffers);
        if (this.createWriteBufferedChannels) {
            channel = new WriteBufferedAsynchChannel(channel, ByteBufferPacket.createDefaultBuffer(this.useDirectBuffers), false);
        }
        return channel;
    }
}

