/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.DesktopPane;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.MenuBar;
import jp.co.argo21.nautica.tool.wfadm.StatusBar;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.common.OpenEngineDialog;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterDialog;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterInfo;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterInfoComponent;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;

public class WorkflowAdminFrame
extends JFrame {
    private MenuBar menuBar;
    private DesktopPane desktop;
    private StatusBar statusBar;

    public WorkflowAdminFrame() throws HeadlessException {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.initInputMap();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screen = toolkit.getScreenSize();
        int sw = screen.width;
        int sh = screen.height;
        this.menuBar = new MenuBar();
        this.desktop = new DesktopPane();
        this.statusBar = new StatusBar();
        this.setTitle(rm.getResource("WorkflowAdminFrame.title"));
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.menuBar);
        Container contentPane = this.getContentPane();
        BorderLayout layout = new BorderLayout();
        contentPane.setLayout(layout);
        contentPane.add((Component)this.desktop, "Center");
        contentPane.add((Component)this.statusBar, "South");
        int fw = (int)((double)sw * 0.95);
        int fh = (int)((double)sh * 0.95);
        this.setSize(new Dimension(fw, fh));
        this.setLocation((sw - fw) / 2, 0);
        this.setIconImage(((ImageIcon)IconManager.getIcon("application")).getImage());
        this.validate();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            ActionMap am = WorkflowAdminManager.getActionMap();
            Action action = am.get("exit");
            action.actionPerformed(null);
        } else {
            this.repaint();
        }
    }

    public void notifyApplicationWillExit() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.setVisible(false);
        this.dispose();
    }

    private void initInputMap() {
        JComponent c = (JComponent)this.getContentPane();
        ActionMap am = WorkflowAdminManager.getActionMap();
        c.setActionMap(am);
        InputMap inputmap = c.getInputMap(2);
        inputmap.put(KeyStroke.getKeyStroke(79, 2), "openEngine");
        inputmap.put(KeyStroke.getKeyStroke(81, 2), "exit");
        inputmap.put(KeyStroke.getKeyStroke(122, 0), "exceptionViewer");
        inputmap.put(KeyStroke.getKeyStroke(112, 0), "help");
        inputmap.put(KeyStroke.getKeyStroke(72, 2), "help");
    }

    public void registerDefinition() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        EngineInfo einfo = OpenEngineDialog.showDialog(this);
        if (einfo == null) {
            return;
        }
        RegisterInfoComponent comp = new RegisterInfoComponent();
        RegisterInfo rinfo = null;
        if (!RegisterDialog.showDialog(this, comp)) {
            return;
        }
        rinfo = comp.getRegisterInfo();
        if (rinfo == null) {
            return;
        }
        RegisterDefinitionTask task = new RegisterDefinitionTask(einfo, rinfo);
        WorkflowAdminManager.runBusyTask(task);
    }

    public void openEngine() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        EngineInfo einfo = OpenEngineDialog.showDialog(this);
        if (einfo == null) {
            return;
        }
        OpenEngineTask task = new OpenEngineTask(einfo);
        WorkflowAdminManager.runBusyTask(task);
    }

    public void shutdownEngine() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        EngineInfo einfo = OpenEngineDialog.showDialog(this);
        if (einfo == null) {
            return;
        }
        int ret = DialogUtilities.showYesNoConfirm(rm.getResource("I9006") + " " + einfo.getName() + " " + rm.getResource("I9006-1"));
        if (ret == 1) {
            return;
        }
        ShutdownEngineTask task = new ShutdownEngineTask(einfo);
        WorkflowAdminManager.runBusyTask(task);
    }

    class ShutdownEngineTask
    implements BusyTask {
        private EngineInfo einfo;
        private int state = 0;

        ShutdownEngineTask(EngineInfo einfo) {
            this.einfo = einfo;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                String session;
                WorkflowServiceAccessor wsa;
                ResourceManager rm;
                block10: {
                    this.state = 1;
                    rm = WorkflowAdminManager.getResourceManager();
                    String adminKey = this.einfo.getAdminKey();
                    wsa = this.einfo.getWorkflowServiceAccessor();
                    session = null;
                    session = wsa.open();
                    WorkflowAdminHandlerRemote wah = wsa.getWorkflowAdminHandler();
                    wah.shutdown(session, adminKey);
                    DialogUtilities.showInfo(rm.getResource("I9001") + "(" + this.einfo.getName() + ")");
                    Object var8_7 = null;
                    if (session == null) break block10;
                    try {
                        wsa.close();
                    }
                    catch (Exception ex2) {
                        ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                        ev2.setThrowable(ex2);
                    }
                }
                this.state = 2;
                {
                    break block11;
                    catch (Exception ex) {
                        ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                        ev.setThrowable(ex);
                        DialogUtilities.showError(rm.getResource("E9020") + "(" + this.einfo.getName() + ")");
                        Object var8_8 = null;
                        if (session != null) {
                            try {
                                wsa.close();
                            }
                            catch (Exception ex2) {
                                ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                                ev2.setThrowable(ex2);
                            }
                        }
                        this.state = 2;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (session != null) {
                        try {
                            wsa.close();
                        }
                        catch (Exception ex2) {
                            ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                            ev2.setThrowable(ex2);
                        }
                    }
                    this.state = 2;
                    throw throwable;
                }
            }
        }
    }

    class OpenEngineTask
    implements BusyTask {
        private EngineInfo einfo;
        private int state = 0;

        OpenEngineTask(EngineInfo einfo) {
            this.einfo = einfo;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.state = 1;
            try {
                ResourceManager rm = WorkflowAdminManager.getResourceManager();
                EngineViewController evc = new EngineViewController(this.einfo);
                if (evc.checkEngineConnection()) {
                    String title = this.einfo.getName();
                    EngineViewFrame view = new EngineViewFrame(title, evc);
                    Point p = WorkflowAdminFrame.this.desktop.getNextLocation();
                    WorkflowAdminFrame.this.desktop.add(view);
                    view.setLocation(p);
                    view.setVisible(true);
                } else {
                    DialogUtilities.showError(rm.getResource("E9013") + "(" + this.einfo.getName() + ")");
                }
            }
            finally {
                this.state = 2;
            }
        }
    }

    class RegisterDefinitionTask
    implements BusyTask {
        private EngineInfo einfo;
        private RegisterInfo rinfo;
        private int state = 0;

        RegisterDefinitionTask(EngineInfo einfo, RegisterInfo rinfo) {
            this.einfo = einfo;
            this.rinfo = rinfo;
        }

        public int getState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block11: {
                String session;
                WorkflowServiceAccessor wsa;
                String pname;
                ResourceManager rm;
                block10: {
                    this.state = 1;
                    rm = WorkflowAdminManager.getResourceManager();
                    String adminKey = this.einfo.getAdminKey();
                    pname = this.rinfo.getPackageName();
                    String rpath = this.rinfo.getRegisterPath();
                    wsa = this.einfo.getWorkflowServiceAccessor();
                    session = null;
                    session = wsa.open();
                    DefinitionRepositoryRemote dr = wsa.getDefinitionRepository();
                    dr.registerDefinition(session, pname, rpath);
                    DialogUtilities.showInfo(rm.getResource("I9002") + "(" + pname + ")");
                    Object var10_9 = null;
                    if (session == null) break block10;
                    try {
                        wsa.close();
                    }
                    catch (Exception ex2) {
                        ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                        ev2.setThrowable(ex2);
                    }
                }
                this.state = 2;
                {
                    break block11;
                    catch (Exception ex) {
                        ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
                        ev.setThrowable(ex);
                        DialogUtilities.showError(rm.getResource("E9025") + "(" + pname + ")");
                        Object var10_10 = null;
                        if (session != null) {
                            try {
                                wsa.close();
                            }
                            catch (Exception ex2) {
                                ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                                ev2.setThrowable(ex2);
                            }
                        }
                        this.state = 2;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (session != null) {
                        try {
                            wsa.close();
                        }
                        catch (Exception ex2) {
                            ExceptionViewer ev2 = WorkflowAdminManager.getExceptionViewer();
                            ev2.setThrowable(ex2);
                        }
                    }
                    this.state = 2;
                    throw throwable;
                }
            }
        }
    }
}

