/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.Expression;

public class ActivityDefinitionPropertyComponent
extends DialogComponent {
    private static String[] pColumnNames;
    private static String[] tColumnNames;
    private static String[] conditionTypes;
    protected static final Border border;
    private JTable transitionTable;
    private JTextArea conditionArea;
    private Properties properties;
    private List transitions;
    private List variables;
    static /* synthetic */ Class class$java$lang$String;

    ActivityDefinitionPropertyComponent(Properties prop, List trs, List vars) {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.properties = prop;
        this.transitions = trs;
        this.variables = vars;
        JPanel pPanel = this.createPropertyPanel(rm);
        this.addTab(rm.getResource("ActivityDefinitionPropertyComponent.tab.0"), pPanel);
        JPanel tPanel = this.createTransitionInfoPanel(rm);
        this.addTab(rm.getResource("ActivityDefinitionPropertyComponent.tab.1"), tPanel);
        this.validate();
    }

    private JPanel createPropertyPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(500, 150);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JTable propertyTable = new JTable(new PropertyTableModel());
        propertyTable.setSelectionMode(0);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(propertyTable);
        panel.add((Component)sp, "Center");
        this.validate();
        return panel;
    }

    private JPanel createTransitionInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(500, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        this.transitionTable = new JTable(new TransitionTableModel());
        this.transitionTable.setSelectionMode(0);
        ListSelectionModel tlsm = this.transitionTable.getSelectionModel();
        tlsm.addListSelectionListener(new TransitionSelectAction());
        JScrollPane sp1 = new JScrollPane();
        sp1.setViewportView(this.transitionTable);
        sp1.setPreferredSize(new Dimension(500, 100));
        this.conditionArea = new JTextArea();
        this.conditionArea.setLineWrap(true);
        this.conditionArea.setEditable(false);
        JScrollPane sp2 = new JScrollPane();
        sp2.setViewportView(this.conditionArea);
        JSplitPane split = new JSplitPane(0, sp1, sp2);
        split.setDividerLocation(120);
        panel.add((Component)split, "Center");
        this.validate();
        return panel;
    }

    public void init() {
    }

    public boolean commit() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        pColumnNames = new String[2];
        ActivityDefinitionPropertyComponent.pColumnNames[0] = rm.getResource("PropertyComponent.columnName.0");
        ActivityDefinitionPropertyComponent.pColumnNames[1] = rm.getResource("PropertyComponent.columnName.1");
        tColumnNames = new String[2];
        ActivityDefinitionPropertyComponent.tColumnNames[0] = rm.getResource("TransitionTableModel.columnName.0");
        ActivityDefinitionPropertyComponent.tColumnNames[1] = rm.getResource("TransitionTableModel.columnName.1");
        conditionTypes = new String[5];
        ActivityDefinitionPropertyComponent.conditionTypes[0] = rm.getResource("TransitionTableModel.conditionType.0");
        ActivityDefinitionPropertyComponent.conditionTypes[1] = rm.getResource("TransitionTableModel.conditionType.1");
        ActivityDefinitionPropertyComponent.conditionTypes[2] = rm.getResource("TransitionTableModel.conditionType.2");
        ActivityDefinitionPropertyComponent.conditionTypes[3] = rm.getResource("TransitionTableModel.conditionType.3");
        ActivityDefinitionPropertyComponent.conditionTypes[4] = rm.getResource("TransitionTableModel.conditionType.4");
    }

    class TransitionTableModel
    extends AbstractTableModel {
        TransitionTableModel() {
        }

        public int getColumnCount() {
            return tColumnNames.length;
        }

        public int getRowCount() {
            return ActivityDefinitionPropertyComponent.this.transitions.size();
        }

        public String getColumnName(int col) {
            return tColumnNames[col];
        }

        public Object getValueAt(int row, int col) {
            TransitionDefinition tr = (TransitionDefinition)ActivityDefinitionPropertyComponent.this.transitions.get(row);
            if (col == 0) {
                return tr.getDestination().getName();
            }
            int type = tr.getType();
            if (type == 2) {
                return conditionTypes[1];
            }
            if (type == 3) {
                return conditionTypes[2];
            }
            if (type == 4) {
                return conditionTypes[3];
            }
            if (tr.getCondition() == null) {
                return conditionTypes[4];
            }
            return conditionTypes[0];
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = ActivityDefinitionPropertyComponent.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class TransitionSelectAction
    implements ListSelectionListener {
        TransitionSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                Expression exp = ((TransitionDefinition)ActivityDefinitionPropertyComponent.this.transitions.get(selected)).getCondition();
                if (exp != null) {
                    ActivityDefinitionPropertyComponent.this.conditionArea.setText(exp.getExpressionString(ActivityDefinitionPropertyComponent.this.variables));
                } else {
                    ActivityDefinitionPropertyComponent.this.conditionArea.setText("");
                }
            }
        }
    }

    class PropertyTableModel
    extends AbstractTableModel {
        PropertyTableModel() {
        }

        public int getColumnCount() {
            return pColumnNames.length;
        }

        public int getRowCount() {
            if (ActivityDefinitionPropertyComponent.this.properties == null) {
                return 0;
            }
            return ActivityDefinitionPropertyComponent.this.properties.size();
        }

        public String getColumnName(int col) {
            return pColumnNames[col];
        }

        public Object getValueAt(int row, int col) {
            block4: {
                Object[] keys;
                block3: {
                    if (ActivityDefinitionPropertyComponent.this.properties == null) {
                        return "";
                    }
                    Set<Object> keyset = ActivityDefinitionPropertyComponent.this.properties.keySet();
                    keys = keyset.toArray();
                    Arrays.sort(keys);
                    if (col != 0) break block3;
                    for (int i = 0; i < keys.length; ++i) {
                        if (i != row) continue;
                        return keys[i].toString();
                    }
                    break block4;
                }
                if (col != 1) break block4;
                for (int i = 0; i < keys.length; ++i) {
                    if (i != row) continue;
                    return ActivityDefinitionPropertyComponent.this.properties.get(keys[i]).toString();
                }
            }
            return "";
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = ActivityDefinitionPropertyComponent.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

