/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;

public class ConcurrentLayer {
    private ActivityDefinition start;
    private ActivityDefinition end;
    private ConcurrentLayer parentLayer;
    private List subLayers = new ArrayList();
    private List activities = new ArrayList();

    public ConcurrentLayer(ConcurrentLayer p, ActivityDefinition s, ActivityDefinition e) {
        this.parentLayer = p;
        this.start = s;
        this.end = e;
    }

    public ConcurrentLayer() {
    }

    public String getLayerID() {
        return this.start.getBlockID();
    }

    public void addLayerDefinition(ActivityDefinition def) {
        if (def == null) {
            return;
        }
        this.activities.add(def);
    }

    public void addLayer(ConcurrentLayer layer) {
        if (layer == null) {
            return;
        }
        this.addLayerDefinition(layer.getStartDefinition());
        this.addLayerDefinition(layer.getEndDefinition());
        this.subLayers.add(layer);
    }

    public void collectAllLayerDefinition(List list) {
        Iterator lit = this.subLayers.iterator();
        while (lit.hasNext()) {
            ConcurrentLayer layer = (ConcurrentLayer)lit.next();
            layer.collectAllLayerDefinition(list);
        }
        Iterator ait = this.activities.iterator();
        while (ait.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)ait.next();
            if (list.contains(act)) continue;
            list.add(act);
        }
        if (!list.contains(this.start)) {
            list.add(this.start);
        }
        if (!list.contains(this.end)) {
            list.add(this.end);
        }
    }

    public ActivityDefinition getStartDefinition() {
        return this.start;
    }

    public ActivityDefinition getEndDefinition() {
        return this.end;
    }

    public void paintLayerBackgroud(Graphics g, Color c, int grid) {
        int x = this.start.getLogicalX() * grid;
        int y = this.start.getLogicalY() * grid;
        int w = this.end.getLogicalX() * grid + grid - x;
        int h = this.end.getLogicalY() * grid + grid - y;
        g.setColor(c);
        g.fillRect(x, y, w, h);
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
        }
    }

    public void paintLayerBorder(Graphics g, Color c, int grid) {
        int x = this.start.getLogicalX() * grid;
        int y = this.start.getLogicalY() * grid;
        int w = this.end.getLogicalX() * grid + grid - x;
        int h = this.end.getLogicalY() * grid + grid - y;
        g.setColor(c);
        g.drawRect(x, y, w, h);
        g.drawRect(x + 1, y + 1, w - 2, h - 2);
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
        }
    }

    public void setEndDefinition(ActivityDefinition definition) {
        this.end = definition;
    }

    public void setParentLayer(ConcurrentLayer layer) {
        this.parentLayer = layer;
    }

    public void setStartDefinition(ActivityDefinition definition) {
        this.start = definition;
    }
}

