/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineTreeNode;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessDefinitionNode;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;

public class EngineNode
implements EngineTreeNode {
    private EngineViewFrame engineViewFrame;
    private Vector children;
    private Filter currentFilter;

    public EngineNode(EngineViewFrame frame) {
        this.engineViewFrame = frame;
        this.children = new Vector();
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        EngineViewController evc = this.engineViewFrame.getEngineViewController();
        EngineInfo info = evc.getEngineInfo();
        return info.getName();
    }

    public void reload(Filter filter) throws Exception {
        if (filter != null) {
            this.currentFilter = filter;
        }
        EngineViewController evc = this.engineViewFrame.getEngineViewController();
        ProcDef[] defs = evc.getProcessDefinition(this.currentFilter);
        this.children.clear();
        for (int i = 0; i < defs.length; ++i) {
            ProcessDefinitionNode child = new ProcessDefinitionNode(this, defs[i]);
            this.children.add(child);
        }
    }

    public Properties getProperties(ResourceManager rm) {
        Properties prop = new Properties();
        EngineViewController evc = this.engineViewFrame.getEngineViewController();
        EngineInfo info = evc.getEngineInfo();
        prop.put(rm.getResource("EngineNode.key.0"), info.getName());
        prop.put(rm.getResource("EngineNode.key.1"), info.getURL());
        prop.put(rm.getResource("EngineNode.key.2"), info.getScope());
        prop.put(rm.getResource("EngineNode.key.3"), info.getUser());
        prop.put(rm.getResource("EngineNode.key.4"), info.getPassword());
        prop.put(rm.getResource("EngineNode.key.5"), info.getAdminKey());
        return prop;
    }

    EngineViewFrame getFrame() {
        return this.engineViewFrame;
    }
}

